/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.finance.command;

import com.els.base.core.utils.Assert;
import com.els.base.finance.command.AbstractCommand;
import com.els.base.finance.command.ComandInvoker;
import com.els.base.finance.invetorySap.ZSRMRFCMKOLResponse;
import com.els.base.finance.invetorySap.ZSRMRFCRET;
import com.els.base.finance.service.impl.SapBillServiceImpl;
import com.els.base.finance.util.SapException;
import com.els.base.finance.util.SoapServiceRequestText;
import com.els.base.util.BillSapConfUtils;
import com.els.base.utils.reflect.ReflectUtils;
import com.els.liby.invetory.entity.SupInvetoryDetail;
import com.qqt.service.vo.HttpCallbackResultVO;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteBackInvetoryCommand
extends AbstractCommand<ZSRMRFCMKOLResponse> {
    private static Logger log = LoggerFactory.getLogger(SapBillServiceImpl.class);
    private static String username = BillSapConfUtils.getServiceUsername();
    private static String password = BillSapConfUtils.getServicePassword();
    private static String serviceUrl = BillSapConfUtils.getInvetoryUrl();
    private static String serviceNameSpace = BillSapConfUtils.getInvetoryNameSpace();
    private static String serviceMethod = BillSapConfUtils.getInvetoryServiceMethod();
    private List<SupInvetoryDetail> invetoryDetails;

    public WriteBackInvetoryCommand(List<SupInvetoryDetail> invetoryDetails) {
        this.invetoryDetails = invetoryDetails;
    }

    @Override
    public ZSRMRFCMKOLResponse execute(ComandInvoker context) {
        log.debug("\u3010\u4f9b\u5e94\u5546\u5e93\u5b58\u56de\u5199sap\u3011serviceUrl\u4e3a[{}]", (Object)serviceUrl);
        SoapServiceRequestText request = new SoapServiceRequestText();
        request.setUrl(serviceUrl);
        if (StringUtils.isNotBlank((String)serviceNameSpace)) {
            request.setNamespace(serviceNameSpace);
        }
        if (!StringUtils.isEmpty((String)username)) {
            String src = username.trim() + ":" + password.trim();
            String encoding = new String(Base64.encodeBase64((byte[])src.getBytes()));
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Basic " + encoding);
            request.addHeaders(headers);
        }
        request.setMethodName(serviceMethod);
        String xmlParams = this.getXmlParams(this.invetoryDetails);
        request.setXmlParams(xmlParams);
        log.debug("\u3010\u4f9b\u5e94\u5546\u5e93\u5b58\u56de\u5199sap\u3011\u8bf7\u6c42\u53c2\u6570\u4e3a[{}]", (Object)xmlParams);
        log.debug("\u3010\u4f9b\u5e94\u5546\u5e93\u5b58\u56de\u5199sap\u3011\u5f00\u59cb\u8c03\u7528sap\u63a5\u53e3");
        long startTime = System.currentTimeMillis();
        HttpCallbackResultVO vo = request.execute(ZSRMRFCMKOLResponse.class);
        long endTime = System.currentTimeMillis();
        log.debug("\u3010\u4f9b\u5e94\u5546\u5e93\u5b58\u56de\u5199sap\u3011\u7ed3\u675f\u8c03\u7528sap\u63a5\u53e3,\u7528\u65f6\u4e3a[{}]", (Object)(endTime - startTime));
        if (vo.getStatus() < 200 || vo.getStatus() > 299) {
            log.error("--> http status {}", (Object)vo.getStatus());
            log.error("--> ReasonPhrase {}", (Object)vo.getReasonPhrase());
            log.error("--> error {}", (Object)vo.getError());
            throw new SapException("sap\u4e1a\u52a1\u5f02\u5e38,\u56de\u5199sap\u5931\u8d25");
        }
        log.debug("\u3010\u4f9b\u5e94\u5546\u5e93\u5b58\u56de\u5199sap\u3011\u8fd4\u56de\u7ed3\u679c\u4e3a", vo.getResult());
        ZSRMRFCMKOLResponse respone = (ZSRMRFCMKOLResponse)vo.getResult();
        if (respone == null) {
            throw new SapException("\u4f9b\u5e94\u5546\u5e93\u5b58\u56de\u5199sap,\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
        }
        ZSRMRFCRET outData = respone.getESINFO();
        Assert.isNotNull((Object)outData, (String)"\u4f9b\u5e94\u5546\u5e93\u5b58\u56de\u5199sap,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        log.info("\u3010\u4f9b\u5e94\u5546\u5e93\u5b58\u56de\u5199sap\u30111\u3001\u83b7\u53d6\u5230\u6570\u636e");
        return respone;
    }

    private String getXmlParams(List<SupInvetoryDetail> invetoryDetails2) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        StringBuilder sbBuffer = new StringBuilder();
        sbBuffer.append("<IT_MKOL>");
        for (SupInvetoryDetail detail : invetoryDetails2) {
            sbBuffer.append("<item>");
            sbBuffer.append("<MANDT></MANDT>");
            sbBuffer.append("<LIFNR>" + detail.getSupplierSapCode() + "</LIFNR>");
            sbBuffer.append("<MATNR>" + detail.getMaterialCode() + "</MATNR>");
            sbBuffer.append("<ZSCDT>" + format.format(detail.getUploadTime()) + "</ZSCDT>");
            if (StringUtils.isEmpty((String)detail.getEndProductCode())) {
                sbBuffer.append("<CPWLH></CPWLH>");
            } else {
                sbBuffer.append("<CPWLH>" + detail.getEndProductCode() + "</CPWLH>");
            }
            if (StringUtils.isEmpty((String)detail.getSupplierName())) {
                sbBuffer.append("<NAME1></NAME1>");
            } else {
                sbBuffer.append("<NAME1>" + detail.getSupplierName() + "</NAME1>");
            }
            sbBuffer.append("<ZZPL>" + detail.getCategory() + "</ZZPL>");
            if (StringUtils.isEmpty((String)detail.getSpecifications())) {
                sbBuffer.append("<ZZGG></ZZGG>");
            } else {
                sbBuffer.append("<ZZGG>" + detail.getSpecifications() + "</ZZGG>");
            }
            sbBuffer.append("<ZZLX>" + detail.getType() + "</ZZLX>");
            if (StringUtils.isEmpty((String)detail.getAttribution())) {
                sbBuffer.append("<ZZSX></ZZSX>");
            } else {
                sbBuffer.append("<ZZSX>" + detail.getAttribution() + "</ZZSX>");
            }
            sbBuffer.append("<CPKCL>" + detail.getHavePoNumber() + "</CPKCL>");
            if (null != detail.getSemiFinishedNumber()) {
                sbBuffer.append("<BCPSL>" + detail.getSemiFinishedNumber() + "</BCPSL>");
            } else {
                sbBuffer.append("<BCPSL></BCPSL>");
            }
            sbBuffer.append("<MEINS>" + detail.getMeasurementUnit() + "</MEINS>");
            if (StringUtils.isEmpty((String)detail.getRemarks())) {
                sbBuffer.append("<ZZBZ></ZZBZ>");
            } else {
                sbBuffer.append("<ZZBZ>" + detail.getRemarks() + "</ZZBZ>");
            }
            this.appendDay(sbBuffer, detail);
            sbBuffer.append("</item>");
        }
        sbBuffer.append("</IT_MKOL>");
        return sbBuffer.toString();
    }

    private void appendDay(StringBuilder sbBuffer, SupInvetoryDetail detail) {
        Field[] fields = SupInvetoryDetail.class.getDeclaredFields();
        Stream<Field> lists = Arrays.asList(fields).stream().filter(field -> field.getName().contains("day")).filter(field -> Integer.valueOf(field.getName().split("day")[1]) <= 31);
        lists.forEach(field -> {
            Integer value = (Integer)ReflectUtils.getValue((Object)detail, (String)field.getName());
            if (value == null) {
                sbBuffer.append("<" + field.getName().toUpperCase() + "></" + field.getName().toUpperCase() + ">");
            } else {
                sbBuffer.append("<" + field.getName().toUpperCase() + "> " + value + "</" + field.getName().toUpperCase() + ">");
            }
        });
    }
}

