/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.supGroup.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.supGroup.dao.SupGroupRefMapper;
import com.els.base.supGroup.entity.SupGroupRef;
import com.els.base.supGroup.entity.SupGroupRefExample;
import com.els.base.supGroup.service.SupGroupRefService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultSupGroupRefService")
public class SupGroupRefServiceImpl
implements SupGroupRefService {
    @Resource
    protected SupGroupRefMapper supGroupRefMapper;

    @CacheEvict(value={"supGroupRef"}, allEntries=true)
    public void addObj(SupGroupRef t) {
        this.supGroupRefMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"supGroupRef"}, allEntries=true)
    public void addAll(List<SupGroupRef> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.supGroupRefMapper.insertBatch(list);
    }

    @CacheEvict(value={"supGroupRef"}, allEntries=true)
    public void deleteObjById(String id) {
        this.supGroupRefMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"supGroupRef"}, allEntries=true)
    public void deleteByExample(SupGroupRefExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.supGroupRefMapper.deleteByExample(example);
    }

    @CacheEvict(value={"supGroupRef"}, allEntries=true)
    public void modifyObj(SupGroupRef t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.supGroupRefMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"supGroupRef"}, keyGenerator="redisKeyGenerator")
    public SupGroupRef queryObjById(String id) {
        return this.supGroupRefMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"supGroupRef"}, keyGenerator="redisKeyGenerator")
    public List<SupGroupRef> queryAllObjByExample(SupGroupRefExample example) {
        return this.supGroupRefMapper.selectByExample(example);
    }

    @Cacheable(value={"supGroupRef"}, keyGenerator="redisKeyGenerator")
    public PageView<SupGroupRef> queryObjByPage(SupGroupRefExample example) {
        PageView<SupGroupRef> pageView = example.getPageView();
        pageView.setQueryResult(this.supGroupRefMapper.selectByExampleByPage(example));
        return pageView;
    }
}

