/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.voucher.controller;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.voucher.entity.BillVoucher;
import com.els.base.voucher.entity.BillVoucherExample;
import com.els.base.voucher.service.BillVoucherService;
import com.els.base.voucher.utils.BillVoucherEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u5f00\u7968\u6e05\u5355\u5165\u9000\u5e93\u51ed\u8bc1,\u6298\u8ba9\u5355")
@Controller
@RequestMapping(value={"billVoucher"})
public class BillVoucherController {
    @Resource
    protected BillVoucherService billVoucherService;

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u5f00\u7968\u6e05\u5355\u5165\u9000\u5e93\u51ed\u8bc1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillVoucher", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/voucher/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BillVoucher>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BillVoucherExample example = new BillVoucherExample();
        example.setPageView((PageView<BillVoucher>)new PageView(pageNo, pageSize));
        ArrayList<String> billType = new ArrayList<String>();
        billType.add(BillVoucherEnum.RECEIVE_GOODS.getCode());
        billType.add(BillVoucherEnum.RECEIVE_GOODS_CANCEL.getCode());
        billType.add(BillVoucherEnum.PURCHASE_RETURN_GOODS.getCode());
        billType.add(BillVoucherEnum.RETURN_GOODS_CANCEL.getCode());
        billType.add(BillVoucherEnum.RETURN_GOODS.getCode());
        billType.add(BillVoucherEnum.CANCEL_GOODS_CANCEL.getCode());
        BillVoucherExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andBillFlagEqualTo(Constant.NO_INT).andBillTypeIn(billType).andIsLatestEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billVoucherService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u6298\u8ba9\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BillVoucher", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/rebate/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BillVoucher>> findForRebateByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BillVoucherExample example = new BillVoucherExample();
        example.setPageView((PageView<BillVoucher>)new PageView(pageNo, pageSize));
        ArrayList<String> billType = new ArrayList<String>();
        billType.add(BillVoucherEnum.REBATE.getCode());
        BillVoucherExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andBillFlagEqualTo(Constant.NO_INT).andBillTypeIn(billType);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.billVoucherService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u6839\u636e\u5165\u9000\u5e93\u67e5\u8be2\u5176\u5173\u8054\u7684\u6298\u8ba9\u5355\u6570\u636e---\u53cd\u5411\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10")})
    @RequestMapping(value={"service/rebate/reverse/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BillVoucher>> findReverseRebateByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) List<BillVoucher> billVoucherList) {
        ArrayList<String> materialVoucherNoList = new ArrayList<String>();
        ArrayList<String> materialVoucherItemNoList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(billVoucherList)) {
            for (BillVoucher billVoucher : billVoucherList) {
                materialVoucherNoList.add(billVoucher.getMaterialVoucherNo());
                materialVoucherItemNoList.add(billVoucher.getMaterialVoucherItemNo());
            }
        }
        BillVoucherExample example = new BillVoucherExample();
        example.setPageView((PageView<BillVoucher>)new PageView(pageNo, pageSize));
        ArrayList<String> billType = new ArrayList<String>();
        billType.add(BillVoucherEnum.REBATE.getCode());
        BillVoucherExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(materialVoucherNoList)) {
            criteria.andIsEnableEqualTo(Constant.YES_INT).andBillFlagEqualTo(Constant.NO_INT).andMaterialVoucherNoNotIn(materialVoucherNoList).andMaterialVoucherItemNoNotIn(materialVoucherItemNoList).andBillTypeIn(billType);
        } else {
            criteria.andIsEnableEqualTo(Constant.YES_INT).andBillFlagEqualTo(Constant.NO_INT).andBillTypeIn(billType);
        }
        PageView pageData = this.billVoucherService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7ed3\u7b97\u7ba1\u7406-\u6839\u636e\u5165\u9000\u5e93\u67e5\u8be2\u5176\u5173\u8054\u7684\u6298\u8ba9\u5355\u6570\u636e---\u6b63\u5411\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10")})
    @RequestMapping(value={"service/rebate/positive/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BillVoucher>> findPositiveRebateByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) List<BillVoucher> billVoucherList) {
        if (CollectionUtils.isEmpty(billVoucherList)) {
            return ResponseResult.success((Object)new PageView());
        }
        ArrayList<String> materialVoucherNoList = new ArrayList<String>();
        ArrayList<String> materialVoucherItemNoList = new ArrayList<String>();
        for (BillVoucher billVoucher : billVoucherList) {
            Assert.isNotBlank((String)billVoucher.getMaterialVoucherNo(), (String)"\u7269\u6599\u51ed\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.isNotBlank((String)billVoucher.getMaterialVoucherItemNo(), (String)"\u7269\u6599\u51ed\u8bc1\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            materialVoucherNoList.add(billVoucher.getMaterialVoucherNo());
            materialVoucherItemNoList.add(billVoucher.getMaterialVoucherItemNo());
        }
        BillVoucherExample example = new BillVoucherExample();
        example.setPageView((PageView<BillVoucher>)new PageView(pageNo, pageSize));
        List<String> billType = Arrays.asList(BillVoucherEnum.REBATE.getCode());
        BillVoucherExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andBillFlagEqualTo(Constant.NO_INT).andMaterialVoucherNoIn(materialVoucherNoList).andMaterialVoucherItemNoIn(materialVoucherItemNoList).andBillTypeIn((List)billType);
        PageView pageData = this.billVoucherService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u5bfc\u51faSAP\u5bf9\u8d26\u660e\u7ec6")
    @RequestMapping(value={"service/exportSapBillDetail"})
    @ResponseBody
    public ModelAndView exportSapBillDetail(@RequestParam(required=true) String companyCode, @RequestParam(required=true) String supCompanySapCode, @RequestParam(required=true) Date startTime, @RequestParam(required=true) Date endTime, HttpServletResponse response) throws Exception {
        List<TitleAndModelKey> titleAndModelKeys = this.createExportExcelHeader();
        List<BillVoucher> billVouchers = this.billVoucherService.queryAllBillVoucher(companyCode, supCompanySapCode, startTime, endTime, null);
        response.reset();
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode("SAP\u5bf9\u8d26\u660e\u7ec6.xls", "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/vnd.ms-excel");
        ServletOutputStream outputStream = response.getOutputStream();
        WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, billVouchers, (String)"SAP\u5bf9\u8d26\u660e\u7ec6", null, (int)0);
        writableWorkbook.write();
        outputStream.flush();
        writableWorkbook.close();
        outputStream.close();
        return null;
    }

    private List<TitleAndModelKey> createExportExcelHeader() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7b80\u79f0", (String)"supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u8ba2\u5355\u53f7", (String)"purchaseOrderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u884c\u9879", (String)"purchaseOrderItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u51ed\u8bc1\u53f7", (String)"materialVoucherNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u51ed\u8bc1\u884c\u53f7", (String)"materialVoucherItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8fc7\u8d26\u65e5\u671f", (String)"postingTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u4ef7", (String)"orderPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e01\u79cd", (String)"currencyType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7a0e\u7387", (String)"taxRate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6570\u91cf", (String)"materialQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u79fb\u52a8\u7c7b\u578b", (String)"billType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7b26\u53f7", (String)"mark"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u7968\u672a\u7a0e\u91d1\u989d", (String)"notIncludeTaxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u7968\u7a0e\u989d", (String)"taxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u7968\u542b\u7a0e\u91d1\u989d", (String)"includeTaxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5de5\u5382", (String)"factory"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u5355\u4f4d", (String)"materialUnit"));
        return titleAndModelKeys;
    }
}

