package com.els.base.bill.command;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.service.impl.BillServiceImpl;
import com.els.base.bill.utils.ApproveStatusEnum;
import com.els.base.bill.utils.BillMessageUtils;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.workflow.common.entity.ProcessStartVO;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author liuhf
 */
public class ApproveCommand extends AbstractBillCommand<String> {

    Logger logger = LoggerFactory.getLogger(this.getClass());

    private List<Bill> billList;

    public ApproveCommand() {
    }

    public ApproveCommand(List<Bill> billList) {
        this.billList = billList;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;

        this.validate(billList);

        this.processor(billList);

        //发送消息
        this.sendMessage(billList);

        return null;
    }

    /**
     * 发送消息
     * @param billList
     */
    private void sendMessage(List<Bill> billList) {
        logger.info("开始发送消息");
        List<String> ids = billList.stream().map(Bill::getId).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn(ids);
        billList=this.getBillInvorker().getBillService().queryAllObjByExample(billExample);

        for (Bill bill : billList) {
            Map<String, Object> msg = new HashMap<String, Object>();
            msg.put("billNo", bill.getBillNo());
            List<String> userIdList = this.getBillInvorker().getCompanyUserRefService().queryUserOfCompany(bill.getSupCompanyId());
            if (CollectionUtils.isNotEmpty(userIdList) && StringUtils.isNotBlank(userIdList.get(0))) {
                Message<Map<String, Object>> message = Message.init(msg)
                        .setCompanyCode(bill.getPurCompanySrmCode())// 发送者公司srmcode
                        .setSenderId(getPurUser().getId())// 发送者 userId
                        .setBusinessTypeCode(BillMessageUtils.BILL_PUR_APPROVE)// 业务类型
                        .addReceiverId(userIdList.get(0))// 接受者 userId
                        .setMsgLevel(MessageLevelEnum.HIGH);// 消息等级
                MessageSendUtils.sendMessage(message);

                logger.info("发送内容，"+message);
            }
        }

        logger.info("结束发送消息");
    }

    private void processor(List<Bill> billList) {
        List<String> ids = billList.stream().map(Bill::getId).collect(Collectors.toList());

        BillExample billExample =new BillExample();
        billExample.createCriteria().andIdIn(ids);
        List<Bill> bills = this.billInvorker.getBillService().queryAllObjByExample(billExample);
        Assert.isNotEmpty(bills,"操作失败，操作单据不存在！");

        for (Bill bill : bills) {
            ProcessStartVO vo= ProcessStartVO.newInstance("t345", bill.getBillNo(), bill.getId(),"checkedBillPur?id="+bill.getId());
            vo.setListenerClass(BillServiceImpl.class);
            ProcessInstance startProcess=this.billInvorker.getWorkFlowService().startProcess(vo);
            if(startProcess!=null){
                //成功加入审批流
                Bill payBill = new Bill();
                payBill.setId(bill.getId());
                payBill.setApproveStatus(ApproveStatusEnum.BEING_AUDITED.getCode());
                payBill.setApproveTime(new Date());

                //增加业务审批情况
                payBill.setApproveNo("t345");
                payBill.setApproveResult(bill.getBillNo());

                this.billInvorker.getBillService().modifyObj(payBill);
            }
        }
    }

    private void validate(List<Bill> billList) {

        Assert.isNotEmpty(billList,"开票清单ID列表不能为空！");
        List<String> ids =new ArrayList<>();
        for (Bill bill : billList) {
            Assert.isNotNull(bill.getId(),"开票清单ID不能为空！");
            ids.add(bill.getId());
        }

        //双方确认才能发送审核
        BillExample purConfirmBillStatusExample =new BillExample();
        purConfirmBillStatusExample.createCriteria()
                .andIdIn(ids)
                .andIsEnableEqualTo(Constant.YES_INT)
                .andPurConfirmBillStatusEqualTo(Constant.NO_INT);

        int count = this.billInvorker.getBillService().countByExample(purConfirmBillStatusExample);
        if(count>0){
            throw new CommonException("操作失败，还没有确认发票信息呢，请检查！");
        }

        BillExample supConfirmBillStatusExample =new BillExample();
        supConfirmBillStatusExample.createCriteria()
                .andIdIn(ids)
                .andIsEnableEqualTo(Constant.YES_INT)
                .andSupConfirmBillStatusEqualTo(Constant.NO_INT);
        int count2 = this.billInvorker.getBillService().countByExample(supConfirmBillStatusExample);
        if(count2>0){
            throw new CommonException("操作失败，供应商还未回签清单，请检查！");
        }

    }
}
