package com.els.base.bill.command;

import com.els.base.billswitch.entity.BillSwitch;
import com.els.base.billswitch.entity.BillSwitchExample;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Calendar;
import java.util.List;

public class CreateBillFilterCommand extends AbstractBillCommand<String> {

    Logger logger = LoggerFactory.getLogger(getClass());

    private String supCompanySapCode;

    public CreateBillFilterCommand(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
        this.check(supCompanySapCode);

        this.process();

        return null;
    }

    private void check(String supCompanySapCode) {
        Assert.isNotBlank(supCompanySapCode, "供应商SAP编码不能为空！");
    }

    private void process() {

        BillSwitchExample billSwitchExample = new BillSwitchExample();
        billSwitchExample.createCriteria()
                .andIsEnableEqualTo(Constant.YES_INT)
                .andSupCompanySapCodeEqualTo(supCompanySapCode);

        List<BillSwitch> billSwitches = this.billInvorker.getBillSwitchService().queryAllObjByExample(billSwitchExample);

        //第一步，该供应商是否有做对账限制，如果没有则放行
        if (CollectionUtils.isEmpty(billSwitches)) {
            return;
        }

        for (BillSwitch billSwitch : billSwitches) {
            //第二步，如果有做对账限制，那么是否在允许的时间范围之内
            Assert.isNotNull(billSwitch);
            Integer switchFlag = billSwitch.getSwitchFlag();
            Assert.isNotNull(switchFlag, "开账时间标记不能为空！");

            //没有开启对账限制
            if (switchFlag.equals(Constant.NO_INT)) {
                continue;
            }

            Integer startTime = billSwitch.getStartTime();
            Integer endTime = billSwitch.getEndTime();

            Assert.isNotNull(startTime, "开票开始时间不能为空！");
            Assert.isNotNull(endTime, "开票结束时间不能为空！");

            logger.info("采购员设置的开票开始时间为：{}", startTime);
            logger.info("采购员设置的开票结束时间为：{}", endTime);

            //开始和结束日期  1号 - 31 号
            Calendar calendar = Calendar.getInstance();
            int date = calendar.get(Calendar.DATE);
            logger.info("系统当前天数为：{}", date);

            //如果在开票范围内，则放行
            if (date >= startTime && date <= endTime) {
                continue;
            } else {
                throw new CommonException("不在对账时间内,请联系采购员设置对账时间，谢谢！");
            }
        }
    }
}
