package com.els.base.bill.command;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 删除跟踪清单
 *
 * @author liuhf
 */
public class DeleteCommand extends AbstractBillCommand<String> {

    private List<Bill> billList;

    public DeleteCommand(List<Bill> billList) {
        this.billList = billList;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;

        this.validData(billList);

        this.processor(billList);

        return null;
    }

    /**
     * 删除数据
     */
    private void processor(List<Bill> billList) {

        //删除对账清单
        List<String> ids = billList.stream().map(Bill::getId).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn(ids);
        Bill bill = new Bill();
        bill.setIsEnable(Constant.NO_INT);
        this.billInvorker.getBillService().updateByExampleSelective(bill, billExample);

        //释放对账
        this.billInvorker.getBillService().updateVoucherByBillIds(ids, Constant.NO_INT);

    }

    /**
     * 校验
     */
    private void validData(List<Bill> billList) {
        Assert.isNotEmpty(billList, "操作失败,ids列表不能为空");
        for (Bill bill : billList) {
            Assert.isNotBlank(bill.getId(), "操作失败,id不能为空");
        }

        //是否存在
        List<String> ids = billList.stream().map(Bill::getId).collect(Collectors.toList());
        BillExample billExample = new BillExample();

        //采购方未发送
        billExample.or()
                .andIdIn(ids)
                .andPurSendStatusEqualTo(Constant.YES_INT);

        //供应商未发送
        billExample.or()
                .andIdIn(ids)
                .andSupSendStatusEqualTo(Constant.YES_INT);

        int i = this.billInvorker.getBillService().countByExample(billExample);
        if (i > 0) {
            throw new CommonException("所选单据中含有已发送的单据，无法进行删除，请重新选择！");
        }
    }

}
