package com.els.base.bill.command;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.els.base.bill.entity.*;
import com.els.base.bill.vo.BillItemExportExcelVo;
import com.els.base.bill.vo.BillItemReportExportExcelVo;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.BeanUtils;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class ExportReportCommand extends AbstractBillCommand<FileData> {

    QueryParamWapper wapper;

    public ExportReportCommand() {
    }

    public ExportReportCommand(QueryParamWapper wapper) {
        this.wapper = wapper;
    }

    @Override
    public FileData execute(BillInvorker billInvorker) {

        this.billInvorker = billInvorker;

        this.validData(wapper);

        return this.processor(wapper);
    }

    private FileData processor(QueryParamWapper wapper) {

        BillItemReportExample example = new BillItemReportExample();
        BillItemReportExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(this.getProject().getId());
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        List<BillItemReport> billList = this.billInvorker.getBillItemService().queryBillItemReportForExcel(example);
        FileData fileData = new FileData();
        try {
            fileData = this.getFileData(billList);
        } catch (IOException e) {
            e.printStackTrace();
            throw new CommonException("生成文件失败！");
        }
        return fileData;
    }

    private FileData getFileData(List<BillItemReport> billItemReportList) throws IOException {

        FileData fileData = new FileData();
        String dateStr = DateFormatUtils.format(new Date(), "yyyyMMdd");
        fileData.setProjectId(getProject().getId());
        fileData.setCompanyId(CompanyUtils.currentCompanyId());
        fileData.setFileName(MessageFormat.format("开票清单行" + "-{0}", dateStr) + ".xls");
        fileData.setFileSuffix("xls");
        fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
        fileData.setExpiryDay(DateUtils.addDays(new Date(), 2));
        fileData = FileManagerFactory.getFileManager().write(new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
        FileOutputStream fos = new FileOutputStream(fileData.toFile());

        if (CollectionUtils.isEmpty(billItemReportList)) {
            return fileData;
        }


        List<BillItemReportExportExcelVo> billItemReportExportExcelVos = new ArrayList<BillItemReportExportExcelVo>();

        for (BillItemReport billItem : billItemReportList) {
            BillItemReportExportExcelVo billItemExportExcelVo = new BillItemReportExportExcelVo();
            BeanUtils.copyProperties(billItem, billItemExportExcelVo);
            billItemReportExportExcelVos.add(billItemExportExcelVo);
        }
        ExportParams params = new ExportParams();
        //params.setFreezeCol(2);
        params.setSheetName("开票清单行");
        params.setType(ExcelType.HSSF);
        Workbook workbook = ExcelExportUtil.exportExcel(params, BillItemReportExportExcelVo.class, billItemReportExportExcelVos);
        workbook.write(fos);
        fos.flush();
        fos.close();
        return fileData;

    }

    private void validData(QueryParamWapper wapper) {

    }
}