package com.els.base.bill.command;

import com.els.base.bill.entity.Bill;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.voucher.entity.BillVoucher;
import com.els.base.voucher.entity.BillVoucherExample;

import java.util.List;
import java.util.stream.Collectors;


/**
 * 用户创建开票清单的时候预览数据
 */
public class PreviewCommand extends AbstractBillCommand<Bill> {

    List<BillVoucher> billVoucherList;

    public PreviewCommand() {
    }

    public List<BillVoucher> getBillVoucherList() {
        return billVoucherList;
    }

    public void setBillVoucherList(List<BillVoucher> billVoucherList) {
        this.billVoucherList = billVoucherList;
    }

    @Override
    public Bill execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;

        billVoucherList = this.validData(billVoucherList);

        return this.processor(billVoucherList);


    }

    private Bill processor(List<BillVoucher> billVoucherList) {

        Bill bill = new Bill();

        return bill;
    }

    private List<BillVoucher> validData(List<BillVoucher> billVoucherList) {
        Assert.isNotEmpty(billVoucherList, "可开票清单行不能为空，请检查！");
        for (BillVoucher billVoucher : billVoucherList) {
            Assert.isNotBlank(billVoucher.getId(), "可开票清单ID不能为空，请检查！");
        }

        List<String> ids = billVoucherList.stream().map(BillVoucher::getId).collect(Collectors.toList());

        //查询数据库
        BillVoucherExample billVoucherExample = new BillVoucherExample();
        billVoucherExample.createCriteria()
                .andIdIn(ids).andIsEnableEqualTo(Constant.YES_INT);
        billVoucherList = this.billInvorker.getBillVoucherService().queryAllObjByExample(billVoucherExample);
        Assert.isNotEmpty(billVoucherList, "开票清单行凭证不存在，请重新选择！");
        for (BillVoucher billVoucher : billVoucherList) {
            Assert.isNotBlank(billVoucher.getId(), "可开票清单ID不能为空，请检查！");
            Assert.isNotBlank(billVoucher.getBillType(), "可开票凭证行的移动类型不能为空，请检查！");
            if (Constant.YES_INT.equals(billVoucher.getBillFlag())) {
                throw new CommonException("所选的单据中存在已经开过开票清单的行，请重新选择！");
            }

            //检查是否在对应的开票时间内


        }
        return billVoucherList;
    }
}
