package com.els.base.bill.command;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.utils.*;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.voucher.command.SapImportCommand;
import com.els.base.voucher.entity.BillVoucher;
import com.els.base.voucher.entity.BillVoucherExample;
import com.els.base.voucher.vo.ImportVoucherVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Date;
import java.util.List;

/**
 * 采购方新建开票清单
 *
 * @author liuhf
 */
public class PurPrepareCommand extends AbstractBillCommand<Bill> {

    Logger logger = LoggerFactory.getLogger(this.getClass());

    private Bill bill;

    public PurPrepareCommand() {
    }

    public PurPrepareCommand(Bill bill) {
        this.bill = bill;
    }

    @Override
    public Bill execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;

        //校验
        this.billInvorker.getBillService().prepareFilter(bill);

        //创建开票清单限制
        this.billInvorker.getBillService().createBillFilter(bill);

        this.prepareForPur(bill);

        return bill;
    }

    /**
     * 预览数据
     *
     * @param bill
     */
    private void prepareForPur(Bill bill) {

        //1、先从sap拉取数据
        ImportVoucherVo importVoucherVo = new ImportVoucherVo(bill.getSupCompanySapCode(), bill.getPostingStartTime(), bill.getPostingEndTime());
        SapImportCommand cmd = new SapImportCommand(importVoucherVo);
        this.billInvorker.invoke(cmd);

        //2、根据供应商编码以及凭证开始时间和结束时间查询未对账的入退库凭证
        BillVoucherExample billVoucherExample = new BillVoucherExample();
        billVoucherExample.createCriteria()
                .andSupCompanySapCodeEqualTo(bill.getSupCompanySapCode())
                .andPostingTimeBetween(bill.getPostingStartTime(), bill.getPostingEndTime())
                .andIsEnableEqualTo(Constant.YES_INT)
                .andBillFlagEqualTo(Constant.NO_INT)
                .andBillTypeIsNotNull();
        List<BillVoucher> billVoucherList = this.billInvorker.getBillVoucherService().queryAllObjByExample(billVoucherExample);
        Assert.isNotEmpty(billVoucherList, "暂时还没有存在需要对账的入退库凭证！");

        this.assembleForPur(bill, billVoucherList);
    }


    private void assembleForPur(Bill bill, List<BillVoucher> billVoucherList) {

        //采购基本信息
        BillUtil.setPurCompanyInfo(this.getProject(), bill, this.billInvorker.getCompanyService());
        //设置供应商基本信息
        BillUtil.setSupCompanyInfo(bill.getSupCompanySapCode(), bill, this.billInvorker.getCompanyService());

        bill.setProjectId(this.getProject().getId());
        // 开票开始时间, 开票结束时间
        bill.setPostingStartTime(bill.getPostingStartTime());
        bill.setPostingEndTime(bill.getPostingEndTime());

        //制单时间
        bill.setCreateTime(new Date());

        //制单人
        bill.setPurUserId(this.getPurUser().getId());
        bill.setPurUserName(this.getPurUser().getNickName());

        //状态
        bill.setIsEnable(Constant.YES_INT);
        bill.setSendSapFlag(Constant.NO_INT);

        //采购员新建单状态
        bill.setCreateBillType(CreateBillType.PUR.getType());
        bill.setPurSendStatus(BillSendStatus.NO_INT);
        bill.setPurConfirmBillStatus(Constant.NO_INT);//未确认发票
        bill.setSupConfirmStatus(BillStatusConfirmEnum.STATUS_UNCONFIRM.getConfirmStatus());//供应方为确认单据
        bill.setSupConfirmBillStatus(Constant.NO_INT);
        bill.setApproveStatus(ApproveStatusEnum.NOT_AUDITED.getCode());

        //其他状态无需操作
        bill.setSupSendStatus(BillSendStatus.NO);//供应商无需发送
        bill.setPurConfirmStatus(BillStatusConfirmEnum.NO.getConfirmStatus());//采购方无需确认单据

        //计算开票各个价格
        CalculateBillUtil.calculateAmount(bill, billVoucherList);
    }

}
