package com.els.base.bill.command;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.utils.BillMessageUtils;
import com.els.base.bill.utils.BillStatusConfirmEnum;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author liuhf
 */
public class PurRejectCommand  extends AbstractBillCommand<String> {

    Logger logger = LoggerFactory.getLogger(this.getClass());

    private List<Bill> billList;

    public PurRejectCommand() {
    }

    public PurRejectCommand(List<Bill> billList) {
        this.billList = billList;
    }

    @Override
    public String execute(BillInvorker billInvorker) {

        this.billInvorker = billInvorker;

        this.validate(billList);

        this.processor(billList);

        //发送消息
        this.sendMessage(billList);

        return null;
    }

    /**
     * 发送消息
     * @param billList
     */
    private void sendMessage(List<Bill> billList) {
        logger.info("开始发送消息");
        List<String> ids = billList.stream().map(Bill::getId).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn(ids);
        billList=this.getBillInvorker().getBillService().queryAllObjByExample(billExample);

        for (Bill bill : billList) {
            Map<String, Object> msg = new HashMap<String, Object>();
            msg.put("billNo", bill.getBillNo());
            List<String> userIdList = this.getBillInvorker().getCompanyUserRefService().queryUserOfCompany(bill.getSupCompanyId());
            if (CollectionUtils.isNotEmpty(userIdList) && StringUtils.isNotBlank(userIdList.get(0))) {
                Message<Map<String, Object>> message = Message.init(msg)
                        .setCompanyCode(bill.getPurCompanySrmCode())// 发送者公司srmcode
                        .setSenderId(getPurUser().getId())// 发送者 userId
                        .setBusinessTypeCode(BillMessageUtils.BILL_PUR_REJECT)// 业务类型
                        .addReceiverId(userIdList.get(0))// 接受者 userId
                        .setMsgLevel(MessageLevelEnum.HIGH);// 消息等级
                MessageSendUtils.sendMessage(message);

                logger.info("发送内容，"+message);
            }
        }

        logger.info("结束发送消息");
    }

    private void processor(List<Bill> billList) {

        List<String> ids = billList.stream().map(Bill::getId).collect(Collectors.toList());
        BillExample billExample =new BillExample();
        billExample.createCriteria().andIdIn(ids);
        Bill bill =new Bill();
        bill.setPurConfirmStatus(BillStatusConfirmEnum.STATUS_REJECT.getConfirmStatus());
        this.billInvorker.getBillService().updateByExampleSelective(bill,billExample);

        //释放对账
        this.billInvorker.getBillService().updateVoucherByBillIds(ids,Constant.NO_INT);

        //标记发票为作废
        this.billInvorker.getBillInvoiceService().updateBillInvoiceFlag(ids,Constant.NO_INT);

    }

    private void validate(List<Bill> billList) {
        Assert.isNotEmpty(billList,"开票清单ID列表不能为空！");
        for (Bill bill : billList) {
            Assert.isNotNull(bill.getId(),"开票清单ID不能为空！");
        }

        //TODO 后台对业务的判断
    }
}
