package com.els.base.bill.command;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.entity.BillItem;
import com.els.base.bill.entity.BillItemExample;
import com.els.base.bill.vo.BillItemExportExcelVo;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.BeanUtils;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 供应商导出开票清单
 * @author liuhf
 */
public class SupExportCommand extends AbstractBillCommand<FileData> {

    QueryParamWapper wapper;

    public SupExportCommand() {
    }

    public SupExportCommand(QueryParamWapper wapper) {
        this.wapper = wapper;
    }

    @Override
    public FileData execute(BillInvorker billInvorker) {

        this.billInvorker = billInvorker;

        this.validData(wapper);

        return this.processor(wapper);
    }

    private FileData processor(QueryParamWapper wapper) {

        BillExample example = new BillExample();
        BillExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT)
                .andSupCompanyIdEqualTo(getSupCompany().getId())
                .andProjectIdEqualTo(this.getProject().getId());
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        List<Bill> billList = this.billInvorker.getBillService().queryAllObjByExample(example);
        FileData fileData = new FileData();
        try {
            fileData = this.getFileData(billList);
        } catch (IOException e) {
            e.printStackTrace();
            throw new CommonException("生成文件失败！");
        }
        return fileData;
    }

    private FileData getFileData(List<Bill> billList) throws IOException {

        FileData fileData = new FileData();
        String dateStr = DateFormatUtils.format(new Date(), "yyyyMMdd");
        fileData.setProjectId(getProject().getId());
        fileData.setCompanyId(getSupCompany().getId());
        fileData.setFileName(MessageFormat.format("开票清单行" + "-{0}", dateStr) + ".xls");
        fileData.setFileSuffix("xls");
        fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
        fileData.setExpiryDay(DateUtils.addDays(new Date(), 2));
        fileData = FileManagerFactory.getFileManager().write(new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
        FileOutputStream fos = new FileOutputStream(fileData.toFile());

        if (CollectionUtils.isEmpty(billList)) {
            return fileData;
        }

        List<BillItem> billItems = this.getBillItemList(billList);

        List<BillItemExportExcelVo> billItemExportExcelVos = new ArrayList<BillItemExportExcelVo>();

        if (CollectionUtils.isEmpty(billItems)) {
            return fileData;
        }

        for (BillItem billItem : billItems) {
            BillItemExportExcelVo billItemExportExcelVo = new BillItemExportExcelVo();
            BeanUtils.copyProperties(billItem, billItemExportExcelVo);
            billItemExportExcelVos.add(billItemExportExcelVo);
        }
        ExportParams params = new ExportParams();
        //params.setFreezeCol(2);
        params.setSheetName("开票清单行");
        params.setType(ExcelType.HSSF);
        Workbook workbook = ExcelExportUtil.exportExcel(params, BillItemExportExcelVo.class, billItemExportExcelVos);
        workbook.write(fos);
        fos.flush();
        fos.close();
        return fileData;

    }

    private List<BillItem> getBillItemList(List<Bill> billList) {
        List<String> billIdList = billList.stream().map(Bill::getId).collect(Collectors.toList());
        BillItemExample billItemExample =new BillItemExample();
        billItemExample.createCriteria().andBillIdIn(billIdList)
                .andIsEnableEqualTo(Constant.YES_INT);
        return this.billInvorker.getBillItemService().queryAllObjByExample(billItemExample);
    }

    private void validData(QueryParamWapper wapper) {

    }
}
