package com.els.base.bill.command;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.utils.*;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.core.entity.project.Project;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import com.els.base.voucher.command.SapImportCommand;
import com.els.base.voucher.entity.BillVoucher;
import com.els.base.voucher.entity.BillVoucherExample;
import com.els.base.voucher.service.BillVoucherImportFromSapService;
import com.els.base.voucher.vo.ImportVoucherVo;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Date;
import java.util.List;

/**
 * 采购方新建开票清单
 *
 * @author liuhf
 */
public class SupPrepareCommand extends AbstractBillCommand<Bill> {

    Logger logger = LoggerFactory.getLogger(this.getClass());

    private Bill bill;

    public SupPrepareCommand() {
    }

    public SupPrepareCommand(Bill bill) {
        this.bill = bill;
    }

    @Override
    public Bill execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;

        //1、校验
        this.billInvorker.getBillService().prepareFilter(bill);

        //创建开票清单限制
        this.billInvorker.getBillService().createBillFilter(bill);

        this.prepareForSup(bill);

        return bill;
    }

    /**
     * 预览数据
     *
     * @param bill
     */
    private void prepareForSup(Bill bill) {

        //1、先从sap拉取数据
        ImportVoucherVo importVoucherVo = new ImportVoucherVo(bill.getSupCompanySapCode(), bill.getPostingStartTime(), bill.getPostingEndTime());
        SapImportCommand cmd = new SapImportCommand(importVoucherVo);
        this.billInvorker.invoke(cmd);

        //2、根据供应商编码以及凭证开始时间和结束时间查询未对账的入退库凭证
        BillVoucherExample billVoucherExample = new BillVoucherExample();
        billVoucherExample.createCriteria()
                .andSupCompanySapCodeEqualTo(bill.getSupCompanySapCode())
                .andPostingTimeBetween(bill.getPostingStartTime(), bill.getPostingEndTime())
                .andIsEnableEqualTo(Constant.YES_INT)
                .andBillFlagEqualTo(Constant.NO_INT)
                .andBillTypeIsNotNull();
        List<BillVoucher> billVoucherList = this.billInvorker.getBillVoucherService().queryAllObjByExample(billVoucherExample);
        Assert.isNotEmpty(billVoucherList, "暂时还没有存在需要对账的入退库凭证！");

        this.assembleForSup(bill, billVoucherList);

    }


    private void assembleForSup(Bill bill, List<BillVoucher> billVoucherList) {

        bill.setProjectId(this.getProject().getId());

        //采购基本信息
        BillUtil.setPurCompanyInfo(this.getProject(), bill, this.billInvorker.getCompanyService());
        //设置供应商基本信息
        BillUtil.setSupCompanyInfo(this.bill.getSupCompanySapCode(), bill, this.billInvorker.getCompanyService());

        // 开票开始时间, 开票结束时间
        bill.setPostingStartTime(this.bill.getPostingStartTime());
        bill.setPostingEndTime(this.bill.getPostingEndTime());

        //制单时间
        bill.setCreateTime(new Date());

        //制单人
        bill.setSupUserId(this.getSupUser().getId());
        bill.setSupUserName(this.getSupUser().getNickName());
        // bill.setPurUserId(loginUser.getId());
        // bill.setPurUserName(loginUser.getNickName());

        bill.setIsEnable(Constant.YES_INT);
        bill.setSendSapFlag(Constant.NO_INT);

        //供应商新建单：供应商已经发送，采购商商未确认，已回签
        bill.setSupSendStatus(Constant.NO_INT);
        bill.setPurConfirmStatus(BillStatusConfirmEnum.STATUS_UNCONFIRM.getConfirmStatus());
        bill.setPurConfirmBillStatus(Constant.NO_INT);

        bill.setPurSendStatus(BillSendStatus.NO);
        bill.setSupConfirmStatus(BillStatusConfirmEnum.NO.getConfirmStatus());
        bill.setSupConfirmBillStatus(BillSendStatus.NO_INT);

        //审核状态
        bill.setApproveStatus(ApproveStatusEnum.NOT_AUDITED.getCode());
        bill.setCreateBillType(CreateBillType.SUP.getType());

        //计算开票各个价格
        CalculateBillUtil.calculateAmount(bill, billVoucherList);
    }

}
