package com.els.base.bill.command;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.utils.BillMessageUtils;
import com.els.base.bill.utils.BillStatusConfirmEnum;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author liuhf
 */
public class SupRejectCommand extends AbstractBillCommand<String> {

    Logger logger = LoggerFactory.getLogger(this.getClass());

    private List<Bill> billList;

    public SupRejectCommand() {
    }

    public SupRejectCommand(List<Bill> billList) {
        this.billList = billList;
    }

    @Override
    public String execute(BillInvorker billInvorker) {

        this.billInvorker = billInvorker;

        this.validate(billList);

        this.processor(billList);

        //发送消息
        this.sendMessage(billList);

        return null;
    }

    /**
     * 发送消息
     * @param billList
     */
    private void sendMessage(List<Bill> billList) {
        logger.info("开始发送消息");
        List<String> ids = billList.stream().map(Bill::getId).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn(ids);
        billList=this.getBillInvorker().getBillService().queryAllObjByExample(billExample);

        for (Bill bill : billList) {
            User user = this.getBillInvorker().getCompanyUserRefService().queryMainUserOfCompany(bill.getPurCompanyId());
            if(user!=null){
                //发送通知
                Message<Bill> message = Message.init(bill) //传入数据
                        .setBusinessTypeCode(BillMessageUtils.BILL_SUP_REJECT) //业务编码
                        .setCompanyCode(getSupCompany().getCompanyCode()) //发送的企业srm编码
                        .setMsgLevel(MessageLevelEnum.HIGH) //消息等级
                        .setSenderId(getSupUser().getId()) //发送人的userid
                        .addReceiverId(user.getId()); //添加单个收件人 userid
                //.addReceiverIdList(new ArrayList<String>()); //添加多个收件人 userid
                MessageSendUtils.sendMessage(message);
                logger.info("发送内容，" + message);
            }
        }

        logger.info("结束发送消息");
    }


    private void processor(List<Bill> billList) {
        List<String> ids = billList.stream().map(Bill::getId).collect(Collectors.toList());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andIdIn(ids);
        Bill bill = new Bill();
        bill.setSupConfirmStatus(BillStatusConfirmEnum.STATUS_REJECT.getConfirmStatus());
        bill.setUpdateTime(new Date());
        this.billInvorker.getBillService().updateByExampleSelective(bill, billExample);

        //释放对账
        this.billInvorker.getBillService().updateVoucherByBillIds(ids, Constant.NO_INT);

        //标记发票为作废
        this.billInvorker.getBillInvoiceService().updateBillInvoiceFlag(ids, Constant.NO_INT);
    }

    private void validate(List<Bill> billList) {
        Assert.isNotEmpty(billList, "开票清单ID列表不能为空！");
        for (Bill bill : billList) {
            Assert.isNotNull(bill.getId(), "开票清单ID不能为空！");
        }
    }

    //TODO 后台对业务的判断
}
