package com.els.base.bill.command;

import com.els.base.bill.entity.Bill;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.utils.Assert;

import java.util.Date;

/**
 * 供应商编辑开票清单
 *
 * @author liuhf
 */
public class SupUpdateCommand extends AbstractBillCommand<String> {


    private Bill bill;

    public SupUpdateCommand() {
    }

    public SupUpdateCommand(Bill bill) {
        this.bill = bill;
    }

    @Override
    public String execute(BillInvorker billInvorker) {

        this.billInvorker = billInvorker;

        this.validate(bill);

        this.processor(bill);

        return null;
    }

    private void processor(Bill bill) {
        Bill oldBill = this.billInvorker.getBillService().queryObjById(bill.getId());
        Assert.isNotNull(oldBill, "操作失败,开票清单信息不能为空");
        oldBill.setSupRemark(bill.getSupRemark());
        oldBill.setUpdateTime(new Date());
        this.billInvorker.getBillService().modifyObj(oldBill);
    }


    private void validate(Bill bill) {
        Assert.isNotNull(bill, "操作失败,开票清单信息不能为空");
        Assert.isNotNull(bill.getId(), "开票清单ID不能为空！");
    }
}
