package com.els.base.bill.entity;

import com.els.base.invoice.entity.BillInvoice;
import com.els.base.voucher.entity.BillVoucher;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ApiModel(value="采购结算管理-开票清单头数据")
public class Bill implements Serializable {

    //	#############################不要覆盖数据#################################

    @ApiModelProperty("入退库凭证")
    List<BillVoucher> billVoucherList=new ArrayList<>();
    public List<BillVoucher> getBillVoucherList() {
        return billVoucherList;
    }
    public void setBillVoucherList(List<BillVoucher> billVoucherList) {
        this.billVoucherList = billVoucherList;
    }

    @ApiModelProperty("开票清单行")
    List<BillItem> billItemList=new ArrayList<>();
    public List<BillItem> getBillItemList() {
        return billItemList;
    }
    public void setBillItemList(List<BillItem> billItemList) {
        this.billItemList = billItemList;
    }

    @ApiModelProperty("折让单")
    List<BillVoucher> rebateVoucherList=new ArrayList<>();
    public List<BillVoucher> getRebateVoucherList() {
        return rebateVoucherList;
    }
    public void setRebateVoucherList(List<BillVoucher> rebateVoucherList) {
        this.rebateVoucherList = rebateVoucherList;
    }

    @ApiModelProperty("发票列表")
    List<BillInvoice> invoiceList=new ArrayList<>();
    public List<BillInvoice> getInvoiceList() {
        return invoiceList;
    }
    public void setInvoiceList(List<BillInvoice> invoiceList) {
        this.invoiceList = invoiceList;
    }

    /**
     * 重写toString方法
     * @return
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

    /**
     * 自定义是否相同
     * @param obj
     * @return
     */
    @Override
    public boolean equals(Object obj) {
        if(null == obj){
            return false;
        }
        if(!(obj instanceof Bill)){
            return false;
        }

        //强转成bill对象
        Bill bill = (Bill) obj;

        if(StringUtils.isEmpty(bill.getId())){
            return false;
        }
        return this.getId().equals(bill.getId());
    }
//	#################################不要覆盖数据 ######################################



    @ApiModelProperty("主键ID")
    private String id;

    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("对账清单号")
    private String billNo;

    @ApiModelProperty("采购商公司ID")
    private String purCompanyId;

    @ApiModelProperty("采购商公司SRM编码")
    private String purCompanySrmCode;

    @ApiModelProperty("采购商公司SAP编码")
    private String purCompanySapCode;

    @ApiModelProperty("采购商公司名称")
    private String purCompanyName;

    @ApiModelProperty("采购商公司全称")
    private String purCompanyFullName;

    @ApiModelProperty("采购员制单人用户ID")
    private String purUserId;

    @ApiModelProperty("采购员制单人用户名称")
    private String purUserName;

    @ApiModelProperty("采购员备注")
    private String purRemark;

    @ApiModelProperty("采购员发送对账清单的状态（已发送=1，未发送=0）")
    private Integer purSendStatus;

    @ApiModelProperty("采购员确认发送对账清单的状态（未确认=0，已确认=1，已拒绝=2,已作废=3）")
    private Integer purConfirmStatus;

    @ApiModelProperty("采购员确认对账发票信息无误（未确认=0，已确认=1）")
    private Integer purConfirmBillStatus;

    @ApiModelProperty("供应商公司ID")
    private String supCompanyId;

    @ApiModelProperty("供应商公司名称")
    private String supCompanyName;

    @ApiModelProperty("供应商公司全称")
    private String supCompanyFullName;

    @ApiModelProperty("供应商公司SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商公司SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商地址")
    private String supCompanyAddress;

    @ApiModelProperty("供应商制单人用户ID")
    private String supUserId;

    @ApiModelProperty("供应商制单人用户名称")
    private String supUserName;

    @ApiModelProperty("供应商联系人")
    private String supComtactUserName;

    @ApiModelProperty("供应商联系人电话")
    private String supComtactTelephone;

    @ApiModelProperty("供应商备注")
    private String supRemark;

    @ApiModelProperty("供应商发送对账清单的状态（已发送=1，未发送=0）")
    private Integer supSendStatus;

    @ApiModelProperty("供应商确认发送对账清单的状态（未确认=0，已确认=1，已拒绝=2,已作废=3）")
    private Integer supConfirmStatus;

    @ApiModelProperty("供应商确认对账发票信息无误（未确认=0，已确认=1）")
    private Integer supConfirmBillStatus;

    @ApiModelProperty("对账开票开始时间")
    private Integer startTime;

    @ApiModelProperty("对账开票结束时间")
    private Integer endTime;

    @ApiModelProperty("货币类型")
    private String currencyType;

    @ApiModelProperty("记录是否可用(可用=1，不可用=0)")
    private Integer isEnable;

    @ApiModelProperty("表创建时间")
    private Date createTime;

    @ApiModelProperty("表更新时间")
    private Date updateTime;

    @ApiModelProperty("审核批号")
    private String approveNo;

    @ApiModelProperty("审批结果")
    private String approveResult;

    @ApiModelProperty("审批人")
    private String approveUserName;

    @ApiModelProperty("审批状态(1未审核,2正在审核3已审核，4已驳回)")
    private Integer approveStatus;

    @ApiModelProperty("审批时间")
    private Date approveTime;

    @ApiModelProperty("付款条件code")
    private String payConditionsCode;

    @ApiModelProperty("付款条件描述")
    private String payConditionsDesc;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("净价")
    private BigDecimal netPrice;

    @ApiModelProperty("开票含税税额")
    private BigDecimal includeTaxAmount;

    @ApiModelProperty("开票未税金额")
    private BigDecimal notIncludeTaxAmount;

    @ApiModelProperty("开票税额")
    private BigDecimal taxAmount;

    @ApiModelProperty("对账总金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("扣款总金额")
    private BigDecimal deductionAmount;

    @ApiModelProperty("凭证开始日期")
    private Date postingStartTime;

    @ApiModelProperty("凭证结束日期")
    private Date postingEndTime;

    @ApiModelProperty("创建单据属于哪一方（1=采购方，2=供应商）")
    private Integer createBillType;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("发送SAP标识符（0未发送，1已发送）")
    private Integer sendSapFlag;

    @ApiModelProperty("折让不含税金额")
    private BigDecimal rebateNotIncludeTaxAmount;

    @ApiModelProperty("折让含税金额")
    private BigDecimal rebateIncludeTaxAmount;

    @ApiModelProperty("折让税额")
    private BigDecimal rebateTaxAmount;

    @ApiModelProperty("系统预制发票")
    private Integer invoiceSignFlag;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getBillNo() {
        return billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo == null ? null : billNo.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanySapCode() {
        return purCompanySapCode;
    }

    public void setPurCompanySapCode(String purCompanySapCode) {
        this.purCompanySapCode = purCompanySapCode == null ? null : purCompanySapCode.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurCompanyFullName() {
        return purCompanyFullName;
    }

    public void setPurCompanyFullName(String purCompanyFullName) {
        this.purCompanyFullName = purCompanyFullName == null ? null : purCompanyFullName.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getPurRemark() {
        return purRemark;
    }

    public void setPurRemark(String purRemark) {
        this.purRemark = purRemark == null ? null : purRemark.trim();
    }

    public Integer getPurSendStatus() {
        return purSendStatus;
    }

    public void setPurSendStatus(Integer purSendStatus) {
        this.purSendStatus = purSendStatus;
    }

    public Integer getPurConfirmStatus() {
        return purConfirmStatus;
    }

    public void setPurConfirmStatus(Integer purConfirmStatus) {
        this.purConfirmStatus = purConfirmStatus;
    }

    public Integer getPurConfirmBillStatus() {
        return purConfirmBillStatus;
    }

    public void setPurConfirmBillStatus(Integer purConfirmBillStatus) {
        this.purConfirmBillStatus = purConfirmBillStatus;
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupCompanyFullName() {
        return supCompanyFullName;
    }

    public void setSupCompanyFullName(String supCompanyFullName) {
        this.supCompanyFullName = supCompanyFullName == null ? null : supCompanyFullName.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanyAddress() {
        return supCompanyAddress;
    }

    public void setSupCompanyAddress(String supCompanyAddress) {
        this.supCompanyAddress = supCompanyAddress == null ? null : supCompanyAddress.trim();
    }

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public String getSupUserName() {
        return supUserName;
    }

    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    public String getSupComtactUserName() {
        return supComtactUserName;
    }

    public void setSupComtactUserName(String supComtactUserName) {
        this.supComtactUserName = supComtactUserName == null ? null : supComtactUserName.trim();
    }

    public String getSupComtactTelephone() {
        return supComtactTelephone;
    }

    public void setSupComtactTelephone(String supComtactTelephone) {
        this.supComtactTelephone = supComtactTelephone == null ? null : supComtactTelephone.trim();
    }

    public String getSupRemark() {
        return supRemark;
    }

    public void setSupRemark(String supRemark) {
        this.supRemark = supRemark == null ? null : supRemark.trim();
    }

    public Integer getSupSendStatus() {
        return supSendStatus;
    }

    public void setSupSendStatus(Integer supSendStatus) {
        this.supSendStatus = supSendStatus;
    }

    public Integer getSupConfirmStatus() {
        return supConfirmStatus;
    }

    public void setSupConfirmStatus(Integer supConfirmStatus) {
        this.supConfirmStatus = supConfirmStatus;
    }

    public Integer getSupConfirmBillStatus() {
        return supConfirmBillStatus;
    }

    public void setSupConfirmBillStatus(Integer supConfirmBillStatus) {
        this.supConfirmBillStatus = supConfirmBillStatus;
    }

    public Integer getStartTime() {
        return startTime;
    }

    public void setStartTime(Integer startTime) {
        this.startTime = startTime;
    }

    public Integer getEndTime() {
        return endTime;
    }

    public void setEndTime(Integer endTime) {
        this.endTime = endTime;
    }

    public String getCurrencyType() {
        return currencyType;
    }

    public void setCurrencyType(String currencyType) {
        this.currencyType = currencyType == null ? null : currencyType.trim();
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getApproveNo() {
        return approveNo;
    }

    public void setApproveNo(String approveNo) {
        this.approveNo = approveNo == null ? null : approveNo.trim();
    }

    public String getApproveResult() {
        return approveResult;
    }

    public void setApproveResult(String approveResult) {
        this.approveResult = approveResult == null ? null : approveResult.trim();
    }

    public String getApproveUserName() {
        return approveUserName;
    }

    public void setApproveUserName(String approveUserName) {
        this.approveUserName = approveUserName == null ? null : approveUserName.trim();
    }

    public Integer getApproveStatus() {
        return approveStatus;
    }

    public void setApproveStatus(Integer approveStatus) {
        this.approveStatus = approveStatus;
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public String getPayConditionsCode() {
        return payConditionsCode;
    }

    public void setPayConditionsCode(String payConditionsCode) {
        this.payConditionsCode = payConditionsCode == null ? null : payConditionsCode.trim();
    }

    public String getPayConditionsDesc() {
        return payConditionsDesc;
    }

    public void setPayConditionsDesc(String payConditionsDesc) {
        this.payConditionsDesc = payConditionsDesc == null ? null : payConditionsDesc.trim();
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getNetPrice() {
        return netPrice;
    }

    public void setNetPrice(BigDecimal netPrice) {
        this.netPrice = netPrice;
    }

    public BigDecimal getIncludeTaxAmount() {
        return includeTaxAmount;
    }

    public void setIncludeTaxAmount(BigDecimal includeTaxAmount) {
        this.includeTaxAmount = includeTaxAmount;
    }

    public BigDecimal getNotIncludeTaxAmount() {
        return notIncludeTaxAmount;
    }

    public void setNotIncludeTaxAmount(BigDecimal notIncludeTaxAmount) {
        this.notIncludeTaxAmount = notIncludeTaxAmount;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getDeductionAmount() {
        return deductionAmount;
    }

    public void setDeductionAmount(BigDecimal deductionAmount) {
        this.deductionAmount = deductionAmount;
    }

    public Date getPostingStartTime() {
        return postingStartTime;
    }

    public void setPostingStartTime(Date postingStartTime) {
        this.postingStartTime = postingStartTime;
    }

    public Date getPostingEndTime() {
        return postingEndTime;
    }

    public void setPostingEndTime(Date postingEndTime) {
        this.postingEndTime = postingEndTime;
    }

    public Integer getCreateBillType() {
        return createBillType;
    }

    public void setCreateBillType(Integer createBillType) {
        this.createBillType = createBillType;
    }

    public String getTaxCode() {
        return taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode == null ? null : taxCode.trim();
    }

    public Integer getSendSapFlag() {
        return sendSapFlag;
    }

    public void setSendSapFlag(Integer sendSapFlag) {
        this.sendSapFlag = sendSapFlag;
    }

    public BigDecimal getRebateNotIncludeTaxAmount() {
        return rebateNotIncludeTaxAmount;
    }

    public void setRebateNotIncludeTaxAmount(BigDecimal rebateNotIncludeTaxAmount) {
        this.rebateNotIncludeTaxAmount = rebateNotIncludeTaxAmount;
    }

    public BigDecimal getRebateIncludeTaxAmount() {
        return rebateIncludeTaxAmount;
    }

    public void setRebateIncludeTaxAmount(BigDecimal rebateIncludeTaxAmount) {
        this.rebateIncludeTaxAmount = rebateIncludeTaxAmount;
    }

    public BigDecimal getRebateTaxAmount() {
        return rebateTaxAmount;
    }

    public void setRebateTaxAmount(BigDecimal rebateTaxAmount) {
        this.rebateTaxAmount = rebateTaxAmount;
    }

    public Integer getInvoiceSignFlag() {
        return invoiceSignFlag;
    }

    public void setInvoiceSignFlag(Integer invoiceSignFlag) {
        this.invoiceSignFlag = invoiceSignFlag;
    }
}