package com.els.base.bill.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value="采购结算管理-开票清单行")
public class BillItemReport implements Serializable {

    //****************非自动生成，请勿覆盖 ****************
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
    //****************非自动生成，请勿覆盖 ****************

    @ApiModelProperty("主键ID")
    private String id;

    @ApiModelProperty("采购商公司ID")
    private String purCompanyId;

    @ApiModelProperty("采购商公司SRM编码")
    private String purCompanySrmCode;

    @ApiModelProperty("采购商公司SAP编码")
    private String purCompanySapCode;

    @ApiModelProperty("采购商公司名称")
    private String purCompanyName;

    @ApiModelProperty("采购商公司全称")
    private String purCompanyFullName;

    @ApiModelProperty("供应商公司ID")
    private String supCompanyId;

    @ApiModelProperty("供应商公司名称")
    private String supCompanyName;

    @ApiModelProperty("供应商公司全称")
    private String supCompanyFullName;

    @ApiModelProperty("供应商公司SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商公司SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty("送货单号")
    private String deliveryOrderNo;

    @ApiModelProperty("送货单行号")
    private String deliveryOrderItemNo;

    @ApiModelProperty("采购单号")
    private String purchaseOrderNo;

    @ApiModelProperty("采购单行号")
    private String purchaseOrderItemNo;

    @ApiModelProperty("物料ID")
    private String materialId;

    @ApiModelProperty("物料编码")
    private String materialNo;

    @ApiModelProperty("物料描述")
    private String materialDesc;

    @ApiModelProperty("物料数量")
    private BigDecimal materialQuantity;

    @ApiModelProperty("物料凭证号")
    private String materialVoucherNo;

    @ApiModelProperty("物料凭证行号")
    private String materialVoucherItemNo;

    @ApiModelProperty("过账日期")
    private Date postingTime;

    @ApiModelProperty("货币类型")
    private String currencyType;

    @ApiModelProperty("移动类型")
    private String billType;

    @ApiModelProperty("是否对账(已对账=1，未对账=0)")
    private Integer billFlag;

    @ApiModelProperty("记录是否可用(可用=1，不可用=0)")
    private Integer isEnable;

    @ApiModelProperty("工厂")
    private String factory;

    @ApiModelProperty("项目类别")
    private String projectTypes;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("开票未税金额")
    private BigDecimal notIncludeTaxAmount;

    @ApiModelProperty("开票含税金额")
    private BigDecimal includeTaxAmount;

    @ApiModelProperty("开票税额")
    private BigDecimal taxAmount;

    @ApiModelProperty("最新采购信息记录价格")
    private BigDecimal latestPrice;

    @ApiModelProperty("单价")
    private BigDecimal orderPrice;

    @ApiModelProperty("订单总金额")
    private BigDecimal orderAmount;

    @ApiModelProperty("对账清单ID")
    private String billId;

    @ApiModelProperty("对账清单号")
    private String billNo;

    @ApiModelProperty("开票凭证ID")
    private String voucherId;

    @ApiModelProperty("发票ID")
    private String billInvoiceId;

    @ApiModelProperty("是否开过发票（已开=1，未开=0）")
    private Integer billInvoiceFlag;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("物料单位")
    private String materialUnit;

    @ApiModelProperty("是否是折让单(0=不是折让单，1=折让单)")
    private Integer isRebate;

    @ApiModelProperty("折让不含税金额")
    private BigDecimal rebateNotIncludeTaxAmount;

    @ApiModelProperty("折让含税金额")
    private BigDecimal rebateIncludeTaxAmount;

    @ApiModelProperty("折让税额")
    private BigDecimal rebateTaxAmount;

    @ApiModelProperty("移动类型对应的符号")
    private String billTypeSign;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("发票代码")
    private String invoiceNo;

    @ApiModelProperty("Sap发票代码")
    private String sapInvoiceNo;

    @ApiModelProperty("项目号")
    private String projectId;

    @ApiModelProperty("系统预制发票")
    private Integer invoiceSignFlag;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanySapCode() {
        return purCompanySapCode;
    }

    public void setPurCompanySapCode(String purCompanySapCode) {
        this.purCompanySapCode = purCompanySapCode == null ? null : purCompanySapCode.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurCompanyFullName() {
        return purCompanyFullName;
    }

    public void setPurCompanyFullName(String purCompanyFullName) {
        this.purCompanyFullName = purCompanyFullName == null ? null : purCompanyFullName.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupCompanyFullName() {
        return supCompanyFullName;
    }

    public void setSupCompanyFullName(String supCompanyFullName) {
        this.supCompanyFullName = supCompanyFullName == null ? null : supCompanyFullName.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getDeliveryOrderNo() {
        return deliveryOrderNo;
    }

    public void setDeliveryOrderNo(String deliveryOrderNo) {
        this.deliveryOrderNo = deliveryOrderNo == null ? null : deliveryOrderNo.trim();
    }

    public String getDeliveryOrderItemNo() {
        return deliveryOrderItemNo;
    }

    public void setDeliveryOrderItemNo(String deliveryOrderItemNo) {
        this.deliveryOrderItemNo = deliveryOrderItemNo == null ? null : deliveryOrderItemNo.trim();
    }

    public String getPurchaseOrderNo() {
        return purchaseOrderNo;
    }

    public void setPurchaseOrderNo(String purchaseOrderNo) {
        this.purchaseOrderNo = purchaseOrderNo == null ? null : purchaseOrderNo.trim();
    }

    public String getPurchaseOrderItemNo() {
        return purchaseOrderItemNo;
    }

    public void setPurchaseOrderItemNo(String purchaseOrderItemNo) {
        this.purchaseOrderItemNo = purchaseOrderItemNo == null ? null : purchaseOrderItemNo.trim();
    }

    public String getMaterialId() {
        return materialId;
    }

    public void setMaterialId(String materialId) {
        this.materialId = materialId == null ? null : materialId.trim();
    }

    public String getMaterialNo() {
        return materialNo;
    }

    public void setMaterialNo(String materialNo) {
        this.materialNo = materialNo == null ? null : materialNo.trim();
    }

    public String getMaterialDesc() {
        return materialDesc;
    }

    public void setMaterialDesc(String materialDesc) {
        this.materialDesc = materialDesc == null ? null : materialDesc.trim();
    }

    public BigDecimal getMaterialQuantity() {
        return materialQuantity;
    }

    public void setMaterialQuantity(BigDecimal materialQuantity) {
        this.materialQuantity = materialQuantity;
    }

    public String getMaterialVoucherNo() {
        return materialVoucherNo;
    }

    public void setMaterialVoucherNo(String materialVoucherNo) {
        this.materialVoucherNo = materialVoucherNo == null ? null : materialVoucherNo.trim();
    }

    public String getMaterialVoucherItemNo() {
        return materialVoucherItemNo;
    }

    public void setMaterialVoucherItemNo(String materialVoucherItemNo) {
        this.materialVoucherItemNo = materialVoucherItemNo == null ? null : materialVoucherItemNo.trim();
    }

    public Date getPostingTime() {
        return postingTime;
    }

    public void setPostingTime(Date postingTime) {
        this.postingTime = postingTime;
    }

    public String getCurrencyType() {
        return currencyType;
    }

    public void setCurrencyType(String currencyType) {
        this.currencyType = currencyType == null ? null : currencyType.trim();
    }

    public String getBillType() {
        return billType;
    }

    public void setBillType(String billType) {
        this.billType = billType == null ? null : billType.trim();
    }

    public Integer getBillFlag() {
        return billFlag;
    }

    public void setBillFlag(Integer billFlag) {
        this.billFlag = billFlag;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public String getFactory() {
        return factory;
    }

    public void setFactory(String factory) {
        this.factory = factory == null ? null : factory.trim();
    }

    public String getProjectTypes() {
        return projectTypes;
    }

    public void setProjectTypes(String projectTypes) {
        this.projectTypes = projectTypes == null ? null : projectTypes.trim();
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getNotIncludeTaxAmount() {
        return notIncludeTaxAmount;
    }

    public void setNotIncludeTaxAmount(BigDecimal notIncludeTaxAmount) {
        this.notIncludeTaxAmount = notIncludeTaxAmount;
    }

    public BigDecimal getIncludeTaxAmount() {
        return includeTaxAmount;
    }

    public void setIncludeTaxAmount(BigDecimal includeTaxAmount) {
        this.includeTaxAmount = includeTaxAmount;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public BigDecimal getLatestPrice() {
        return latestPrice;
    }

    public void setLatestPrice(BigDecimal latestPrice) {
        this.latestPrice = latestPrice;
    }

    public BigDecimal getOrderPrice() {
        return orderPrice;
    }

    public void setOrderPrice(BigDecimal orderPrice) {
        this.orderPrice = orderPrice;
    }

    public BigDecimal getOrderAmount() {
        return orderAmount;
    }

    public void setOrderAmount(BigDecimal orderAmount) {
        this.orderAmount = orderAmount;
    }

    public String getBillId() {
        return billId;
    }

    public void setBillId(String billId) {
        this.billId = billId == null ? null : billId.trim();
    }

    public String getBillNo() {
        return billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo == null ? null : billNo.trim();
    }

    public String getVoucherId() {
        return voucherId;
    }

    public void setVoucherId(String voucherId) {
        this.voucherId = voucherId == null ? null : voucherId.trim();
    }

    public String getBillInvoiceId() {
        return billInvoiceId;
    }

    public void setBillInvoiceId(String billInvoiceId) {
        this.billInvoiceId = billInvoiceId == null ? null : billInvoiceId.trim();
    }

    public Integer getBillInvoiceFlag() {
        return billInvoiceFlag;
    }

    public void setBillInvoiceFlag(Integer billInvoiceFlag) {
        this.billInvoiceFlag = billInvoiceFlag;
    }

    public String getTaxCode() {
        return taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode == null ? null : taxCode.trim();
    }

    public String getMaterialUnit() {
        return materialUnit;
    }

    public void setMaterialUnit(String materialUnit) {
        this.materialUnit = materialUnit == null ? null : materialUnit.trim();
    }

    public Integer getIsRebate() {
        return isRebate;
    }

    public void setIsRebate(Integer isRebate) {
        this.isRebate = isRebate;
    }

    public BigDecimal getRebateNotIncludeTaxAmount() {
        return rebateNotIncludeTaxAmount;
    }

    public void setRebateNotIncludeTaxAmount(BigDecimal rebateNotIncludeTaxAmount) {
        this.rebateNotIncludeTaxAmount = rebateNotIncludeTaxAmount;
    }

    public BigDecimal getRebateIncludeTaxAmount() {
        return rebateIncludeTaxAmount;
    }

    public void setRebateIncludeTaxAmount(BigDecimal rebateIncludeTaxAmount) {
        this.rebateIncludeTaxAmount = rebateIncludeTaxAmount;
    }

    public BigDecimal getRebateTaxAmount() {
        return rebateTaxAmount;
    }

    public void setRebateTaxAmount(BigDecimal rebateTaxAmount) {
        this.rebateTaxAmount = rebateTaxAmount;
    }

    public String getBillTypeSign() {
        return billTypeSign;
    }

    public void setBillTypeSign(String billTypeSign) {
        this.billTypeSign = billTypeSign == null ? null : billTypeSign.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    public String getSapInvoiceNo() {
        return sapInvoiceNo;
    }

    public void setSapInvoiceNo(String sapInvoiceNo) {
        this.sapInvoiceNo = sapInvoiceNo;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public Integer getInvoiceSignFlag() {
        return invoiceSignFlag;
    }

    public void setInvoiceSignFlag(Integer invoiceSignFlag) {
        this.invoiceSignFlag = invoiceSignFlag;
    }
}
