package com.els.base.bill.entity;

import com.els.base.core.entity.AbstractExample;
import com.els.base.core.entity.PageView;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BillItemReportExample extends AbstractExample<BillItemReport> implements Serializable {
    protected String orderByClause;

    protected boolean distinct;

    protected List<Criteria> oredCriteria;

    protected PageView<BillItemReport> pageView = new PageView<BillItemReport>(1, 10);

    private static final long serialVersionUID = 1L;

    public BillItemReportExample() {
        oredCriteria = new ArrayList<Criteria>();
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getOrderByClause() {
        return orderByClause;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return distinct;
    }

    public List<Criteria> getOredCriteria() {
        return oredCriteria;
    }

    public void or(Criteria criteria) {
        oredCriteria.add(criteria);
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria();
        return criteria;
    }

    public void clear() {
        oredCriteria.clear();
        orderByClause = null;
        distinct = false;
    }

    @Override
    public PageView<BillItemReport> getPageView() {
        return pageView;
    }

    @Override
    public void setPageView(PageView<BillItemReport> pageView) {
        this.pageView = pageView;
    }

    protected abstract static class GeneratedCriteria implements Serializable {
        protected List<Criterion> criteria;

        private static final long serialVersionUID = 1L;

        protected GeneratedCriteria() {
            super();
            criteria = new ArrayList<Criterion>();
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public List<Criterion> getCriteria() {
            return criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        public Criteria andIdIsNull() {
            addCriterion("ID is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("ID is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(String value) {
            addCriterion("ID =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(String value) {
            addCriterion("ID <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(String value) {
            addCriterion("ID >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(String value) {
            addCriterion("ID >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(String value) {
            addCriterion("ID <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(String value) {
            addCriterion("ID <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLike(String value) {
            addCriterion("ID like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotLike(String value) {
            addCriterion("ID not like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<String> values) {
            addCriterion("ID in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<String> values) {
            addCriterion("ID not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(String value1, String value2) {
            addCriterion("ID between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(String value1, String value2) {
            addCriterion("ID not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdIsNull() {
            addCriterion("PUR_COMPANY_ID is null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdIsNotNull() {
            addCriterion("PUR_COMPANY_ID is not null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdEqualTo(String value) {
            addCriterion("PUR_COMPANY_ID =", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdNotEqualTo(String value) {
            addCriterion("PUR_COMPANY_ID <>", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdGreaterThan(String value) {
            addCriterion("PUR_COMPANY_ID >", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_ID >=", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdLessThan(String value) {
            addCriterion("PUR_COMPANY_ID <", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdLessThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_ID <=", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdLike(String value) {
            addCriterion("PUR_COMPANY_ID like", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdNotLike(String value) {
            addCriterion("PUR_COMPANY_ID not like", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdIn(List<String> values) {
            addCriterion("PUR_COMPANY_ID in", values, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdNotIn(List<String> values) {
            addCriterion("PUR_COMPANY_ID not in", values, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_ID between", value1, value2, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdNotBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_ID not between", value1, value2, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeIsNull() {
            addCriterion("PUR_COMPANY_SRM_CODE is null");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeIsNotNull() {
            addCriterion("PUR_COMPANY_SRM_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeEqualTo(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE =", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeNotEqualTo(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE <>", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeGreaterThan(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE >", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE >=", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeLessThan(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE <", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeLessThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE <=", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeLike(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE like", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeNotLike(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE not like", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeIn(List<String> values) {
            addCriterion("PUR_COMPANY_SRM_CODE in", values, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeNotIn(List<String> values) {
            addCriterion("PUR_COMPANY_SRM_CODE not in", values, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_SRM_CODE between", value1, value2, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeNotBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_SRM_CODE not between", value1, value2, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeIsNull() {
            addCriterion("PUR_COMPANY_SAP_CODE is null");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeIsNotNull() {
            addCriterion("PUR_COMPANY_SAP_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeEqualTo(String value) {
            addCriterion("PUR_COMPANY_SAP_CODE =", value, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeNotEqualTo(String value) {
            addCriterion("PUR_COMPANY_SAP_CODE <>", value, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeGreaterThan(String value) {
            addCriterion("PUR_COMPANY_SAP_CODE >", value, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_SAP_CODE >=", value, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeLessThan(String value) {
            addCriterion("PUR_COMPANY_SAP_CODE <", value, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeLessThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_SAP_CODE <=", value, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeLike(String value) {
            addCriterion("PUR_COMPANY_SAP_CODE like", value, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeNotLike(String value) {
            addCriterion("PUR_COMPANY_SAP_CODE not like", value, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeIn(List<String> values) {
            addCriterion("PUR_COMPANY_SAP_CODE in", values, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeNotIn(List<String> values) {
            addCriterion("PUR_COMPANY_SAP_CODE not in", values, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_SAP_CODE between", value1, value2, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeNotBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_SAP_CODE not between", value1, value2, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameIsNull() {
            addCriterion("PUR_COMPANY_NAME is null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameIsNotNull() {
            addCriterion("PUR_COMPANY_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameEqualTo(String value) {
            addCriterion("PUR_COMPANY_NAME =", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameNotEqualTo(String value) {
            addCriterion("PUR_COMPANY_NAME <>", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameGreaterThan(String value) {
            addCriterion("PUR_COMPANY_NAME >", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_NAME >=", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameLessThan(String value) {
            addCriterion("PUR_COMPANY_NAME <", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameLessThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_NAME <=", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameLike(String value) {
            addCriterion("PUR_COMPANY_NAME like", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameNotLike(String value) {
            addCriterion("PUR_COMPANY_NAME not like", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameIn(List<String> values) {
            addCriterion("PUR_COMPANY_NAME in", values, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameNotIn(List<String> values) {
            addCriterion("PUR_COMPANY_NAME not in", values, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_NAME between", value1, value2, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameNotBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_NAME not between", value1, value2, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameIsNull() {
            addCriterion("PUR_COMPANY_FULL_NAME is null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameIsNotNull() {
            addCriterion("PUR_COMPANY_FULL_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameEqualTo(String value) {
            addCriterion("PUR_COMPANY_FULL_NAME =", value, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameNotEqualTo(String value) {
            addCriterion("PUR_COMPANY_FULL_NAME <>", value, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameGreaterThan(String value) {
            addCriterion("PUR_COMPANY_FULL_NAME >", value, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_FULL_NAME >=", value, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameLessThan(String value) {
            addCriterion("PUR_COMPANY_FULL_NAME <", value, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameLessThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_FULL_NAME <=", value, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameLike(String value) {
            addCriterion("PUR_COMPANY_FULL_NAME like", value, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameNotLike(String value) {
            addCriterion("PUR_COMPANY_FULL_NAME not like", value, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameIn(List<String> values) {
            addCriterion("PUR_COMPANY_FULL_NAME in", values, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameNotIn(List<String> values) {
            addCriterion("PUR_COMPANY_FULL_NAME not in", values, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_FULL_NAME between", value1, value2, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameNotBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_FULL_NAME not between", value1, value2, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdIsNull() {
            addCriterion("SUP_COMPANY_ID is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdIsNotNull() {
            addCriterion("SUP_COMPANY_ID is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID =", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID <>", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdGreaterThan(String value) {
            addCriterion("SUP_COMPANY_ID >", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID >=", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdLessThan(String value) {
            addCriterion("SUP_COMPANY_ID <", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID <=", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdLike(String value) {
            addCriterion("SUP_COMPANY_ID like", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotLike(String value) {
            addCriterion("SUP_COMPANY_ID not like", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdIn(List<String> values) {
            addCriterion("SUP_COMPANY_ID in", values, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_ID not in", values, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_ID between", value1, value2, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_ID not between", value1, value2, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameIsNull() {
            addCriterion("SUP_COMPANY_NAME is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameIsNotNull() {
            addCriterion("SUP_COMPANY_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameEqualTo(String value) {
            addCriterion("SUP_COMPANY_NAME =", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_NAME <>", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameGreaterThan(String value) {
            addCriterion("SUP_COMPANY_NAME >", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_NAME >=", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameLessThan(String value) {
            addCriterion("SUP_COMPANY_NAME <", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_NAME <=", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameLike(String value) {
            addCriterion("SUP_COMPANY_NAME like", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameNotLike(String value) {
            addCriterion("SUP_COMPANY_NAME not like", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameIn(List<String> values) {
            addCriterion("SUP_COMPANY_NAME in", values, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_NAME not in", values, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_NAME between", value1, value2, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_NAME not between", value1, value2, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameIsNull() {
            addCriterion("SUP_COMPANY_FULL_NAME is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameIsNotNull() {
            addCriterion("SUP_COMPANY_FULL_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameEqualTo(String value) {
            addCriterion("SUP_COMPANY_FULL_NAME =", value, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_FULL_NAME <>", value, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameGreaterThan(String value) {
            addCriterion("SUP_COMPANY_FULL_NAME >", value, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_FULL_NAME >=", value, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameLessThan(String value) {
            addCriterion("SUP_COMPANY_FULL_NAME <", value, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_FULL_NAME <=", value, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameLike(String value) {
            addCriterion("SUP_COMPANY_FULL_NAME like", value, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameNotLike(String value) {
            addCriterion("SUP_COMPANY_FULL_NAME not like", value, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameIn(List<String> values) {
            addCriterion("SUP_COMPANY_FULL_NAME in", values, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_FULL_NAME not in", values, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_FULL_NAME between", value1, value2, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_FULL_NAME not between", value1, value2, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeIsNull() {
            addCriterion("SUP_COMPANY_SRM_CODE is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeIsNotNull() {
            addCriterion("SUP_COMPANY_SRM_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeEqualTo(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE =", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE <>", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeGreaterThan(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE >", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE >=", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeLessThan(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE <", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE <=", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeLike(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE like", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeNotLike(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE not like", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeIn(List<String> values) {
            addCriterion("SUP_COMPANY_SRM_CODE in", values, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_SRM_CODE not in", values, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_SRM_CODE between", value1, value2, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_SRM_CODE not between", value1, value2, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeIsNull() {
            addCriterion("SUP_COMPANY_SAP_CODE is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeIsNotNull() {
            addCriterion("SUP_COMPANY_SAP_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeEqualTo(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE =", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE <>", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeGreaterThan(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE >", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE >=", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeLessThan(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE <", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE <=", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeLike(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE like", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeNotLike(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE not like", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeIn(List<String> values) {
            addCriterion("SUP_COMPANY_SAP_CODE in", values, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_SAP_CODE not in", values, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_SAP_CODE between", value1, value2, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_SAP_CODE not between", value1, value2, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoIsNull() {
            addCriterion("DELIVERY_ORDER_NO is null");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoIsNotNull() {
            addCriterion("DELIVERY_ORDER_NO is not null");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoEqualTo(String value) {
            addCriterion("DELIVERY_ORDER_NO =", value, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoNotEqualTo(String value) {
            addCriterion("DELIVERY_ORDER_NO <>", value, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoGreaterThan(String value) {
            addCriterion("DELIVERY_ORDER_NO >", value, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoGreaterThanOrEqualTo(String value) {
            addCriterion("DELIVERY_ORDER_NO >=", value, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoLessThan(String value) {
            addCriterion("DELIVERY_ORDER_NO <", value, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoLessThanOrEqualTo(String value) {
            addCriterion("DELIVERY_ORDER_NO <=", value, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoLike(String value) {
            addCriterion("DELIVERY_ORDER_NO like", value, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoNotLike(String value) {
            addCriterion("DELIVERY_ORDER_NO not like", value, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoIn(List<String> values) {
            addCriterion("DELIVERY_ORDER_NO in", values, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoNotIn(List<String> values) {
            addCriterion("DELIVERY_ORDER_NO not in", values, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoBetween(String value1, String value2) {
            addCriterion("DELIVERY_ORDER_NO between", value1, value2, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderNoNotBetween(String value1, String value2) {
            addCriterion("DELIVERY_ORDER_NO not between", value1, value2, "deliveryOrderNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoIsNull() {
            addCriterion("DELIVERY_ORDER_ITEM_NO is null");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoIsNotNull() {
            addCriterion("DELIVERY_ORDER_ITEM_NO is not null");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoEqualTo(String value) {
            addCriterion("DELIVERY_ORDER_ITEM_NO =", value, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoNotEqualTo(String value) {
            addCriterion("DELIVERY_ORDER_ITEM_NO <>", value, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoGreaterThan(String value) {
            addCriterion("DELIVERY_ORDER_ITEM_NO >", value, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoGreaterThanOrEqualTo(String value) {
            addCriterion("DELIVERY_ORDER_ITEM_NO >=", value, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoLessThan(String value) {
            addCriterion("DELIVERY_ORDER_ITEM_NO <", value, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoLessThanOrEqualTo(String value) {
            addCriterion("DELIVERY_ORDER_ITEM_NO <=", value, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoLike(String value) {
            addCriterion("DELIVERY_ORDER_ITEM_NO like", value, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoNotLike(String value) {
            addCriterion("DELIVERY_ORDER_ITEM_NO not like", value, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoIn(List<String> values) {
            addCriterion("DELIVERY_ORDER_ITEM_NO in", values, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoNotIn(List<String> values) {
            addCriterion("DELIVERY_ORDER_ITEM_NO not in", values, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoBetween(String value1, String value2) {
            addCriterion("DELIVERY_ORDER_ITEM_NO between", value1, value2, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andDeliveryOrderItemNoNotBetween(String value1, String value2) {
            addCriterion("DELIVERY_ORDER_ITEM_NO not between", value1, value2, "deliveryOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderNoIsNull() {
            addCriterion("PURCHASE_ORDER_NO is null");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderNoIsNotNull() {
            addCriterion("PURCHASE_ORDER_NO is not null");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderNoEqualTo(String value) {
            addCriterion("PURCHASE_ORDER_NO =", value, "purchaseOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderNoNotEqualTo(String value) {
            addCriterion("PURCHASE_ORDER_NO <>", value, "purchaseOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderNoGreaterThan(String value) {
            addCriterion("PURCHASE_ORDER_NO >", value, "purchaseOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderNoGreaterThanOrEqualTo(String value) {
            addCriterion("PURCHASE_ORDER_NO >=", value, "purchaseOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderNoLessThan(String value) {
            addCriterion("PURCHASE_ORDER_NO <", value, "purchaseOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderNoLessThanOrEqualTo(String value) {
            addCriterion("PURCHASE_ORDER_NO <=", value, "purchaseOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderNoLike(String value) {
            addCriterion("PURCHASE_ORDER_NO like", value, "purchaseOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderNoNotLike(String value) {
            addCriterion("PURCHASE_ORDER_NO not like", value, "purchaseOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderNoIn(List<String> values) {
            addCriterion("PURCHASE_ORDER_NO in", values, "purchaseOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderNoNotIn(List<String> values) {
            addCriterion("PURCHASE_ORDER_NO not in", values, "purchaseOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderNoBetween(String value1, String value2) {
            addCriterion("PURCHASE_ORDER_NO between", value1, value2, "purchaseOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderNoNotBetween(String value1, String value2) {
            addCriterion("PURCHASE_ORDER_NO not between", value1, value2, "purchaseOrderNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderItemNoIsNull() {
            addCriterion("PURCHASE_ORDER_ITEM_NO is null");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderItemNoIsNotNull() {
            addCriterion("PURCHASE_ORDER_ITEM_NO is not null");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderItemNoEqualTo(String value) {
            addCriterion("PURCHASE_ORDER_ITEM_NO =", value, "purchaseOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderItemNoNotEqualTo(String value) {
            addCriterion("PURCHASE_ORDER_ITEM_NO <>", value, "purchaseOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderItemNoGreaterThan(String value) {
            addCriterion("PURCHASE_ORDER_ITEM_NO >", value, "purchaseOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderItemNoGreaterThanOrEqualTo(String value) {
            addCriterion("PURCHASE_ORDER_ITEM_NO >=", value, "purchaseOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderItemNoLessThan(String value) {
            addCriterion("PURCHASE_ORDER_ITEM_NO <", value, "purchaseOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderItemNoLessThanOrEqualTo(String value) {
            addCriterion("PURCHASE_ORDER_ITEM_NO <=", value, "purchaseOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderItemNoLike(String value) {
            addCriterion("PURCHASE_ORDER_ITEM_NO like", value, "purchaseOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderItemNoNotLike(String value) {
            addCriterion("PURCHASE_ORDER_ITEM_NO not like", value, "purchaseOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderItemNoIn(List<String> values) {
            addCriterion("PURCHASE_ORDER_ITEM_NO in", values, "purchaseOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderItemNoNotIn(List<String> values) {
            addCriterion("PURCHASE_ORDER_ITEM_NO not in", values, "purchaseOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderItemNoBetween(String value1, String value2) {
            addCriterion("PURCHASE_ORDER_ITEM_NO between", value1, value2, "purchaseOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrderItemNoNotBetween(String value1, String value2) {
            addCriterion("PURCHASE_ORDER_ITEM_NO not between", value1, value2, "purchaseOrderItemNo");
            return (Criteria) this;
        }

        public Criteria andMaterialIdIsNull() {
            addCriterion("MATERIAL_ID is null");
            return (Criteria) this;
        }

        public Criteria andMaterialIdIsNotNull() {
            addCriterion("MATERIAL_ID is not null");
            return (Criteria) this;
        }

        public Criteria andMaterialIdEqualTo(String value) {
            addCriterion("MATERIAL_ID =", value, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdNotEqualTo(String value) {
            addCriterion("MATERIAL_ID <>", value, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdGreaterThan(String value) {
            addCriterion("MATERIAL_ID >", value, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdGreaterThanOrEqualTo(String value) {
            addCriterion("MATERIAL_ID >=", value, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdLessThan(String value) {
            addCriterion("MATERIAL_ID <", value, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdLessThanOrEqualTo(String value) {
            addCriterion("MATERIAL_ID <=", value, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdLike(String value) {
            addCriterion("MATERIAL_ID like", value, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdNotLike(String value) {
            addCriterion("MATERIAL_ID not like", value, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdIn(List<String> values) {
            addCriterion("MATERIAL_ID in", values, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdNotIn(List<String> values) {
            addCriterion("MATERIAL_ID not in", values, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdBetween(String value1, String value2) {
            addCriterion("MATERIAL_ID between", value1, value2, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialIdNotBetween(String value1, String value2) {
            addCriterion("MATERIAL_ID not between", value1, value2, "materialId");
            return (Criteria) this;
        }

        public Criteria andMaterialNoIsNull() {
            addCriterion("MATERIAL_NO is null");
            return (Criteria) this;
        }

        public Criteria andMaterialNoIsNotNull() {
            addCriterion("MATERIAL_NO is not null");
            return (Criteria) this;
        }

        public Criteria andMaterialNoEqualTo(String value) {
            addCriterion("MATERIAL_NO =", value, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoNotEqualTo(String value) {
            addCriterion("MATERIAL_NO <>", value, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoGreaterThan(String value) {
            addCriterion("MATERIAL_NO >", value, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoGreaterThanOrEqualTo(String value) {
            addCriterion("MATERIAL_NO >=", value, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoLessThan(String value) {
            addCriterion("MATERIAL_NO <", value, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoLessThanOrEqualTo(String value) {
            addCriterion("MATERIAL_NO <=", value, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoLike(String value) {
            addCriterion("MATERIAL_NO like", value, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoNotLike(String value) {
            addCriterion("MATERIAL_NO not like", value, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoIn(List<String> values) {
            addCriterion("MATERIAL_NO in", values, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoNotIn(List<String> values) {
            addCriterion("MATERIAL_NO not in", values, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoBetween(String value1, String value2) {
            addCriterion("MATERIAL_NO between", value1, value2, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialNoNotBetween(String value1, String value2) {
            addCriterion("MATERIAL_NO not between", value1, value2, "materialNo");
            return (Criteria) this;
        }

        public Criteria andMaterialDescIsNull() {
            addCriterion("MATERIAL_DESC is null");
            return (Criteria) this;
        }

        public Criteria andMaterialDescIsNotNull() {
            addCriterion("MATERIAL_DESC is not null");
            return (Criteria) this;
        }

        public Criteria andMaterialDescEqualTo(String value) {
            addCriterion("MATERIAL_DESC =", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescNotEqualTo(String value) {
            addCriterion("MATERIAL_DESC <>", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescGreaterThan(String value) {
            addCriterion("MATERIAL_DESC >", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescGreaterThanOrEqualTo(String value) {
            addCriterion("MATERIAL_DESC >=", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescLessThan(String value) {
            addCriterion("MATERIAL_DESC <", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescLessThanOrEqualTo(String value) {
            addCriterion("MATERIAL_DESC <=", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescLike(String value) {
            addCriterion("MATERIAL_DESC like", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescNotLike(String value) {
            addCriterion("MATERIAL_DESC not like", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescIn(List<String> values) {
            addCriterion("MATERIAL_DESC in", values, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescNotIn(List<String> values) {
            addCriterion("MATERIAL_DESC not in", values, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescBetween(String value1, String value2) {
            addCriterion("MATERIAL_DESC between", value1, value2, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescNotBetween(String value1, String value2) {
            addCriterion("MATERIAL_DESC not between", value1, value2, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialQuantityIsNull() {
            addCriterion("MATERIAL_QUANTITY is null");
            return (Criteria) this;
        }

        public Criteria andMaterialQuantityIsNotNull() {
            addCriterion("MATERIAL_QUANTITY is not null");
            return (Criteria) this;
        }

        public Criteria andMaterialQuantityEqualTo(BigDecimal value) {
            addCriterion("MATERIAL_QUANTITY =", value, "materialQuantity");
            return (Criteria) this;
        }

        public Criteria andMaterialQuantityNotEqualTo(BigDecimal value) {
            addCriterion("MATERIAL_QUANTITY <>", value, "materialQuantity");
            return (Criteria) this;
        }

        public Criteria andMaterialQuantityGreaterThan(BigDecimal value) {
            addCriterion("MATERIAL_QUANTITY >", value, "materialQuantity");
            return (Criteria) this;
        }

        public Criteria andMaterialQuantityGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("MATERIAL_QUANTITY >=", value, "materialQuantity");
            return (Criteria) this;
        }

        public Criteria andMaterialQuantityLessThan(BigDecimal value) {
            addCriterion("MATERIAL_QUANTITY <", value, "materialQuantity");
            return (Criteria) this;
        }

        public Criteria andMaterialQuantityLessThanOrEqualTo(BigDecimal value) {
            addCriterion("MATERIAL_QUANTITY <=", value, "materialQuantity");
            return (Criteria) this;
        }

        public Criteria andMaterialQuantityIn(List<BigDecimal> values) {
            addCriterion("MATERIAL_QUANTITY in", values, "materialQuantity");
            return (Criteria) this;
        }

        public Criteria andMaterialQuantityNotIn(List<BigDecimal> values) {
            addCriterion("MATERIAL_QUANTITY not in", values, "materialQuantity");
            return (Criteria) this;
        }

        public Criteria andMaterialQuantityBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("MATERIAL_QUANTITY between", value1, value2, "materialQuantity");
            return (Criteria) this;
        }

        public Criteria andMaterialQuantityNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("MATERIAL_QUANTITY not between", value1, value2, "materialQuantity");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherNoIsNull() {
            addCriterion("MATERIAL_VOUCHER_NO is null");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherNoIsNotNull() {
            addCriterion("MATERIAL_VOUCHER_NO is not null");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherNoEqualTo(String value) {
            addCriterion("MATERIAL_VOUCHER_NO =", value, "materialVoucherNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherNoNotEqualTo(String value) {
            addCriterion("MATERIAL_VOUCHER_NO <>", value, "materialVoucherNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherNoGreaterThan(String value) {
            addCriterion("MATERIAL_VOUCHER_NO >", value, "materialVoucherNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherNoGreaterThanOrEqualTo(String value) {
            addCriterion("MATERIAL_VOUCHER_NO >=", value, "materialVoucherNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherNoLessThan(String value) {
            addCriterion("MATERIAL_VOUCHER_NO <", value, "materialVoucherNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherNoLessThanOrEqualTo(String value) {
            addCriterion("MATERIAL_VOUCHER_NO <=", value, "materialVoucherNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherNoLike(String value) {
            addCriterion("MATERIAL_VOUCHER_NO like", value, "materialVoucherNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherNoNotLike(String value) {
            addCriterion("MATERIAL_VOUCHER_NO not like", value, "materialVoucherNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherNoIn(List<String> values) {
            addCriterion("MATERIAL_VOUCHER_NO in", values, "materialVoucherNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherNoNotIn(List<String> values) {
            addCriterion("MATERIAL_VOUCHER_NO not in", values, "materialVoucherNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherNoBetween(String value1, String value2) {
            addCriterion("MATERIAL_VOUCHER_NO between", value1, value2, "materialVoucherNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherNoNotBetween(String value1, String value2) {
            addCriterion("MATERIAL_VOUCHER_NO not between", value1, value2, "materialVoucherNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherItemNoIsNull() {
            addCriterion("MATERIAL_VOUCHER_ITEM_NO is null");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherItemNoIsNotNull() {
            addCriterion("MATERIAL_VOUCHER_ITEM_NO is not null");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherItemNoEqualTo(String value) {
            addCriterion("MATERIAL_VOUCHER_ITEM_NO =", value, "materialVoucherItemNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherItemNoNotEqualTo(String value) {
            addCriterion("MATERIAL_VOUCHER_ITEM_NO <>", value, "materialVoucherItemNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherItemNoGreaterThan(String value) {
            addCriterion("MATERIAL_VOUCHER_ITEM_NO >", value, "materialVoucherItemNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherItemNoGreaterThanOrEqualTo(String value) {
            addCriterion("MATERIAL_VOUCHER_ITEM_NO >=", value, "materialVoucherItemNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherItemNoLessThan(String value) {
            addCriterion("MATERIAL_VOUCHER_ITEM_NO <", value, "materialVoucherItemNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherItemNoLessThanOrEqualTo(String value) {
            addCriterion("MATERIAL_VOUCHER_ITEM_NO <=", value, "materialVoucherItemNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherItemNoLike(String value) {
            addCriterion("MATERIAL_VOUCHER_ITEM_NO like", value, "materialVoucherItemNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherItemNoNotLike(String value) {
            addCriterion("MATERIAL_VOUCHER_ITEM_NO not like", value, "materialVoucherItemNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherItemNoIn(List<String> values) {
            addCriterion("MATERIAL_VOUCHER_ITEM_NO in", values, "materialVoucherItemNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherItemNoNotIn(List<String> values) {
            addCriterion("MATERIAL_VOUCHER_ITEM_NO not in", values, "materialVoucherItemNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherItemNoBetween(String value1, String value2) {
            addCriterion("MATERIAL_VOUCHER_ITEM_NO between", value1, value2, "materialVoucherItemNo");
            return (Criteria) this;
        }

        public Criteria andMaterialVoucherItemNoNotBetween(String value1, String value2) {
            addCriterion("MATERIAL_VOUCHER_ITEM_NO not between", value1, value2, "materialVoucherItemNo");
            return (Criteria) this;
        }

        public Criteria andPostingTimeIsNull() {
            addCriterion("POSTING_TIME is null");
            return (Criteria) this;
        }

        public Criteria andPostingTimeIsNotNull() {
            addCriterion("POSTING_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andPostingTimeEqualTo(Date value) {
            addCriterion("POSTING_TIME =", value, "postingTime");
            return (Criteria) this;
        }

        public Criteria andPostingTimeNotEqualTo(Date value) {
            addCriterion("POSTING_TIME <>", value, "postingTime");
            return (Criteria) this;
        }

        public Criteria andPostingTimeGreaterThan(Date value) {
            addCriterion("POSTING_TIME >", value, "postingTime");
            return (Criteria) this;
        }

        public Criteria andPostingTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("POSTING_TIME >=", value, "postingTime");
            return (Criteria) this;
        }

        public Criteria andPostingTimeLessThan(Date value) {
            addCriterion("POSTING_TIME <", value, "postingTime");
            return (Criteria) this;
        }

        public Criteria andPostingTimeLessThanOrEqualTo(Date value) {
            addCriterion("POSTING_TIME <=", value, "postingTime");
            return (Criteria) this;
        }

        public Criteria andPostingTimeIn(List<Date> values) {
            addCriterion("POSTING_TIME in", values, "postingTime");
            return (Criteria) this;
        }

        public Criteria andPostingTimeNotIn(List<Date> values) {
            addCriterion("POSTING_TIME not in", values, "postingTime");
            return (Criteria) this;
        }

        public Criteria andPostingTimeBetween(Date value1, Date value2) {
            addCriterion("POSTING_TIME between", value1, value2, "postingTime");
            return (Criteria) this;
        }

        public Criteria andPostingTimeNotBetween(Date value1, Date value2) {
            addCriterion("POSTING_TIME not between", value1, value2, "postingTime");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeIsNull() {
            addCriterion("CURRENCY_TYPE is null");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeIsNotNull() {
            addCriterion("CURRENCY_TYPE is not null");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeEqualTo(String value) {
            addCriterion("CURRENCY_TYPE =", value, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeNotEqualTo(String value) {
            addCriterion("CURRENCY_TYPE <>", value, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeGreaterThan(String value) {
            addCriterion("CURRENCY_TYPE >", value, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeGreaterThanOrEqualTo(String value) {
            addCriterion("CURRENCY_TYPE >=", value, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeLessThan(String value) {
            addCriterion("CURRENCY_TYPE <", value, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeLessThanOrEqualTo(String value) {
            addCriterion("CURRENCY_TYPE <=", value, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeLike(String value) {
            addCriterion("CURRENCY_TYPE like", value, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeNotLike(String value) {
            addCriterion("CURRENCY_TYPE not like", value, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeIn(List<String> values) {
            addCriterion("CURRENCY_TYPE in", values, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeNotIn(List<String> values) {
            addCriterion("CURRENCY_TYPE not in", values, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeBetween(String value1, String value2) {
            addCriterion("CURRENCY_TYPE between", value1, value2, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeNotBetween(String value1, String value2) {
            addCriterion("CURRENCY_TYPE not between", value1, value2, "currencyType");
            return (Criteria) this;
        }

        public Criteria andBillTypeIsNull() {
            addCriterion("BILL_TYPE is null");
            return (Criteria) this;
        }

        public Criteria andBillTypeIsNotNull() {
            addCriterion("BILL_TYPE is not null");
            return (Criteria) this;
        }

        public Criteria andBillTypeEqualTo(String value) {
            addCriterion("BILL_TYPE =", value, "billType");
            return (Criteria) this;
        }

        public Criteria andBillTypeNotEqualTo(String value) {
            addCriterion("BILL_TYPE <>", value, "billType");
            return (Criteria) this;
        }

        public Criteria andBillTypeGreaterThan(String value) {
            addCriterion("BILL_TYPE >", value, "billType");
            return (Criteria) this;
        }

        public Criteria andBillTypeGreaterThanOrEqualTo(String value) {
            addCriterion("BILL_TYPE >=", value, "billType");
            return (Criteria) this;
        }

        public Criteria andBillTypeLessThan(String value) {
            addCriterion("BILL_TYPE <", value, "billType");
            return (Criteria) this;
        }

        public Criteria andBillTypeLessThanOrEqualTo(String value) {
            addCriterion("BILL_TYPE <=", value, "billType");
            return (Criteria) this;
        }

        public Criteria andBillTypeLike(String value) {
            addCriterion("BILL_TYPE like", value, "billType");
            return (Criteria) this;
        }

        public Criteria andBillTypeNotLike(String value) {
            addCriterion("BILL_TYPE not like", value, "billType");
            return (Criteria) this;
        }

        public Criteria andBillTypeIn(List<String> values) {
            addCriterion("BILL_TYPE in", values, "billType");
            return (Criteria) this;
        }

        public Criteria andBillTypeNotIn(List<String> values) {
            addCriterion("BILL_TYPE not in", values, "billType");
            return (Criteria) this;
        }

        public Criteria andBillTypeBetween(String value1, String value2) {
            addCriterion("BILL_TYPE between", value1, value2, "billType");
            return (Criteria) this;
        }

        public Criteria andBillTypeNotBetween(String value1, String value2) {
            addCriterion("BILL_TYPE not between", value1, value2, "billType");
            return (Criteria) this;
        }

        public Criteria andBillFlagIsNull() {
            addCriterion("BILL_FLAG is null");
            return (Criteria) this;
        }

        public Criteria andBillFlagIsNotNull() {
            addCriterion("BILL_FLAG is not null");
            return (Criteria) this;
        }

        public Criteria andBillFlagEqualTo(Integer value) {
            addCriterion("BILL_FLAG =", value, "billFlag");
            return (Criteria) this;
        }

        public Criteria andBillFlagNotEqualTo(Integer value) {
            addCriterion("BILL_FLAG <>", value, "billFlag");
            return (Criteria) this;
        }

        public Criteria andBillFlagGreaterThan(Integer value) {
            addCriterion("BILL_FLAG >", value, "billFlag");
            return (Criteria) this;
        }

        public Criteria andBillFlagGreaterThanOrEqualTo(Integer value) {
            addCriterion("BILL_FLAG >=", value, "billFlag");
            return (Criteria) this;
        }

        public Criteria andBillFlagLessThan(Integer value) {
            addCriterion("BILL_FLAG <", value, "billFlag");
            return (Criteria) this;
        }

        public Criteria andBillFlagLessThanOrEqualTo(Integer value) {
            addCriterion("BILL_FLAG <=", value, "billFlag");
            return (Criteria) this;
        }

        public Criteria andBillFlagIn(List<Integer> values) {
            addCriterion("BILL_FLAG in", values, "billFlag");
            return (Criteria) this;
        }

        public Criteria andBillFlagNotIn(List<Integer> values) {
            addCriterion("BILL_FLAG not in", values, "billFlag");
            return (Criteria) this;
        }

        public Criteria andBillFlagBetween(Integer value1, Integer value2) {
            addCriterion("BILL_FLAG between", value1, value2, "billFlag");
            return (Criteria) this;
        }

        public Criteria andBillFlagNotBetween(Integer value1, Integer value2) {
            addCriterion("BILL_FLAG not between", value1, value2, "billFlag");
            return (Criteria) this;
        }

        public Criteria andIsEnableIsNull() {
            addCriterion("IS_ENABLE is null");
            return (Criteria) this;
        }

        public Criteria andIsEnableIsNotNull() {
            addCriterion("IS_ENABLE is not null");
            return (Criteria) this;
        }

        public Criteria andIsEnableEqualTo(Integer value) {
            addCriterion("IS_ENABLE =", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotEqualTo(Integer value) {
            addCriterion("IS_ENABLE <>", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableGreaterThan(Integer value) {
            addCriterion("IS_ENABLE >", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableGreaterThanOrEqualTo(Integer value) {
            addCriterion("IS_ENABLE >=", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableLessThan(Integer value) {
            addCriterion("IS_ENABLE <", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableLessThanOrEqualTo(Integer value) {
            addCriterion("IS_ENABLE <=", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableIn(List<Integer> values) {
            addCriterion("IS_ENABLE in", values, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotIn(List<Integer> values) {
            addCriterion("IS_ENABLE not in", values, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableBetween(Integer value1, Integer value2) {
            addCriterion("IS_ENABLE between", value1, value2, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotBetween(Integer value1, Integer value2) {
            addCriterion("IS_ENABLE not between", value1, value2, "isEnable");
            return (Criteria) this;
        }

        public Criteria andFactoryIsNull() {
            addCriterion("FACTORY is null");
            return (Criteria) this;
        }

        public Criteria andFactoryIsNotNull() {
            addCriterion("FACTORY is not null");
            return (Criteria) this;
        }

        public Criteria andFactoryEqualTo(String value) {
            addCriterion("FACTORY =", value, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryNotEqualTo(String value) {
            addCriterion("FACTORY <>", value, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryGreaterThan(String value) {
            addCriterion("FACTORY >", value, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryGreaterThanOrEqualTo(String value) {
            addCriterion("FACTORY >=", value, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryLessThan(String value) {
            addCriterion("FACTORY <", value, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryLessThanOrEqualTo(String value) {
            addCriterion("FACTORY <=", value, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryLike(String value) {
            addCriterion("FACTORY like", value, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryNotLike(String value) {
            addCriterion("FACTORY not like", value, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryIn(List<String> values) {
            addCriterion("FACTORY in", values, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryNotIn(List<String> values) {
            addCriterion("FACTORY not in", values, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryBetween(String value1, String value2) {
            addCriterion("FACTORY between", value1, value2, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryNotBetween(String value1, String value2) {
            addCriterion("FACTORY not between", value1, value2, "factory");
            return (Criteria) this;
        }

        public Criteria andProjectTypesIsNull() {
            addCriterion("PROJECT_TYPES is null");
            return (Criteria) this;
        }

        public Criteria andProjectTypesIsNotNull() {
            addCriterion("PROJECT_TYPES is not null");
            return (Criteria) this;
        }

        public Criteria andProjectTypesEqualTo(String value) {
            addCriterion("PROJECT_TYPES =", value, "projectTypes");
            return (Criteria) this;
        }

        public Criteria andProjectTypesNotEqualTo(String value) {
            addCriterion("PROJECT_TYPES <>", value, "projectTypes");
            return (Criteria) this;
        }

        public Criteria andProjectTypesGreaterThan(String value) {
            addCriterion("PROJECT_TYPES >", value, "projectTypes");
            return (Criteria) this;
        }

        public Criteria andProjectTypesGreaterThanOrEqualTo(String value) {
            addCriterion("PROJECT_TYPES >=", value, "projectTypes");
            return (Criteria) this;
        }

        public Criteria andProjectTypesLessThan(String value) {
            addCriterion("PROJECT_TYPES <", value, "projectTypes");
            return (Criteria) this;
        }

        public Criteria andProjectTypesLessThanOrEqualTo(String value) {
            addCriterion("PROJECT_TYPES <=", value, "projectTypes");
            return (Criteria) this;
        }

        public Criteria andProjectTypesLike(String value) {
            addCriterion("PROJECT_TYPES like", value, "projectTypes");
            return (Criteria) this;
        }

        public Criteria andProjectTypesNotLike(String value) {
            addCriterion("PROJECT_TYPES not like", value, "projectTypes");
            return (Criteria) this;
        }

        public Criteria andProjectTypesIn(List<String> values) {
            addCriterion("PROJECT_TYPES in", values, "projectTypes");
            return (Criteria) this;
        }

        public Criteria andProjectTypesNotIn(List<String> values) {
            addCriterion("PROJECT_TYPES not in", values, "projectTypes");
            return (Criteria) this;
        }

        public Criteria andProjectTypesBetween(String value1, String value2) {
            addCriterion("PROJECT_TYPES between", value1, value2, "projectTypes");
            return (Criteria) this;
        }

        public Criteria andProjectTypesNotBetween(String value1, String value2) {
            addCriterion("PROJECT_TYPES not between", value1, value2, "projectTypes");
            return (Criteria) this;
        }

        public Criteria andTaxRateIsNull() {
            addCriterion("TAX_RATE is null");
            return (Criteria) this;
        }

        public Criteria andTaxRateIsNotNull() {
            addCriterion("TAX_RATE is not null");
            return (Criteria) this;
        }

        public Criteria andTaxRateEqualTo(BigDecimal value) {
            addCriterion("TAX_RATE =", value, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateNotEqualTo(BigDecimal value) {
            addCriterion("TAX_RATE <>", value, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateGreaterThan(BigDecimal value) {
            addCriterion("TAX_RATE >", value, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("TAX_RATE >=", value, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateLessThan(BigDecimal value) {
            addCriterion("TAX_RATE <", value, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateLessThanOrEqualTo(BigDecimal value) {
            addCriterion("TAX_RATE <=", value, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateIn(List<BigDecimal> values) {
            addCriterion("TAX_RATE in", values, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateNotIn(List<BigDecimal> values) {
            addCriterion("TAX_RATE not in", values, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TAX_RATE between", value1, value2, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TAX_RATE not between", value1, value2, "taxRate");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountIsNull() {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountIsNotNull() {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountEqualTo(BigDecimal value) {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT =", value, "notIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountNotEqualTo(BigDecimal value) {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT <>", value, "notIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountGreaterThan(BigDecimal value) {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT >", value, "notIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT >=", value, "notIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountLessThan(BigDecimal value) {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT <", value, "notIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT <=", value, "notIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountIn(List<BigDecimal> values) {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT in", values, "notIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountNotIn(List<BigDecimal> values) {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT not in", values, "notIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT between", value1, value2, "notIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT not between", value1, value2, "notIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountIsNull() {
            addCriterion("INCLUDE_TAX_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountIsNotNull() {
            addCriterion("INCLUDE_TAX_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountEqualTo(BigDecimal value) {
            addCriterion("INCLUDE_TAX_AMOUNT =", value, "includeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountNotEqualTo(BigDecimal value) {
            addCriterion("INCLUDE_TAX_AMOUNT <>", value, "includeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountGreaterThan(BigDecimal value) {
            addCriterion("INCLUDE_TAX_AMOUNT >", value, "includeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("INCLUDE_TAX_AMOUNT >=", value, "includeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountLessThan(BigDecimal value) {
            addCriterion("INCLUDE_TAX_AMOUNT <", value, "includeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("INCLUDE_TAX_AMOUNT <=", value, "includeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountIn(List<BigDecimal> values) {
            addCriterion("INCLUDE_TAX_AMOUNT in", values, "includeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountNotIn(List<BigDecimal> values) {
            addCriterion("INCLUDE_TAX_AMOUNT not in", values, "includeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("INCLUDE_TAX_AMOUNT between", value1, value2, "includeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("INCLUDE_TAX_AMOUNT not between", value1, value2, "includeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountIsNull() {
            addCriterion("TAX_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andTaxAmountIsNotNull() {
            addCriterion("TAX_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andTaxAmountEqualTo(BigDecimal value) {
            addCriterion("TAX_AMOUNT =", value, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountNotEqualTo(BigDecimal value) {
            addCriterion("TAX_AMOUNT <>", value, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountGreaterThan(BigDecimal value) {
            addCriterion("TAX_AMOUNT >", value, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("TAX_AMOUNT >=", value, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountLessThan(BigDecimal value) {
            addCriterion("TAX_AMOUNT <", value, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("TAX_AMOUNT <=", value, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountIn(List<BigDecimal> values) {
            addCriterion("TAX_AMOUNT in", values, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountNotIn(List<BigDecimal> values) {
            addCriterion("TAX_AMOUNT not in", values, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TAX_AMOUNT between", value1, value2, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TAX_AMOUNT not between", value1, value2, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andLatestPriceIsNull() {
            addCriterion("LATEST_PRICE is null");
            return (Criteria) this;
        }

        public Criteria andLatestPriceIsNotNull() {
            addCriterion("LATEST_PRICE is not null");
            return (Criteria) this;
        }

        public Criteria andLatestPriceEqualTo(BigDecimal value) {
            addCriterion("LATEST_PRICE =", value, "latestPrice");
            return (Criteria) this;
        }

        public Criteria andLatestPriceNotEqualTo(BigDecimal value) {
            addCriterion("LATEST_PRICE <>", value, "latestPrice");
            return (Criteria) this;
        }

        public Criteria andLatestPriceGreaterThan(BigDecimal value) {
            addCriterion("LATEST_PRICE >", value, "latestPrice");
            return (Criteria) this;
        }

        public Criteria andLatestPriceGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("LATEST_PRICE >=", value, "latestPrice");
            return (Criteria) this;
        }

        public Criteria andLatestPriceLessThan(BigDecimal value) {
            addCriterion("LATEST_PRICE <", value, "latestPrice");
            return (Criteria) this;
        }

        public Criteria andLatestPriceLessThanOrEqualTo(BigDecimal value) {
            addCriterion("LATEST_PRICE <=", value, "latestPrice");
            return (Criteria) this;
        }

        public Criteria andLatestPriceIn(List<BigDecimal> values) {
            addCriterion("LATEST_PRICE in", values, "latestPrice");
            return (Criteria) this;
        }

        public Criteria andLatestPriceNotIn(List<BigDecimal> values) {
            addCriterion("LATEST_PRICE not in", values, "latestPrice");
            return (Criteria) this;
        }

        public Criteria andLatestPriceBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("LATEST_PRICE between", value1, value2, "latestPrice");
            return (Criteria) this;
        }

        public Criteria andLatestPriceNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("LATEST_PRICE not between", value1, value2, "latestPrice");
            return (Criteria) this;
        }

        public Criteria andOrderPriceIsNull() {
            addCriterion("ORDER_PRICE is null");
            return (Criteria) this;
        }

        public Criteria andOrderPriceIsNotNull() {
            addCriterion("ORDER_PRICE is not null");
            return (Criteria) this;
        }

        public Criteria andOrderPriceEqualTo(BigDecimal value) {
            addCriterion("ORDER_PRICE =", value, "orderPrice");
            return (Criteria) this;
        }

        public Criteria andOrderPriceNotEqualTo(BigDecimal value) {
            addCriterion("ORDER_PRICE <>", value, "orderPrice");
            return (Criteria) this;
        }

        public Criteria andOrderPriceGreaterThan(BigDecimal value) {
            addCriterion("ORDER_PRICE >", value, "orderPrice");
            return (Criteria) this;
        }

        public Criteria andOrderPriceGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("ORDER_PRICE >=", value, "orderPrice");
            return (Criteria) this;
        }

        public Criteria andOrderPriceLessThan(BigDecimal value) {
            addCriterion("ORDER_PRICE <", value, "orderPrice");
            return (Criteria) this;
        }

        public Criteria andOrderPriceLessThanOrEqualTo(BigDecimal value) {
            addCriterion("ORDER_PRICE <=", value, "orderPrice");
            return (Criteria) this;
        }

        public Criteria andOrderPriceIn(List<BigDecimal> values) {
            addCriterion("ORDER_PRICE in", values, "orderPrice");
            return (Criteria) this;
        }

        public Criteria andOrderPriceNotIn(List<BigDecimal> values) {
            addCriterion("ORDER_PRICE not in", values, "orderPrice");
            return (Criteria) this;
        }

        public Criteria andOrderPriceBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("ORDER_PRICE between", value1, value2, "orderPrice");
            return (Criteria) this;
        }

        public Criteria andOrderPriceNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("ORDER_PRICE not between", value1, value2, "orderPrice");
            return (Criteria) this;
        }

        public Criteria andOrderAmountIsNull() {
            addCriterion("ORDER_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andOrderAmountIsNotNull() {
            addCriterion("ORDER_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andOrderAmountEqualTo(BigDecimal value) {
            addCriterion("ORDER_AMOUNT =", value, "orderAmount");
            return (Criteria) this;
        }

        public Criteria andOrderAmountNotEqualTo(BigDecimal value) {
            addCriterion("ORDER_AMOUNT <>", value, "orderAmount");
            return (Criteria) this;
        }

        public Criteria andOrderAmountGreaterThan(BigDecimal value) {
            addCriterion("ORDER_AMOUNT >", value, "orderAmount");
            return (Criteria) this;
        }

        public Criteria andOrderAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("ORDER_AMOUNT >=", value, "orderAmount");
            return (Criteria) this;
        }

        public Criteria andOrderAmountLessThan(BigDecimal value) {
            addCriterion("ORDER_AMOUNT <", value, "orderAmount");
            return (Criteria) this;
        }

        public Criteria andOrderAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("ORDER_AMOUNT <=", value, "orderAmount");
            return (Criteria) this;
        }

        public Criteria andOrderAmountIn(List<BigDecimal> values) {
            addCriterion("ORDER_AMOUNT in", values, "orderAmount");
            return (Criteria) this;
        }

        public Criteria andOrderAmountNotIn(List<BigDecimal> values) {
            addCriterion("ORDER_AMOUNT not in", values, "orderAmount");
            return (Criteria) this;
        }

        public Criteria andOrderAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("ORDER_AMOUNT between", value1, value2, "orderAmount");
            return (Criteria) this;
        }

        public Criteria andOrderAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("ORDER_AMOUNT not between", value1, value2, "orderAmount");
            return (Criteria) this;
        }

        public Criteria andBillIdIsNull() {
            addCriterion("BILL_ID is null");
            return (Criteria) this;
        }

        public Criteria andBillIdIsNotNull() {
            addCriterion("BILL_ID is not null");
            return (Criteria) this;
        }

        public Criteria andBillIdEqualTo(String value) {
            addCriterion("BILL_ID =", value, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdNotEqualTo(String value) {
            addCriterion("BILL_ID <>", value, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdGreaterThan(String value) {
            addCriterion("BILL_ID >", value, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdGreaterThanOrEqualTo(String value) {
            addCriterion("BILL_ID >=", value, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdLessThan(String value) {
            addCriterion("BILL_ID <", value, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdLessThanOrEqualTo(String value) {
            addCriterion("BILL_ID <=", value, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdLike(String value) {
            addCriterion("BILL_ID like", value, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdNotLike(String value) {
            addCriterion("BILL_ID not like", value, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdIn(List<String> values) {
            addCriterion("BILL_ID in", values, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdNotIn(List<String> values) {
            addCriterion("BILL_ID not in", values, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdBetween(String value1, String value2) {
            addCriterion("BILL_ID between", value1, value2, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdNotBetween(String value1, String value2) {
            addCriterion("BILL_ID not between", value1, value2, "billId");
            return (Criteria) this;
        }

        public Criteria andBillNoIsNull() {
            addCriterion("BILL_NO is null");
            return (Criteria) this;
        }

        public Criteria andBillNoIsNotNull() {
            addCriterion("BILL_NO is not null");
            return (Criteria) this;
        }

        public Criteria andBillNoEqualTo(String value) {
            addCriterion("BILL_NO =", value, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoNotEqualTo(String value) {
            addCriterion("BILL_NO <>", value, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoGreaterThan(String value) {
            addCriterion("BILL_NO >", value, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoGreaterThanOrEqualTo(String value) {
            addCriterion("BILL_NO >=", value, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoLessThan(String value) {
            addCriterion("BILL_NO <", value, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoLessThanOrEqualTo(String value) {
            addCriterion("BILL_NO <=", value, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoLike(String value) {
            addCriterion("BILL_NO like", value, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoNotLike(String value) {
            addCriterion("BILL_NO not like", value, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoIn(List<String> values) {
            addCriterion("BILL_NO in", values, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoNotIn(List<String> values) {
            addCriterion("BILL_NO not in", values, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoBetween(String value1, String value2) {
            addCriterion("BILL_NO between", value1, value2, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoNotBetween(String value1, String value2) {
            addCriterion("BILL_NO not between", value1, value2, "billNo");
            return (Criteria) this;
        }

        public Criteria andVoucherIdIsNull() {
            addCriterion("VOUCHER_ID is null");
            return (Criteria) this;
        }

        public Criteria andVoucherIdIsNotNull() {
            addCriterion("VOUCHER_ID is not null");
            return (Criteria) this;
        }

        public Criteria andVoucherIdEqualTo(String value) {
            addCriterion("VOUCHER_ID =", value, "voucherId");
            return (Criteria) this;
        }

        public Criteria andVoucherIdNotEqualTo(String value) {
            addCriterion("VOUCHER_ID <>", value, "voucherId");
            return (Criteria) this;
        }

        public Criteria andVoucherIdGreaterThan(String value) {
            addCriterion("VOUCHER_ID >", value, "voucherId");
            return (Criteria) this;
        }

        public Criteria andVoucherIdGreaterThanOrEqualTo(String value) {
            addCriterion("VOUCHER_ID >=", value, "voucherId");
            return (Criteria) this;
        }

        public Criteria andVoucherIdLessThan(String value) {
            addCriterion("VOUCHER_ID <", value, "voucherId");
            return (Criteria) this;
        }

        public Criteria andVoucherIdLessThanOrEqualTo(String value) {
            addCriterion("VOUCHER_ID <=", value, "voucherId");
            return (Criteria) this;
        }

        public Criteria andVoucherIdLike(String value) {
            addCriterion("VOUCHER_ID like", value, "voucherId");
            return (Criteria) this;
        }

        public Criteria andVoucherIdNotLike(String value) {
            addCriterion("VOUCHER_ID not like", value, "voucherId");
            return (Criteria) this;
        }

        public Criteria andVoucherIdIn(List<String> values) {
            addCriterion("VOUCHER_ID in", values, "voucherId");
            return (Criteria) this;
        }

        public Criteria andVoucherIdNotIn(List<String> values) {
            addCriterion("VOUCHER_ID not in", values, "voucherId");
            return (Criteria) this;
        }

        public Criteria andVoucherIdBetween(String value1, String value2) {
            addCriterion("VOUCHER_ID between", value1, value2, "voucherId");
            return (Criteria) this;
        }

        public Criteria andVoucherIdNotBetween(String value1, String value2) {
            addCriterion("VOUCHER_ID not between", value1, value2, "voucherId");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceIdIsNull() {
            addCriterion("BILL_INVOICE_ID is null");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceIdIsNotNull() {
            addCriterion("BILL_INVOICE_ID is not null");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceIdEqualTo(String value) {
            addCriterion("BILL_INVOICE_ID =", value, "billInvoiceId");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceIdNotEqualTo(String value) {
            addCriterion("BILL_INVOICE_ID <>", value, "billInvoiceId");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceIdGreaterThan(String value) {
            addCriterion("BILL_INVOICE_ID >", value, "billInvoiceId");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceIdGreaterThanOrEqualTo(String value) {
            addCriterion("BILL_INVOICE_ID >=", value, "billInvoiceId");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceIdLessThan(String value) {
            addCriterion("BILL_INVOICE_ID <", value, "billInvoiceId");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceIdLessThanOrEqualTo(String value) {
            addCriterion("BILL_INVOICE_ID <=", value, "billInvoiceId");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceIdLike(String value) {
            addCriterion("BILL_INVOICE_ID like", value, "billInvoiceId");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceIdNotLike(String value) {
            addCriterion("BILL_INVOICE_ID not like", value, "billInvoiceId");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceIdIn(List<String> values) {
            addCriterion("BILL_INVOICE_ID in", values, "billInvoiceId");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceIdNotIn(List<String> values) {
            addCriterion("BILL_INVOICE_ID not in", values, "billInvoiceId");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceIdBetween(String value1, String value2) {
            addCriterion("BILL_INVOICE_ID between", value1, value2, "billInvoiceId");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceIdNotBetween(String value1, String value2) {
            addCriterion("BILL_INVOICE_ID not between", value1, value2, "billInvoiceId");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceFlagIsNull() {
            addCriterion("BILL_INVOICE_FLAG is null");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceFlagIsNotNull() {
            addCriterion("BILL_INVOICE_FLAG is not null");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceFlagEqualTo(Integer value) {
            addCriterion("BILL_INVOICE_FLAG =", value, "billInvoiceFlag");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceFlagNotEqualTo(Integer value) {
            addCriterion("BILL_INVOICE_FLAG <>", value, "billInvoiceFlag");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceFlagGreaterThan(Integer value) {
            addCriterion("BILL_INVOICE_FLAG >", value, "billInvoiceFlag");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceFlagGreaterThanOrEqualTo(Integer value) {
            addCriterion("BILL_INVOICE_FLAG >=", value, "billInvoiceFlag");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceFlagLessThan(Integer value) {
            addCriterion("BILL_INVOICE_FLAG <", value, "billInvoiceFlag");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceFlagLessThanOrEqualTo(Integer value) {
            addCriterion("BILL_INVOICE_FLAG <=", value, "billInvoiceFlag");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceFlagIn(List<Integer> values) {
            addCriterion("BILL_INVOICE_FLAG in", values, "billInvoiceFlag");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceFlagNotIn(List<Integer> values) {
            addCriterion("BILL_INVOICE_FLAG not in", values, "billInvoiceFlag");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceFlagBetween(Integer value1, Integer value2) {
            addCriterion("BILL_INVOICE_FLAG between", value1, value2, "billInvoiceFlag");
            return (Criteria) this;
        }

        public Criteria andBillInvoiceFlagNotBetween(Integer value1, Integer value2) {
            addCriterion("BILL_INVOICE_FLAG not between", value1, value2, "billInvoiceFlag");
            return (Criteria) this;
        }

        public Criteria andTaxCodeIsNull() {
            addCriterion("TAX_CODE is null");
            return (Criteria) this;
        }

        public Criteria andTaxCodeIsNotNull() {
            addCriterion("TAX_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andTaxCodeEqualTo(String value) {
            addCriterion("TAX_CODE =", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeNotEqualTo(String value) {
            addCriterion("TAX_CODE <>", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeGreaterThan(String value) {
            addCriterion("TAX_CODE >", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeGreaterThanOrEqualTo(String value) {
            addCriterion("TAX_CODE >=", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeLessThan(String value) {
            addCriterion("TAX_CODE <", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeLessThanOrEqualTo(String value) {
            addCriterion("TAX_CODE <=", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeLike(String value) {
            addCriterion("TAX_CODE like", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeNotLike(String value) {
            addCriterion("TAX_CODE not like", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeIn(List<String> values) {
            addCriterion("TAX_CODE in", values, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeNotIn(List<String> values) {
            addCriterion("TAX_CODE not in", values, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeBetween(String value1, String value2) {
            addCriterion("TAX_CODE between", value1, value2, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeNotBetween(String value1, String value2) {
            addCriterion("TAX_CODE not between", value1, value2, "taxCode");
            return (Criteria) this;
        }

        public Criteria andMaterialUnitIsNull() {
            addCriterion("MATERIAL_UNIT is null");
            return (Criteria) this;
        }

        public Criteria andMaterialUnitIsNotNull() {
            addCriterion("MATERIAL_UNIT is not null");
            return (Criteria) this;
        }

        public Criteria andMaterialUnitEqualTo(String value) {
            addCriterion("MATERIAL_UNIT =", value, "materialUnit");
            return (Criteria) this;
        }

        public Criteria andMaterialUnitNotEqualTo(String value) {
            addCriterion("MATERIAL_UNIT <>", value, "materialUnit");
            return (Criteria) this;
        }

        public Criteria andMaterialUnitGreaterThan(String value) {
            addCriterion("MATERIAL_UNIT >", value, "materialUnit");
            return (Criteria) this;
        }

        public Criteria andMaterialUnitGreaterThanOrEqualTo(String value) {
            addCriterion("MATERIAL_UNIT >=", value, "materialUnit");
            return (Criteria) this;
        }

        public Criteria andMaterialUnitLessThan(String value) {
            addCriterion("MATERIAL_UNIT <", value, "materialUnit");
            return (Criteria) this;
        }

        public Criteria andMaterialUnitLessThanOrEqualTo(String value) {
            addCriterion("MATERIAL_UNIT <=", value, "materialUnit");
            return (Criteria) this;
        }

        public Criteria andMaterialUnitLike(String value) {
            addCriterion("MATERIAL_UNIT like", value, "materialUnit");
            return (Criteria) this;
        }

        public Criteria andMaterialUnitNotLike(String value) {
            addCriterion("MATERIAL_UNIT not like", value, "materialUnit");
            return (Criteria) this;
        }

        public Criteria andMaterialUnitIn(List<String> values) {
            addCriterion("MATERIAL_UNIT in", values, "materialUnit");
            return (Criteria) this;
        }

        public Criteria andMaterialUnitNotIn(List<String> values) {
            addCriterion("MATERIAL_UNIT not in", values, "materialUnit");
            return (Criteria) this;
        }

        public Criteria andMaterialUnitBetween(String value1, String value2) {
            addCriterion("MATERIAL_UNIT between", value1, value2, "materialUnit");
            return (Criteria) this;
        }

        public Criteria andMaterialUnitNotBetween(String value1, String value2) {
            addCriterion("MATERIAL_UNIT not between", value1, value2, "materialUnit");
            return (Criteria) this;
        }

        public Criteria andIsRebateIsNull() {
            addCriterion("IS_REBATE is null");
            return (Criteria) this;
        }

        public Criteria andIsRebateIsNotNull() {
            addCriterion("IS_REBATE is not null");
            return (Criteria) this;
        }

        public Criteria andIsRebateEqualTo(Integer value) {
            addCriterion("IS_REBATE =", value, "isRebate");
            return (Criteria) this;
        }

        public Criteria andIsRebateNotEqualTo(Integer value) {
            addCriterion("IS_REBATE <>", value, "isRebate");
            return (Criteria) this;
        }

        public Criteria andIsRebateGreaterThan(Integer value) {
            addCriterion("IS_REBATE >", value, "isRebate");
            return (Criteria) this;
        }

        public Criteria andIsRebateGreaterThanOrEqualTo(Integer value) {
            addCriterion("IS_REBATE >=", value, "isRebate");
            return (Criteria) this;
        }

        public Criteria andIsRebateLessThan(Integer value) {
            addCriterion("IS_REBATE <", value, "isRebate");
            return (Criteria) this;
        }

        public Criteria andIsRebateLessThanOrEqualTo(Integer value) {
            addCriterion("IS_REBATE <=", value, "isRebate");
            return (Criteria) this;
        }

        public Criteria andIsRebateIn(List<Integer> values) {
            addCriterion("IS_REBATE in", values, "isRebate");
            return (Criteria) this;
        }

        public Criteria andIsRebateNotIn(List<Integer> values) {
            addCriterion("IS_REBATE not in", values, "isRebate");
            return (Criteria) this;
        }

        public Criteria andIsRebateBetween(Integer value1, Integer value2) {
            addCriterion("IS_REBATE between", value1, value2, "isRebate");
            return (Criteria) this;
        }

        public Criteria andIsRebateNotBetween(Integer value1, Integer value2) {
            addCriterion("IS_REBATE not between", value1, value2, "isRebate");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountIsNull() {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountIsNotNull() {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountEqualTo(BigDecimal value) {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT =", value, "rebateNotIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountNotEqualTo(BigDecimal value) {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT <>", value, "rebateNotIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountGreaterThan(BigDecimal value) {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT >", value, "rebateNotIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT >=", value, "rebateNotIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountLessThan(BigDecimal value) {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT <", value, "rebateNotIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT <=", value, "rebateNotIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountIn(List<BigDecimal> values) {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT in", values, "rebateNotIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountNotIn(List<BigDecimal> values) {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT not in", values, "rebateNotIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT between", value1, value2, "rebateNotIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT not between", value1, value2, "rebateNotIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountIsNull() {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountIsNotNull() {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountEqualTo(BigDecimal value) {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT =", value, "rebateIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountNotEqualTo(BigDecimal value) {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT <>", value, "rebateIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountGreaterThan(BigDecimal value) {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT >", value, "rebateIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT >=", value, "rebateIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountLessThan(BigDecimal value) {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT <", value, "rebateIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT <=", value, "rebateIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountIn(List<BigDecimal> values) {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT in", values, "rebateIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountNotIn(List<BigDecimal> values) {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT not in", values, "rebateIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT between", value1, value2, "rebateIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT not between", value1, value2, "rebateIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountIsNull() {
            addCriterion("REBATE_TAX_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountIsNotNull() {
            addCriterion("REBATE_TAX_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountEqualTo(BigDecimal value) {
            addCriterion("REBATE_TAX_AMOUNT =", value, "rebateTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountNotEqualTo(BigDecimal value) {
            addCriterion("REBATE_TAX_AMOUNT <>", value, "rebateTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountGreaterThan(BigDecimal value) {
            addCriterion("REBATE_TAX_AMOUNT >", value, "rebateTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("REBATE_TAX_AMOUNT >=", value, "rebateTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountLessThan(BigDecimal value) {
            addCriterion("REBATE_TAX_AMOUNT <", value, "rebateTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("REBATE_TAX_AMOUNT <=", value, "rebateTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountIn(List<BigDecimal> values) {
            addCriterion("REBATE_TAX_AMOUNT in", values, "rebateTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountNotIn(List<BigDecimal> values) {
            addCriterion("REBATE_TAX_AMOUNT not in", values, "rebateTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("REBATE_TAX_AMOUNT between", value1, value2, "rebateTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("REBATE_TAX_AMOUNT not between", value1, value2, "rebateTaxAmount");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignIsNull() {
            addCriterion("BILL_TYPE_SIGN is null");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignIsNotNull() {
            addCriterion("BILL_TYPE_SIGN is not null");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignEqualTo(String value) {
            addCriterion("BILL_TYPE_SIGN =", value, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignNotEqualTo(String value) {
            addCriterion("BILL_TYPE_SIGN <>", value, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignGreaterThan(String value) {
            addCriterion("BILL_TYPE_SIGN >", value, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignGreaterThanOrEqualTo(String value) {
            addCriterion("BILL_TYPE_SIGN >=", value, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignLessThan(String value) {
            addCriterion("BILL_TYPE_SIGN <", value, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignLessThanOrEqualTo(String value) {
            addCriterion("BILL_TYPE_SIGN <=", value, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignLike(String value) {
            addCriterion("BILL_TYPE_SIGN like", value, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignNotLike(String value) {
            addCriterion("BILL_TYPE_SIGN not like", value, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignIn(List<String> values) {
            addCriterion("BILL_TYPE_SIGN in", values, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignNotIn(List<String> values) {
            addCriterion("BILL_TYPE_SIGN not in", values, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignBetween(String value1, String value2) {
            addCriterion("BILL_TYPE_SIGN between", value1, value2, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignNotBetween(String value1, String value2) {
            addCriterion("BILL_TYPE_SIGN not between", value1, value2, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("CREATE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("CREATE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("CREATE_TIME =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("CREATE_TIME <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("CREATE_TIME >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("CREATE_TIME <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("CREATE_TIME in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("CREATE_TIME not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIsNull() {
            addCriterion("UPDATE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIsNotNull() {
            addCriterion("UPDATE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeEqualTo(Date value) {
            addCriterion("UPDATE_TIME =", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotEqualTo(Date value) {
            addCriterion("UPDATE_TIME <>", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeGreaterThan(Date value) {
            addCriterion("UPDATE_TIME >", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("UPDATE_TIME >=", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeLessThan(Date value) {
            addCriterion("UPDATE_TIME <", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeLessThanOrEqualTo(Date value) {
            addCriterion("UPDATE_TIME <=", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIn(List<Date> values) {
            addCriterion("UPDATE_TIME in", values, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotIn(List<Date> values) {
            addCriterion("UPDATE_TIME not in", values, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeBetween(Date value1, Date value2) {
            addCriterion("UPDATE_TIME between", value1, value2, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotBetween(Date value1, Date value2) {
            addCriterion("UPDATE_TIME not between", value1, value2, "updateTime");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoIsNull() {
            addCriterion("INVOICE_NO is null");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoIsNotNull() {
            addCriterion("INVOICE_NO is not null");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoEqualTo(String value) {
            addCriterion("INVOICE_NO =", value, "InvoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoNotEqualTo(String value) {
            addCriterion("INVOICE_NO <>", value, "InvoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoGreaterThan(String value) {
            addCriterion("INVOICE_NO >", value, "InvoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoGreaterThanOrEqualTo(String value) {
            addCriterion("INVOICE_NO >=", value, "InvoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoLessThan(String value) {
            addCriterion("INVOICE_NO <", value, "InvoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoLessThanOrEqualTo(String value) {
            addCriterion("INVOICE_NO <=", value, "InvoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoLike(String value) {
            addCriterion("INVOICE_NO like", value, "InvoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoNotLike(String value) {
            addCriterion("INVOICE_NO not like", value, "InvoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoIn(List<String> values) {
            addCriterion("INVOICE_NO in", values, "InvoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoNotIn(List<String> values) {
            addCriterion("INVOICE_NO not in", values, "InvoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoBetween(String value1, String value2) {
            addCriterion("INVOICE_NO between", value1, value2, "InvoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoNotBetween(String value1, String value2) {
            addCriterion("INVOICE_NO not between", value1, value2, "InvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoIsNull() {
            addCriterion("SAP_INVOICE_NO is null");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoIsNotNull() {
            addCriterion("SAP_INVOICE_NO is not null");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoEqualTo(String value) {
            addCriterion("SAP_INVOICE_NO =", value, "SapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoNotEqualTo(String value) {
            addCriterion("SAP_INVOICE_NO <>", value, "SapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoGreaterThan(String value) {
            addCriterion("SAP_INVOICE_NO >", value, "SapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoGreaterThanOrEqualTo(String value) {
            addCriterion("SAP_INVOICE_NO >=", value, "SapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoLessThan(String value) {
            addCriterion("SAP_INVOICE_NO <", value, "SapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoLessThanOrEqualTo(String value) {
            addCriterion("SAP_INVOICE_NO <=", value, "SapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoLike(String value) {
            addCriterion("SAP_INVOICE_NO like", value, "SapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoNotLike(String value) {
            addCriterion("SAP_INVOICE_NO not like", value, "SapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoIn(List<String> values) {
            addCriterion("SAP_INVOICE_NO in", values, "SapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoNotIn(List<String> values) {
            addCriterion("SAP_INVOICE_NO not in", values, "SapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoBetween(String value1, String value2) {
            addCriterion("SAP_INVOICE_NO between", value1, value2, "SapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoNotBetween(String value1, String value2) {
            addCriterion("SAP_INVOICE_NO not between", value1, value2, "SapInvoiceNo");
            return (Criteria) this;
        }
        public Criteria andProjectIdIsNull() {
            addCriterion("PROJECT_ID is null");
            return (Criteria) this;
        }

        public Criteria andProjectIdIsNotNull() {
            addCriterion("PROJECT_ID is not null");
            return (Criteria) this;
        }

        public Criteria andProjectIdEqualTo(String value) {
            addCriterion("PROJECT_ID =", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotEqualTo(String value) {
            addCriterion("PROJECT_ID <>", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdGreaterThan(String value) {
            addCriterion("PROJECT_ID >", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdGreaterThanOrEqualTo(String value) {
            addCriterion("PROJECT_ID >=", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdLessThan(String value) {
            addCriterion("PROJECT_ID <", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdLessThanOrEqualTo(String value) {
            addCriterion("PROJECT_ID <=", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdLike(String value) {
            addCriterion("PROJECT_ID like", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotLike(String value) {
            addCriterion("PROJECT_ID not like", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdIn(List<String> values) {
            addCriterion("PROJECT_ID in", values, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotIn(List<String> values) {
            addCriterion("PROJECT_ID not in", values, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdBetween(String value1, String value2) {
            addCriterion("PROJECT_ID between", value1, value2, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotBetween(String value1, String value2) {
            addCriterion("PROJECT_ID not between", value1, value2, "projectId");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagIsNull() {
            addCriterion("INVOICE_SIGN_FLAG is null");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagIsNotNull() {
            addCriterion("INVOICE_SIGN_FLAG is not null");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagEqualTo(Integer value) {
            addCriterion("INVOICE_SIGN_FLAG =", value, "invoiceSignFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagNotEqualTo(Integer value) {
            addCriterion("INVOICE_SIGN_FLAG <>", value, "invoiceSignFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagGreaterThan(Integer value) {
            addCriterion("INVOICE_SIGN_FLAG >", value, "invoiceSignFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagGreaterThanOrEqualTo(Integer value) {
            addCriterion("INVOICE_SIGN_FLAG >=", value, "invoiceSignFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagLessThan(Integer value) {
            addCriterion("INVOICE_SIGN_FLAG <", value, "invoiceSignFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagLessThanOrEqualTo(Integer value) {
            addCriterion("INVOICE_SIGN_FLAG <=", value, "invoiceSignFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagIn(List<Integer> values) {
            addCriterion("INVOICE_SIGN_FLAG in", values, "invoiceSignFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagNotIn(List<Integer> values) {
            addCriterion("INVOICE_SIGN_FLAG not in", values, "invoiceSignFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagBetween(Integer value1, Integer value2) {
            addCriterion("INVOICE_SIGN_FLAG between", value1, value2, "invoiceSignFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagNotBetween(Integer value1, Integer value2) {
            addCriterion("INVOICE_SIGN_FLAG not between", value1, value2, "invoiceSignFlag");
            return (Criteria) this;
        }
    }

    public static class Criteria extends GeneratedCriteria implements Serializable {
        private static final long serialVersionUID = 1L;

        protected Criteria() {
            super();
        }
    }

    public static class Criterion implements Serializable {
        private String condition;

        private Object value;

        private Object secondValue;

        private boolean noValue;

        private boolean singleValue;

        private boolean betweenValue;

        private boolean listValue;

        private String typeHandler;

        private static final long serialVersionUID = 1L;

        public String getCondition() {
            return condition;
        }

        public Object getValue() {
            return value;
        }

        public Object getSecondValue() {
            return secondValue;
        }

        public boolean isNoValue() {
            return noValue;
        }

        public boolean isSingleValue() {
            return singleValue;
        }

        public boolean isBetweenValue() {
            return betweenValue;
        }

        public boolean isListValue() {
            return listValue;
        }

        public String getTypeHandler() {
            return typeHandler;
        }

        protected Criterion(String condition) {
            super();
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
        }

        protected Criterion(String condition, Object value, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            if (value instanceof List<?>) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
        }

        protected Criterion(String condition, Object value) {
            this(condition, value, null);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
        }

        protected Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null);
        }
    }
}