package com.els.base.bill.service;

import com.els.base.auth.entity.User;
import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.entity.BillItemExample;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.core.service.BaseService;

import java.util.List;

public interface BillService extends BaseService<Bill, BillExample, String> {
    void  deleteByExample(BillExample example);

    int countByExample(BillExample example);

    int updateByExampleSelective(Bill record, BillExample example);

    /**
     * 预览数据的校验
     */
    void prepareFilter(Bill bill);

    /**
     * 创建开票清单的限制
     */
    void createBillFilter(Bill bill);

    /**
     * 根据对账单更新sap同步状态
     */
    int updateSendSapFlag(List<Bill> billList, Integer flag);

    void updateVoucherByBillIds(List<String> ids, int billFlag);
}