package com.els.base.bill.service.impl;

import com.els.base.bill.dao.BillItemMapper;
import com.els.base.bill.entity.BillItem;
import com.els.base.bill.entity.BillItemExample;
import com.els.base.bill.entity.BillItemReport;
import com.els.base.bill.entity.BillItemReportExample;
import com.els.base.bill.service.BillItemService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

@Service("defaultBillItemService")
public class BillItemServiceImpl implements BillItemService {
    @Resource
    protected BillItemMapper billItemMapper;

    @Transactional
    @CacheEvict(value={"billItem"}, allEntries=true)
    @Override
    public int updateByExampleSelective(BillItem record, BillItemExample example) {
        return this.billItemMapper.updateByExampleSelective(record,example);
    }

    @Transactional
    @CacheEvict(value={"billItem"}, allEntries=true)
    @Override
    public int insertBatch(List<BillItem> list) {
        Assert.isNotEmpty(list,"开票清单行不能为空！");
        return this.billItemMapper.insertBatch(list);
    }

    @Cacheable(value="billItem", keyGenerator="redisKeyGenerator")
    @Override
    public int countByExample(BillItemExample example) {
        return this.billItemMapper.countByExample(example);
    }

    @CacheEvict(value={"billItem"}, allEntries=true)
    @Override
    public void addObj(BillItem t) {
        this.billItemMapper.insertSelective(t);
    }

    @CacheEvict(value={"billItem"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.billItemMapper.deleteByPrimaryKey(id);
    }


    @CacheEvict(value={"billItem"}, allEntries=true)
    @Override
    public void modifyObj(BillItem t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.billItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="billItem", keyGenerator="redisKeyGenerator")
    @Override
    public BillItem queryObjById(String id) {
        return this.billItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="billItem", keyGenerator="redisKeyGenerator")
    @Override
    public List<BillItem> queryAllObjByExample(BillItemExample example) {
        return this.billItemMapper.selectByExample(example);
    }

    @Cacheable(value="billItem", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<BillItem> queryObjByPage(BillItemExample example) {
        PageView<BillItem> pageView = example.getPageView();
        pageView.setQueryResult(this.billItemMapper.selectByExampleByPage(example));
        return pageView;
    }
    @Cacheable(value="billItem", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<BillItemReport> queryBillItemReportByPage(BillItemReportExample example) {
        PageView<BillItemReport> pageView = example.getPageView();
        pageView.setQueryResult(this.billItemMapper.selectBillItemReportByPage(example));
        return pageView;
    }
    @Cacheable(value="billItem", keyGenerator="redisKeyGenerator")
    @Override
    public List<BillItemReport> queryBillItemReportForExcel(BillItemReportExample example) {
        return this.billItemMapper.selectBillItemReportForExcel(example);
    }
}