package com.els.base.bill.utils;

/**
 * @author liuhongfeng
 * 移动类型对应的符号
 */

public enum BillTypeSignEnum {

    /**
     * 收货
     */
    RECEIVE_GOODS("101","+"),

    /**
     * 取消
     */
    RECEIVE_GOODS_CANCEL("102","-"),

    /**
     * 采购退货是检验后不合格 在入库前退货；
     */
    PURCHASE_RETURN_GOODS("122","-"),

    RETURN_GOODS_CANCEL("123","+"),

    /**
     * 退货是入库后异常退货。
     */
    RETURN_GOODS("161","-"),

    CANCEL_GOODS_CANCEL("162","+");

    private  String code;
    private  String signNum;

    BillTypeSignEnum(String code, String signNum) {
        this.code = code;
        this.signNum = signNum;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getSignNum() {
        return signNum;
    }

    public void setSignNum(String signNum) {
        this.signNum = signNum;
    }
}
