package com.els.base.bill.utils;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillItem;
import com.els.base.billswitch.entity.BillSwitch;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.voucher.entity.BillVoucher;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * 补充供应商信息小工具
 *
 * @author liuhf
 */
public class BillUtil {

    private static Logger logger = LoggerFactory.getLogger(BillUtil.class);

    /**
     * 设置采购方信息
     *
     * @param project
     * @param bill
     * @param companyService
     */
    public static Bill setPurCompanyInfo(Project project, Bill bill, CompanyService companyService) {
        Company purCompany = companyService.queryObjById(project.getCompanyId());
        Assert.isNotNull(purCompany, "采购基本信息不能为空！");
        bill.setPurCompanyId(purCompany.getId());
        bill.setPurCompanySrmCode(purCompany.getCompanyCode());
        bill.setPurCompanySapCode(purCompany.getCompanySapCode());
        bill.setPurCompanyName(purCompany.getCompanyName());
        bill.setPurCompanyFullName(purCompany.getCompanyFullName());
        return bill;
    }

    /**
     * 获取供应商主数据信息并设置
     *
     * @param supCompanySapCode
     * @param bill
     */
    public static Bill setSupCompanyInfo(String supCompanySapCode, Bill bill, CompanyService companyService) {
        //根据供应商基本信息查询
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanySapCodeEqualTo(supCompanySapCode);
        List<Company> companies = companyService.queryAllObjByExample(companyExample);
        Assert.isNotEmpty(companies, "供应商不存在，请在主数据维护，谢谢！");
        Company supCompany = companies.get(0);
        Assert.isNotNull(supCompany, "供应商不存在！");

        bill.setSupCompanyId(supCompany.getId());
        //供应商SRM编码
        bill.setSupCompanySrmCode(supCompany.getCompanyCode());
        bill.setSupCompanySapCode(supCompanySapCode);
        //供应商名称
        bill.setSupCompanyName(supCompany.getCompanyName());
        bill.setSupCompanyFullName(supCompany.getCompanyFullName());
        //联系电话
        bill.setSupComtactTelephone(supCompany.getTelephone());
        //联系人
        bill.setSupComtactUserName(supCompany.getContacts());
        //供应商地址
        bill.setSupCompanyAddress(supCompany.getAddress());

        //付款条件以及描述
        bill.setPayConditionsCode(supCompany.getPayConditionsCode());
        bill.setPayConditionsDesc(supCompany.getPayConditionsDesc());

        //税率
        bill.setTaxRate(supCompany.getTaxRate());
        bill.setTaxCode(supCompany.getTaxCode());

        bill.setCurrencyType(supCompany.getOrderCurren());

        return bill;
    }

    public static List<List<BillItem>> setBillItems(Bill bill, List<BillVoucher> billVoucherList) {
        List<BillItem> billItems = new ArrayList<>();
        for (BillVoucher billVoucher : billVoucherList) {
            BillItem billItem = new BillItem();
            BeanUtils.copyProperties(billVoucher, billItem);
            billItem.setId(UUIDGenerator.generateUUID());
            billItem.setBillId(bill.getId());
            billItem.setBillNo(bill.getBillNo());
            billItem.setIsEnable(Constant.YES_INT);
            billItem.setVoucherId(billVoucher.getId());
            billItem.setBillFlag(Constant.YES_INT);
            billItem.setBillInvoiceFlag(Constant.NO_INT);
            billItems.add(billItem);
        }
        List<List<BillItem>> group = Lists.partition(billItems, 10);
        return group;
    }


    /**
     * 根据凭证验证是否在开票时间内
     *
     * @param billSwitches
     * @param postingTime
     */
    public static void checkBillTime(List<BillSwitch> billSwitches, Date postingTime) {
        if (CollectionUtils.isNotEmpty(billSwitches)) {
            for (BillSwitch billSwitch : billSwitches) {

                Integer startTime = billSwitch.getStartTime();
                Integer endTime = billSwitch.getEndTime();

                logger.info("采购员设置的开票开始时间为：{}", startTime);
                logger.info("采购员设置的开票结束时间为：{}", endTime);

                //开始和结束日期  1号 - 31 号
                Calendar calendar = Calendar.getInstance();
                int date = calendar.get(Calendar.DATE);
                logger.info("系统当前天数为：{}", date);

                if (startTime != null & startTime != null) {
                    //如果在开票范围内，则放行
                    if (date >= startTime && date <= endTime) {

                    } else {
                        throw new CommonException("不在对账时间内,请联系采购员设置对账时间，谢谢！");
                    }
                }

                //凭证开始时间
                Date voucherStartTime = billSwitch.getVoucherStartTime();
                //凭证结束时间
                Date voucherEndTime = billSwitch.getVoucherEndTime();

                //第三种情况：维护开始时间和结束时间
                if (voucherStartTime != null && voucherEndTime != null) {

                    String str = DateFormatUtils.format(voucherStartTime, "yyyy-MM-dd");
                    String str2 = DateFormatUtils.format(voucherEndTime, "yyyy-MM-dd");
                    logger.info("采购设置的凭证开始日：{}", str);
                    logger.info("采购设置的凭证结束日：{}", str2);
                    Date voucherStartTime1 = DateUtils.truncate(voucherStartTime, Calendar.DATE);
                    Date voucherEndTime1 = DateUtils.truncate(voucherEndTime, Calendar.DATE);

                    //只比较日期
                    Assert.isNotNull(postingTime, "凭证日期不能为空！");
                    Date postingTime1 = DateUtils.truncate(postingTime, Calendar.DATE);

                    //凭证的选择时间是否在限制的范围内
                    boolean b = postingTime1.getTime() >= voucherStartTime1.getTime();
                    boolean b1 = postingTime1.getTime() <= voucherEndTime1.getTime();
                    if (b && b1) {
                        //符合业务
                    } else {
                        throw new CommonException("你所选的对账凭证时间不在时间规定范围内,允许时间为：" + str + "到" + str2);
                    }
                }
            }
        }
    }
}
