package com.els.base.bill.utils;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillItem;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.invoice.entity.BillInvoice;
import com.els.base.voucher.entity.BillVoucher;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author liuhf
 */
public class CalculateBillUtil {

    /**
     * 计算开票清单汇总数据
     * @param bill
     * @param billVoucherList
     * @return
     */
    public static Bill calculateAmount(Bill bill, List<BillVoucher> billVoucherList) {

        BigDecimal notIncludeTaxAmount=BigDecimal.ZERO;
        BigDecimal includeTaxAmount=BigDecimal.ZERO;
        BigDecimal taxAmount=BigDecimal.ZERO;

        BigDecimal rebateNotIncludeTaxAmount=BigDecimal.ZERO;
        BigDecimal rebateIncludeTaxAmount=BigDecimal.ZERO;
        BigDecimal rebateTaxAmount=BigDecimal.ZERO;

        for (BillVoucher billVoucher : billVoucherList) {

            Assert.isNotNull(billVoucher,"入退库凭证不能为空！");
            Assert.isNotNull(billVoucher.getNotIncludeTaxAmount(),"开票不含税金额不能为空！");
            Assert.isNotNull(billVoucher.getIncludeTaxAmount(),"开票含税金额不能为空！");
            Assert.isNotNull(billVoucher.getTaxAmount(),"开票税额不能为空！");
            Assert.isNotBlank(billVoucher.getBillType(),"移动类型不能为空！");

            String billType=billVoucher.getBillType();

            //行的开票未税金额=101 行开票未税金额 - 102 行开票未税金额- 122 行开票未税金额 + 123行开票未税金额 -161行 开票未税金额+ 162 行开票未税金额
            //行开票含税金额=101 行开票含税金额 - 102 行开票含税金额- 122 行开票含税金额 + 123行开票含税金额 -161行 开票未税金额+ 162 行开票含税金额
            //行总开票税额 =101 行开票税额 - 102 行开票税额 - 122 行开票税额 + 123 行开票税额 -161行 行开票税额 + 162 行开票税额

            switch (billType){
                case "101" :
                    notIncludeTaxAmount=notIncludeTaxAmount.add(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount=includeTaxAmount.add(billVoucher.getIncludeTaxAmount());
                    taxAmount=taxAmount.add(billVoucher.getTaxAmount());
                    break;
                case "102" :
                    notIncludeTaxAmount=notIncludeTaxAmount.subtract(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount=includeTaxAmount.subtract(billVoucher.getIncludeTaxAmount());
                    taxAmount=taxAmount.subtract(billVoucher.getTaxAmount());
                    break;
                case "122" :
                    notIncludeTaxAmount=notIncludeTaxAmount.subtract(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount=includeTaxAmount.subtract(billVoucher.getIncludeTaxAmount());
                    taxAmount=taxAmount.subtract(billVoucher.getTaxAmount());
                    break;
                case "123" :
                    notIncludeTaxAmount=notIncludeTaxAmount.add(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount=includeTaxAmount.add(billVoucher.getIncludeTaxAmount());
                    taxAmount=taxAmount.add(billVoucher.getTaxAmount());
                    break;
                case "161" :
                    notIncludeTaxAmount=notIncludeTaxAmount.subtract(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount=includeTaxAmount.subtract(billVoucher.getIncludeTaxAmount());
                    taxAmount=taxAmount.subtract(billVoucher.getTaxAmount());
                    break;
                case "162" :
                    notIncludeTaxAmount=notIncludeTaxAmount.add(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount=includeTaxAmount.add(billVoucher.getIncludeTaxAmount());
                    taxAmount=taxAmount.add(billVoucher.getTaxAmount());
                    break;
                default:
                        break;
            }

            //折让数据统计-//折让金额不管移动类型是什么，都汇总起来
            if(billVoucher.getIsRebate()!=null&&billVoucher.getIsRebate().equals(Constant.YES_INT)){

                BigDecimal rebateNotIncludeTaxAmount1 = billVoucher.getRebateNotIncludeTaxAmount();
                if(rebateNotIncludeTaxAmount1==null){
                    rebateNotIncludeTaxAmount1=BigDecimal.ZERO;
                }
                rebateNotIncludeTaxAmount=rebateNotIncludeTaxAmount.add(rebateNotIncludeTaxAmount1) ;

                BigDecimal rebateIncludeTaxAmount1 = billVoucher.getRebateIncludeTaxAmount();
                if(rebateIncludeTaxAmount1==null){
                    rebateIncludeTaxAmount1=BigDecimal.ZERO;
                }
                rebateIncludeTaxAmount=rebateIncludeTaxAmount.add(rebateIncludeTaxAmount1);

                BigDecimal rebateTaxAmount1 = billVoucher.getRebateTaxAmount();
                if(rebateTaxAmount1==null){
                    rebateTaxAmount1=BigDecimal.ZERO;
                }
                rebateTaxAmount=rebateTaxAmount.add(rebateTaxAmount1);
            }
        }

        //凭证金额信息
        bill.setIncludeTaxAmount(includeTaxAmount);
        bill.setNotIncludeTaxAmount(notIncludeTaxAmount);
        bill.setTaxAmount(taxAmount);

        //折让金额信息
        bill.setRebateIncludeTaxAmount(rebateIncludeTaxAmount);
        bill.setRebateNotIncludeTaxAmount(rebateNotIncludeTaxAmount);
        bill.setRebateTaxAmount(rebateTaxAmount);

        //扣款总金额=折让含税金额+扣款金额
        BigDecimal deductionAmount=rebateIncludeTaxAmount;
        bill.setDeductionAmount(deductionAmount);

        //对账单含税总金额= 开票含税金额 - 扣款含税总金额  --> 现在直接取开票含税金额
        bill.setTotalAmount(includeTaxAmount);

        return bill;
    }


    /**
     * 计算发票金额信息
     * @param billInvoice
     * @param billItemList
     */
    public static void calculateInvoiceAmount(BillInvoice billInvoice, List<BillItem> billItemList) {

        BigDecimal notIncludeTaxAmount=BigDecimal.ZERO;
        BigDecimal includeTaxAmount=BigDecimal.ZERO;
        BigDecimal taxAmount=BigDecimal.ZERO;

        BigDecimal rebateNotIncludeTaxAmount=BigDecimal.ZERO;
        BigDecimal rebateIncludeTaxAmount=BigDecimal.ZERO;
        BigDecimal rebateTaxAmount=BigDecimal.ZERO;

        for (BillItem billVoucher : billItemList) {

            Assert.isNotNull(billVoucher,"入退库凭证不能为空！");
            Assert.isNotNull(billVoucher.getNotIncludeTaxAmount(),"开票不含税金额不能为空！");
            Assert.isNotNull(billVoucher.getIncludeTaxAmount(),"开票含税金额不能为空！");
            Assert.isNotNull(billVoucher.getTaxAmount(),"开票税额不能为空！");
            Assert.isNotBlank(billVoucher.getBillType(),"移动类型不能为空！");

            String billType=billVoucher.getBillType();

            //行的开票未税金额=101 行开票未税金额 - 102 行开票未税金额- 122 行开票未税金额 + 123行开票未税金额 -161行 开票未税金额+ 162 行开票未税金额
            //行开票含税金额=101 行开票含税金额 - 102 行开票含税金额- 122 行开票含税金额 + 123行开票含税金额 -161行 开票未税金额+ 162 行开票含税金额
            //行总开票税额 =101 行开票税额 - 102 行开票税额 - 122 行开票税额 + 123 行开票税额 -161行 行开票税额 + 162 行开票税额

            switch (billType){
                case "101" :
                    notIncludeTaxAmount=notIncludeTaxAmount.add(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount=includeTaxAmount.add(billVoucher.getIncludeTaxAmount());
                    taxAmount=taxAmount.add(billVoucher.getTaxAmount());
                    break;
                case "102" :
                    notIncludeTaxAmount=notIncludeTaxAmount.subtract(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount=includeTaxAmount.subtract(billVoucher.getIncludeTaxAmount());
                    taxAmount=taxAmount.subtract(billVoucher.getTaxAmount());
                    break;
                case "122" :
                    notIncludeTaxAmount=notIncludeTaxAmount.subtract(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount=includeTaxAmount.subtract(billVoucher.getIncludeTaxAmount());
                    taxAmount=taxAmount.subtract(billVoucher.getTaxAmount());
                    break;
                case "123" :
                    notIncludeTaxAmount=notIncludeTaxAmount.add(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount=includeTaxAmount.add(billVoucher.getIncludeTaxAmount());
                    taxAmount=taxAmount.add(billVoucher.getTaxAmount());
                    break;
                case "161" :
                    notIncludeTaxAmount=notIncludeTaxAmount.subtract(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount=includeTaxAmount.subtract(billVoucher.getIncludeTaxAmount());
                    taxAmount=taxAmount.subtract(billVoucher.getTaxAmount());
                    break;
                case "162" :
                    notIncludeTaxAmount=notIncludeTaxAmount.add(billVoucher.getNotIncludeTaxAmount());
                    includeTaxAmount=includeTaxAmount.add(billVoucher.getIncludeTaxAmount());
                    taxAmount=taxAmount.add(billVoucher.getTaxAmount());
                    break;
                default:

                    break;
            }

            //折让数据统计-//折让金额不管移动类型是什么，都汇总起来
            if(billVoucher.getIsRebate()!=null&&billVoucher.getIsRebate().equals(Constant.YES_INT)){

                BigDecimal rebateNotIncludeTaxAmount1 = billVoucher.getRebateNotIncludeTaxAmount();
                if(rebateNotIncludeTaxAmount1==null){
                    rebateNotIncludeTaxAmount1=BigDecimal.ZERO;
                }
                rebateNotIncludeTaxAmount=rebateNotIncludeTaxAmount.add(rebateNotIncludeTaxAmount1) ;

                BigDecimal rebateIncludeTaxAmount1 = billVoucher.getRebateIncludeTaxAmount();
                if(rebateIncludeTaxAmount1==null){
                    rebateIncludeTaxAmount1=BigDecimal.ZERO;
                }
                rebateIncludeTaxAmount=rebateIncludeTaxAmount.add(rebateIncludeTaxAmount1);

                BigDecimal rebateTaxAmount1 = billVoucher.getRebateTaxAmount();
                if(rebateTaxAmount1==null){
                    rebateTaxAmount1=BigDecimal.ZERO;
                }
                rebateTaxAmount=rebateTaxAmount.add(rebateTaxAmount1);
            }
        }

        //凭证金额信息
        billInvoice.setIncludeTaxAmount(includeTaxAmount);
        billInvoice.setNotIncludeTaxAmount(notIncludeTaxAmount);
        billInvoice.setTaxAmount(taxAmount);

        //折让金额信息
        billInvoice.setRebateIncludeTaxAmount(rebateIncludeTaxAmount);
        billInvoice.setRebateNotIncludeTaxAmount(rebateNotIncludeTaxAmount);
        billInvoice.setRebateTaxAmount(rebateTaxAmount);

        //扣款总金额=折让含税金额+扣款金额
        BigDecimal deductionAmount=rebateIncludeTaxAmount;
        billInvoice.setDeductionAmount(deductionAmount);

        //对账单含税总金额= 开票含税金额 - 扣款含税总金额 --> 现在直接取开票含税金额
        billInvoice.setTotalAmount(includeTaxAmount);

    }
}
