package com.els.base.bill.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author liuhf
 */
@Data
public class BillExportExcelVo {

    @Excel(name = "对账清单号")
    private String billNo;

    @Excel(name = "采购商公司全称")
    private String purCompanyFullName;

    @Excel(name = "采购员制单人用户名称")
    private String purUserName;

    @Excel(name = "采购员备注")
    private String purRemark;

    @Excel(name = "供应商公司全称")
    private String supCompanyFullName;

    @Excel(name = "供应商公司SRM编码")
    private String supCompanySrmCode;

    @Excel(name = "供应商公司SAP编码")
    private String supCompanySapCode;

    @Excel(name = "供应商地址")
    private String supCompanyAddress;

    @Excel(name = "供应商制单人用户名称")
    private String supUserName;

    @Excel(name = "供应商联系人")
    private String supComtactUserName;

    @Excel(name = "供应商联系人电话")
    private String supComtactTelephone;

    @Excel(name = "供应商备注")
    private String supRemark;

    @Excel(name = "对账开票开始时间")
    private Integer startTime;

    @Excel(name = "对账开票结束时间")
    private Integer endTime;

    @Excel(name = "货币类型")
    private String currencyType;

    @Excel(name = "表创建时间")
    private Date createTime;

    @Excel(name = "表更新时间")
    private Date updateTime;

    @Excel(name = "付款条件code")
    private String payConditionsCode;

    @Excel(name = "付款条件描述")
    private String payConditionsDesc;

    @Excel(name = "税码")
    private String taxCode;

    @Excel(name = "税率")
    private BigDecimal taxRate;

    @Excel(name = "净价")
    private BigDecimal netPrice;

    @Excel(name = "开票含税税额")
    private BigDecimal includeTaxAmount;

    @Excel(name = "开票未税金额")
    private BigDecimal notIncludeTaxAmount;

    @Excel(name = "开票税额")
    private BigDecimal taxAmount;

    @Excel(name = "对账总金额")
    private BigDecimal totalAmount;

    @Excel(name = "扣款总金额")
    private BigDecimal deductionAmount;

    @Excel(name="是否折让",replace = { "是_1", "否_0" })
    private Integer isRebate;

    @Excel(name="折让不含税金额")
    private BigDecimal rebateNotIncludeTaxAmount;

    @Excel(name="折让含税金额")
    private BigDecimal rebateIncludeTaxAmount;

    @Excel(name="折让税额")
    private BigDecimal rebateTaxAmount;

    @Excel(name="移动类型对应的符号")
    private String billTypeSign;

    @Excel(name = "凭证开始日期", format = "yyyy-MM-dd")
    private Date postingStartTime;

    @Excel(name = "凭证结束日期", format = "yyyy-MM-dd")
    private Date postingEndTime;

    @Excel(name = "创建方", replace = {"采购方_1", "供应商_2"})
    private Integer createBillType;

}
