package com.els.base.bill.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
@ExcelTarget("billItemReportExportExcelVo")
public class BillItemReportExportExcelVo implements Serializable {

    @Excel(width = 30, name = "采购商公司全称")
    private String purCompanyFullName;

    @Excel(width = 30, name = "供应商公司全称")
    private String supCompanyFullName;

    @Excel(width = 20, name = "供应商公司SAP编码")
    private String supCompanySapCode;

    @Excel(width = 20, name = "对账清单号")
    private String billNo;

    @Excel(width = 20, name = "采购单号")
    private String purchaseOrderNo;

    @Excel(width = 20, name = "采购单行号")
    private String purchaseOrderItemNo;

    @Excel(width = 30, name = "物料编码")
    private String materialNo;

    @Excel(width = 30, name = "物料描述")
    private String materialDesc;

    @Excel(width = 20, name = "物料数量")
    private BigDecimal materialQuantity;

    @Excel(width = 20, name = "物料凭证号")
    private String materialVoucherNo;

    @Excel(width = 20, name = "物料凭证行号")
    private String materialVoucherItemNo;

    @Excel(width = 20, name = "过账日期", format = "yyyy-MM-dd")
    private Date postingTime;

    @Excel(width = 20, name = "货币类型")
    private String currencyType;

    @Excel(width = 20, name = "工厂")
    private String factory;

    @Excel(width = 20, name = "项目类别")
    private String projectTypes;

    @Excel(width = 20, name = "移动类型")
    private String billType;

    @Excel(width = 20, name = "移动类型符号")
    private String billTypeSign;

    @Excel(width = 20, name = "税码")
    private String taxCode;

    @Excel(width = 20, name = "税率")
    private BigDecimal taxRate;

    @Excel(width = 20, name = "最新采购信息记录价格")
    private BigDecimal latestPrice;

    @Excel(width = 20, name = "单价")
    private BigDecimal orderPrice;

    @Excel(width = 20, name = "开票未税金额")
    private BigDecimal notIncludeTaxAmount;

    @Excel(width = 20, name = "开票含税金额")
    private BigDecimal includeTaxAmount;

    @Excel(width = 20, name = "开票税额")
    private BigDecimal taxAmount;

    @Excel(width = 20, name = "订单总金额")
    private BigDecimal orderAmount;

    @Excel(width = 20, name = "折让不含税金额")
    private BigDecimal rebateNotIncludeTaxAmount;

    @Excel(width = 20, name = "折让含税金额")
    private BigDecimal rebateIncludeTaxAmount;

    @Excel(width = 20, name = "折让税额")
    private BigDecimal rebateTaxAmount;

    @Excel(width = 20, name = "发票编码")
    private String invoiceNo;

    @Excel(width = 20, name = "SAP发票编码")
    private String sapInvoiceNo;
}
