package com.els.base.billswitch.controller;

import com.els.base.billswitch.entity.BillSwitch;
import com.els.base.billswitch.entity.BillSwitchExample;
import com.els.base.billswitch.service.BillSwitchService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="采购结算管理-开票清单对账开关")
@Controller
@RequestMapping("billSwitch")
public class BillSwitchController {

    @Resource
    protected BillSwitchService billSwitchService;

    @ApiOperation(httpMethod="POST", value="创建采购结算管理-开票清单对账开关")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BillSwitch billSwitch) {
        this.billSwitchService.addObj(billSwitch);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑采购结算管理-开票清单对账开关")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BillSwitch billSwitch) {
        Assert.isNotBlank(billSwitch.getId(), "id 为空，保存失败");
        this.billSwitchService.modifyObj(billSwitch);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除采购结算管理-开票清单对账开关")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.billSwitchService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询采购结算管理-开票清单对账开关")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 BillSwitch", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BillSwitch>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        BillSwitchExample example = new BillSwitchExample();
        example.setPageView(new PageView<BillSwitch>(pageNo, pageSize));
        BillSwitchExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
                .andPurCompanyIdEqualTo(ProjectUtils.getCompanyId())
                .andIsEnableEqualTo(Constant.YES_INT);

        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<BillSwitch> pageData = this.billSwitchService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}