package com.els.base.billswitch.service.impl;

import com.els.base.billswitch.dao.BillSwitchMapper;
import com.els.base.billswitch.entity.BillSwitch;
import com.els.base.billswitch.entity.BillSwitchExample;
import com.els.base.billswitch.service.BillSwitchService;
import com.els.base.core.entity.PageView;
import java.util.List;
import javax.annotation.Resource;

import com.els.base.core.utils.Assert;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultBillSwitchService")
public class BillSwitchServiceImpl implements BillSwitchService {
    @Resource
    protected BillSwitchMapper billSwitchMapper;

    @Cacheable(value="billSwitch", keyGenerator="redisKeyGenerator")
    @Override
    public int countByExample(BillSwitchExample example) {
        return this.billSwitchMapper.countByExample(example);
    }

    @CacheEvict(value={"billSwitch"}, allEntries=true)
    @Override
    public void deleteByExample(BillSwitchExample example) {
        Assert.isNotEmpty(example.getOredCriteria(),"不能进行全表删除，请检查！");
        this.billSwitchMapper.deleteByExample(example);
    }

    @CacheEvict(value={"billSwitch"}, allEntries=true)
    @Override
    public int updateByExampleSelective(BillSwitch billSwitch, BillSwitchExample billSwitchExample) {
        return this.billSwitchMapper.updateByExampleSelective(billSwitch,billSwitchExample);
    }

    @CacheEvict(value={"billSwitch"}, allEntries=true)
    @Override
    public void addObj(BillSwitch t) {
        this.billSwitchMapper.insertSelective(t);
    }

    @CacheEvict(value={"billSwitch"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.billSwitchMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"billSwitch"}, allEntries=true)
    @Override
    public void modifyObj(BillSwitch t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.billSwitchMapper.updateByPrimaryKeySelective(t);
    }


    @CacheEvict(value={"billSwitch"}, allEntries=true)
    @Override
    public void updateByPrimaryKey(BillSwitch t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.billSwitchMapper.updateByPrimaryKey(t);
    }

    @Cacheable(value="billSwitch", keyGenerator="redisKeyGenerator")
    @Override
    public BillSwitch queryObjById(String id) {
        return this.billSwitchMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="billSwitch", keyGenerator="redisKeyGenerator")
    @Override
    public List<BillSwitch> queryAllObjByExample(BillSwitchExample example) {
        return this.billSwitchMapper.selectByExample(example);
    }

    @Cacheable(value="billSwitch", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<BillSwitch> queryObjByPage(BillSwitchExample example) {
        PageView<BillSwitch> pageView = example.getPageView();
        pageView.setQueryResult(this.billSwitchMapper.selectByExampleByPage(example));
        return pageView;
    }
}