package com.els.base.category.command;

import com.els.base.category.entity.CompanyCategory;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;

import java.util.Date;

/**
 * 创建分组
 */
public class CreateCommand extends AbstractBillCommand<String> {

    private CompanyCategory companyCategory;

    public CreateCommand(CompanyCategory companyCategory) {
        this.companyCategory = companyCategory;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;

        this.check(companyCategory);

        this.process(companyCategory);

        return null;
    }

    private void process(CompanyCategory companyCategory) {
        companyCategory.setId(UUIDGenerator.generateUUID());
        companyCategory.setProjectId(getProject().getId());
        companyCategory.setPurCompanyId(getProject().getCompanyId());
        companyCategory.setPurCompanyFullName(getPurCompany().getCompanyFullName());
        companyCategory.setPurCompanyName(getPurCompany().getCompanyName());
        companyCategory.setPurCompanySapCode(getPurCompany().getCompanySapCode());
        companyCategory.setPurCompanySrmCode(getPurCompany().getCompanyCode());
        companyCategory.setPurUserId(getPurUser().getId());
        companyCategory.setPurUserName(getPurUser().getNickName());
        companyCategory.setCreateTime(new Date());
        companyCategory.setIsEnable(Constant.YES_INT);

        //设置分组编码
        String nextCode = this.billInvorker.getGenerateCodeService().getNextCode("COMPANY_CATEGORY_NO");
        companyCategory.setCategoryNo(nextCode);
        this.billInvorker.getCompanyCategoryService().addObj(companyCategory);

    }

    private void check(CompanyCategory companyCategory) {
        Assert.isNotNull(companyCategory,"分组信息不能为空！");
        Assert.isNotBlank(companyCategory.getCategoryName(),"供应商分组名称不能为空!");
    }
}
