package com.els.base.category.command;

import com.els.base.billswitch.entity.BillSwitchExample;
import com.els.base.category.entity.CompanyCategory;
import com.els.base.category.entity.CompanyCategoryExample;
import com.els.base.categoryref.entity.CompanyCategoryRefExample;
import com.els.base.categoryswitch.entity.CategoryBillSwitchExample;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.utils.Assert;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

public class DeleteCommand extends AbstractBillCommand<String> {

    /**
     * 分组ID
     */
    private List<String> ids ;

    public DeleteCommand(List<String> ids) {
        this.ids = ids;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;

        this.check(ids);

        this.process(ids);

        return null;
    }

    private void process(List<String> ids) {

        CompanyCategoryExample example = new CompanyCategoryExample();
        example.createCriteria().andIdIn(ids);
        List<CompanyCategory> companyCategories = this.billInvorker.getCompanyCategoryService().queryAllObjByExample(example);
        if(CollectionUtils.isEmpty(companyCategories)){
            return;
        }
        List<String> no = companyCategories.stream().map(CompanyCategory::getCategoryNo).collect(Collectors.toList());

        //1、删除分组与供应商的关系
        this.deleteCompanyCategoryRef(no);

        //2、删除限制组信息
        this.deleteCompanyCategorySwitch(no);

        //3、删除具体供应商的限制信息
        this.deleteBillSwitch(no);

        //4、删除分组的信息
        this.deleteCompanyCategory(ids);

    }

    /**
     * 根据分组ID删除具体的对账限制
     * @param no
     */
    private void deleteBillSwitch(List<String> no) {
        BillSwitchExample billSwitchExample = new BillSwitchExample();
        billSwitchExample.createCriteria().andCategoryNoIn(no);
        this.billInvorker.getBillSwitchService().deleteByExample(billSwitchExample);

    }

    /**
     * 根据分组no删除对账组设置
     * @param no
     */
    private void deleteCompanyCategorySwitch(List<String> no) {
        CategoryBillSwitchExample categoryBillSwitchExample = new CategoryBillSwitchExample();
        categoryBillSwitchExample.createCriteria().andCategoryNoIn(no);
        this.billInvorker.getCategoryBillSwitchService().deleteByExample(categoryBillSwitchExample);

    }

    /**
     * 根据分组no删除分组下面的关联的供应商
     * @param no
     */
    private void deleteCompanyCategoryRef(List<String> no) {
        CompanyCategoryRefExample companyCategoryRefExample = new CompanyCategoryRefExample();
        companyCategoryRefExample.createCriteria().andCategoryNoIn(no);
        this.billInvorker.getCompanyCategoryRefService().deleteByExample(companyCategoryRefExample);

    }

    /**
     * 根据分组ID删除分组信息
     * @param ids
     */
    private void deleteCompanyCategory(List<String> ids) {
        //更新为不可用
        CompanyCategoryExample companyCategoryExample =new CompanyCategoryExample();
        companyCategoryExample.createCriteria().andIdIn(ids);
        //更新分组信息
       this.billInvorker.getCompanyCategoryService().deleteByExample(companyCategoryExample);
    }

    private void check(List<String> ids) {
        Assert.isNotEmpty(ids, "删除失败,id不能为空");
    }
}
