package com.els.base.category.command;

import com.els.base.billswitch.entity.BillSwitch;
import com.els.base.billswitch.entity.BillSwitchExample;
import com.els.base.category.entity.CompanyCategory;
import com.els.base.categoryref.entity.CompanyCategoryRef;
import com.els.base.categoryref.entity.CompanyCategoryRefExample;
import com.els.base.categoryswitch.entity.CategoryBillSwitch;
import com.els.base.categoryswitch.entity.CategoryBillSwitchExample;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.utils.Assert;

import java.util.Date;

/**
 * 编辑分组信息
 */
public class EditCommand extends AbstractBillCommand<String> {

    private CompanyCategory companyCategory;

    public EditCommand(CompanyCategory companyCategory) {
        this.companyCategory = companyCategory;
    }

    @Override
    public String execute(BillInvorker billInvorker) {

        this.billInvorker = billInvorker;

        this.check(companyCategory);

        this.process(companyCategory);

        return null;
    }

    private void process(CompanyCategory companyCategory) {

        //1、更新分组名称，分组备注
        CompanyCategory category = this.billInvorker.getCompanyCategoryService().queryObjById(companyCategory.getId());
        Assert.isNotNull(category, "分组信息不存在，不能进行编辑！");

        //只能更新以下信息
        category.setRemark(companyCategory.getRemark());
        category.setCategoryName(companyCategory.getCategoryName());
        category.setUpdateTime(new Date());
        this.billInvorker.getCompanyCategoryService().modifyObj(category);

        //2、更新该分组下的关联供应商的分组名称
        this.updateCompanyCategoryRef(category);

        //3、更新对账组设置
        this.updateCategoryBillSwitch(category);

        //4、更新具体的对账限制
        this.updateBillSwitch(category);

    }

    private void updateBillSwitch(CompanyCategory category) {
        BillSwitchExample example = new BillSwitchExample();
        example.createCriteria().andCategoryNoEqualTo(category.getCategoryNo());
        int i = this.billInvorker.getBillSwitchService().countByExample(example);
        if (i > 0) {
            BillSwitch billSwitch = new BillSwitch();
            billSwitch.setCategoryName(category.getCategoryName());
            billSwitch.setCategoryNo(category.getCategoryNo());
            this.billInvorker.getBillSwitchService().updateByExampleSelective(billSwitch, example);
        }
    }

    private void updateCategoryBillSwitch(CompanyCategory category) {
        CategoryBillSwitchExample example = new CategoryBillSwitchExample();
        example.createCriteria().andCategoryNoEqualTo(category.getCategoryNo());
        int i = this.billInvorker.getCategoryBillSwitchService().countByExample(example);
        if (i > 0) {
            CategoryBillSwitch categoryBillSwitch = new CategoryBillSwitch();
            categoryBillSwitch.setCategoryName(category.getCategoryName());
            categoryBillSwitch.setCategoryNo(category.getCategoryNo());
            this.billInvorker.getCategoryBillSwitchService().updateByExampleSelective(categoryBillSwitch, example);
        }
    }

    private void updateCompanyCategoryRef(CompanyCategory category) {
        CompanyCategoryRefExample example = new CompanyCategoryRefExample();
        example.createCriteria().andCategoryNoEqualTo(category.getCategoryNo());

        int i = this.billInvorker.getCompanyCategoryRefService().countByExample(example);
        if (i > 0) {
            CompanyCategoryRef companyCategoryRef = new CompanyCategoryRef();
            companyCategoryRef.setCategoryName(category.getCategoryName());
            companyCategoryRef.setCategoryNo(category.getCategoryNo());
            this.billInvorker.getCompanyCategoryRefService().updateByExampleSelective(companyCategoryRef, example);
        }
    }

    private void check(CompanyCategory companyCategory) {
        Assert.isNotBlank(companyCategory.getId(), "id 为空，保存失败");
        Assert.isNotBlank(companyCategory.getCategoryName(), "分组名称不能为空，保存失败");
    }
}
