package com.els.base.category.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.category.command.CreateCommand;
import com.els.base.category.command.DeleteCommand;
import com.els.base.category.command.EditCommand;
import com.els.base.category.entity.CompanyCategory;
import com.els.base.category.entity.CompanyCategoryExample;
import com.els.base.category.service.CompanyCategoryService;
import com.els.base.common.BillInvorker;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

@Api(value="采购结算管理-供应商分组，分类信息")
@Controller
@RequestMapping("companyCategory")
public class CompanyCategoryController {
    @Resource
    protected CompanyCategoryService companyCategoryService;
    @Resource
    private BillInvorker invoker;

    @ApiOperation(httpMethod="POST", value="创建采购结算管理-供应商分组，分类信息")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyCategory companyCategory) {
        CreateCommand cmd = new CreateCommand(companyCategory);
        cmd.setProject(ProjectUtils.getProject());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑采购结算管理-供应商分组，分类信息")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CompanyCategory companyCategory) {
        EditCommand cmd = new EditCommand(companyCategory);
        cmd.setProject(ProjectUtils.getProject());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除采购结算管理-供应商分组，分类信息")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        //this.companyCategoryService.deleteObjById(id);
        List<String> ids= Arrays.asList(id);
        DeleteCommand cmd = new DeleteCommand(ids);
        cmd.setProject(ProjectUtils.getProject());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除采购结算管理-供应商分组，分类信息")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        DeleteCommand cmd = new DeleteCommand(ids);
        cmd.setProject(ProjectUtils.getProject());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod="POST", value="查询采购结算管理-供应商分组，分类信息")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CompanyCategory", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<CompanyCategory>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        CompanyCategoryExample example = new CompanyCategoryExample();
        example.setPageView(new PageView<CompanyCategory>(pageNo, pageSize));
        
        CompanyCategoryExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
                .andPurCompanyIdEqualTo(ProjectUtils.getCompanyId())
                .andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView<CompanyCategory> pageData = this.companyCategoryService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}