package com.els.base.category.service.impl;

import com.els.base.category.dao.CompanyCategoryMapper;
import com.els.base.category.entity.CompanyCategory;
import com.els.base.category.entity.CompanyCategoryExample;
import com.els.base.category.service.CompanyCategoryService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

@Service("defaultCompanyCategoryService")
public class CompanyCategoryServiceImpl implements CompanyCategoryService {

    @Resource
    protected CompanyCategoryMapper companyCategoryMapper;

    @Cacheable(value="companyCategory", keyGenerator="redisKeyGenerator")
    @Override
    public int countByExample(CompanyCategoryExample example) {
        return this.companyCategoryMapper.countByExample(example);
    }

    @CacheEvict(value={"companyCategory"}, allEntries=true)
    @Transactional
    @Override
    public void deleteByExample(CompanyCategoryExample example) {
        Assert.isNotEmpty(example.getOredCriteria(),"不能进行全表删除，请检查！");
        this.companyCategoryMapper.deleteByExample(example);
    }

    @Cacheable(value="companyCategory", keyGenerator="redisKeyGenerator")
    @Override
    public CompanyCategory queryCompanyCategoryByCategory(String categoryNo) {
        CompanyCategoryExample companyCategoryExample =new CompanyCategoryExample();
        companyCategoryExample.createCriteria()
                .andIsEnableEqualTo(Constant.YES_INT)
                .andCategoryNoEqualTo(categoryNo);
        List<CompanyCategory> companyCategories = companyCategoryMapper.selectByExample(companyCategoryExample);
        if(CollectionUtils.isNotEmpty(companyCategories)){
            return  companyCategories.get(0);
        }
        return null;
    }

    @CacheEvict(value={"companyCategory"}, allEntries=true)
    @Override
    public void addObj(CompanyCategory t) {
        this.companyCategoryMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyCategory"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.companyCategoryMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyCategory"}, allEntries=true)
    @Override
    public void modifyObj(CompanyCategory t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.companyCategoryMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="companyCategory", keyGenerator="redisKeyGenerator")
    @Override
    public CompanyCategory queryObjById(String id) {
        return this.companyCategoryMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="companyCategory", keyGenerator="redisKeyGenerator")
    @Override
    public List<CompanyCategory> queryAllObjByExample(CompanyCategoryExample example) {
        return this.companyCategoryMapper.selectByExample(example);
    }

    @Cacheable(value="companyCategory", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CompanyCategory> queryObjByPage(CompanyCategoryExample example) {
        PageView<CompanyCategory> pageView = example.getPageView();
        pageView.setQueryResult(this.companyCategoryMapper.selectByExampleByPage(example));
        return pageView;
    }
}