package com.els.base.categoryref.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.categoryref.command.AppointCommand;
import com.els.base.categoryref.entity.CompanyCategoryRef;
import com.els.base.categoryref.entity.CompanyCategoryRefExample;
import com.els.base.categoryref.service.CompanyCategoryRefService;
import com.els.base.common.BillInvorker;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.*;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.List;

@Api(value="采购结算管理-供应商所属组的关系")
@Controller
@RequestMapping("companyCategoryRef")
public class CompanyCategoryRefController {
    @Resource
    protected CompanyCategoryRefService companyCategoryRefService;
    @Resource
    private BillInvorker invoker;

    @ApiOperation(httpMethod = "POST", value = "给供应商分组")
    @RequestMapping("service/appoint")
    @ResponseBody
    public ResponseResult<String> appoint(
            @ApiParam(value = "供应商分组ID") @RequestParam(required = true) String companyCategoryNo,
            @ApiParam(value = "供应商列表") @RequestBody List<Company> companyList) {
        AppointCommand cmd = new AppointCommand(companyCategoryNo,companyList);
        cmd.setProject(ProjectUtils.getProject());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        invoker.invoke(cmd);
        return ResponseResult.success();
    }

  /*  @ApiOperation(httpMethod="POST", value="创建采购结算管理-供应商所属组的关系")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyCategoryRef companyCategoryRef) {
        this.companyCategoryRefService.addObj(companyCategoryRef);
        return ResponseResult.success();
    }*/

   /* @ApiOperation(httpMethod="POST", value="编辑采购结算管理-供应商所属组的关系")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CompanyCategoryRef companyCategoryRef) {
        Assert.isNotBlank(companyCategoryRef.getId(), "id 为空，保存失败");
        this.companyCategoryRefService.modifyObj(companyCategoryRef);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除采购结算管理-供应商所属组的关系")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.companyCategoryRefService.deleteObjById(id);
        return ResponseResult.success();
    }*/

    @ApiOperation(httpMethod="POST", value="查询采购结算管理-供应商所属组的关系")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CompanyCategoryRef", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<CompanyCategoryRef>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        CompanyCategoryRefExample example = new CompanyCategoryRefExample();
        example.setPageView(new PageView<CompanyCategoryRef>(pageNo, pageSize));
        
        CompanyCategoryRefExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
                .andPurCompanyIdEqualTo(ProjectUtils.getCompanyId())
                .andIsEnableEqualTo(Constant.YES_INT);

        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<CompanyCategoryRef> pageData = this.companyCategoryRefService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod="POST", value="查询采购结算管理-查询全部供应商所属组的关系")
    @ApiImplicitParams({
            @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CompanyCategoryRef", paramType = "body", dataType = "QueryParamWapper" )
    })
    @RequestMapping("service/findAll")
    @ResponseBody
    public ResponseResult<List<CompanyCategoryRef>> findAll(
            @RequestBody(required=false) QueryParamWapper wapper) {

        CompanyCategoryRefExample example = new CompanyCategoryRefExample();
        CompanyCategoryRefExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
                .andPurCompanyIdEqualTo(ProjectUtils.getCompanyId())
                .andIsEnableEqualTo(Constant.YES_INT);

        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        List<CompanyCategoryRef> companyCategoryRefs = this.companyCategoryRefService.queryAllObjByExample(example);
        return ResponseResult.success(companyCategoryRefs);
    }

}