package com.els.base.categoryref.service;

import com.els.base.auth.entity.User;
import com.els.base.categoryref.entity.CompanyCategoryRef;
import com.els.base.categoryref.entity.CompanyCategoryRefExample;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.core.service.BaseService;

import java.util.List;

public interface CompanyCategoryRefService extends BaseService<CompanyCategoryRef, CompanyCategoryRefExample, String> {

    void deleteByExample(CompanyCategoryRefExample example);
    int updateByExampleSelective(CompanyCategoryRef record, CompanyCategoryRefExample example);
    int countByExample(CompanyCategoryRefExample example);
    /**
     * 根据分组编码查询全部供应商
     * @param companyCategoryNo
     * @return
     */
    List<CompanyCategoryRef> findByCompanyCategoryNo(String companyCategoryNo);

    /**
     * 删除分组下的供应商
     * @param companyCategoryNo
     */
    void  deleteByCompanyCategoryNo(String companyCategoryNo);

    /**
     * 删除分组下的供应商
     * @param companyCategoryNo
     */
    void  deleteByCompanyCategoryNo(List<String> companyCategoryNo);

}