package com.els.base.categoryref.service.impl;

import com.els.base.categoryref.dao.CompanyCategoryRefMapper;
import com.els.base.categoryref.entity.CompanyCategoryRef;
import com.els.base.categoryref.entity.CompanyCategoryRefExample;
import com.els.base.categoryref.service.CompanyCategoryRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

@Service("defaultCompanyCategoryRefService")
public class CompanyCategoryRefServiceImpl implements CompanyCategoryRefService {
    @Resource
    protected CompanyCategoryRefMapper companyCategoryRefMapper;

    @Cacheable(value = "companyCategoryRef", keyGenerator = "redisKeyGenerator")
    @Override
    public int countByExample(CompanyCategoryRefExample example) {
        return this.companyCategoryRefMapper.countByExample(example);
    }

    @CacheEvict(value = {"companyCategoryRef"}, allEntries = true)
    @Transactional
    @Override
    public int updateByExampleSelective(CompanyCategoryRef record, CompanyCategoryRefExample example) {
        return this.companyCategoryRefMapper.updateByExampleSelective(record,example);
    }

    @CacheEvict(value = {"companyCategoryRef"}, allEntries = true)
    @Transactional
    @Override
    public void deleteByExample(CompanyCategoryRefExample example) {
        Assert.isNotEmpty(example.getOredCriteria(),"不能进行全表删除，请检查！");
        this.companyCategoryRefMapper.deleteByExample(example);
    }

    @CacheEvict(value = {"companyCategoryRef"}, allEntries = true)
    @Transactional
    @Override
    public void deleteByCompanyCategoryNo(List<String> companyCategoryNos) {
        CompanyCategoryRefExample companyCategoryRefExample = new CompanyCategoryRefExample();
        companyCategoryRefExample.createCriteria()
                .andIsEnableEqualTo(Constant.YES_INT)
                .andCategoryNoIn(companyCategoryNos);

        CompanyCategoryRef companyCategoryRef = new CompanyCategoryRef();
        companyCategoryRef.setIsEnable(Constant.NO_INT);

        int i = this.companyCategoryRefMapper.countByExample(companyCategoryRefExample);
        if (i > 0) {
            this.companyCategoryRefMapper.updateByExampleSelective(companyCategoryRef, companyCategoryRefExample);
        }
    }

    @CacheEvict(value = {"companyCategoryRef"}, allEntries = true)
    @Transactional
    @Override
    public void deleteByCompanyCategoryNo(String companyCategoryNo) {
        CompanyCategoryRefExample companyCategoryRefExample = new CompanyCategoryRefExample();
        companyCategoryRefExample.createCriteria()
                .andIsEnableEqualTo(Constant.YES_INT)
                .andCategoryNoEqualTo(companyCategoryNo);

        CompanyCategoryRef companyCategoryRef = new CompanyCategoryRef();
        companyCategoryRef.setIsEnable(Constant.NO_INT);

        int i = this.companyCategoryRefMapper.countByExample(companyCategoryRefExample);
        if (i > 0) {
            this.companyCategoryRefMapper.updateByExampleSelective(companyCategoryRef, companyCategoryRefExample);
        }
    }

    @Cacheable(value = "companyCategoryRef", keyGenerator = "redisKeyGenerator")
    @Override
    public List<CompanyCategoryRef> findByCompanyCategoryNo(String companyCategoryNo) {
        CompanyCategoryRefExample companyCategoryRefExample = new CompanyCategoryRefExample();
        companyCategoryRefExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT)
                .andCategoryNoEqualTo(companyCategoryNo);
        List<CompanyCategoryRef> companyCategoryRefList = companyCategoryRefMapper.selectByExample(companyCategoryRefExample);
        return companyCategoryRefList;
    }

    @CacheEvict(value = {"companyCategoryRef"}, allEntries = true)
    @Override
    public void addObj(CompanyCategoryRef t) {
        this.companyCategoryRefMapper.insertSelective(t);
    }

    @CacheEvict(value = {"companyCategoryRef"}, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.companyCategoryRefMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = {"companyCategoryRef"}, allEntries = true)
    @Override
    public void modifyObj(CompanyCategoryRef t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.companyCategoryRefMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "companyCategoryRef", keyGenerator = "redisKeyGenerator")
    @Override
    public CompanyCategoryRef queryObjById(String id) {
        return this.companyCategoryRefMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "companyCategoryRef", keyGenerator = "redisKeyGenerator")
    @Override
    public List<CompanyCategoryRef> queryAllObjByExample(CompanyCategoryRefExample example) {
        return this.companyCategoryRefMapper.selectByExample(example);
    }

    @Cacheable(value = "companyCategoryRef", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<CompanyCategoryRef> queryObjByPage(CompanyCategoryRefExample example) {
        PageView<CompanyCategoryRef> pageView = example.getPageView();
        pageView.setQueryResult(this.companyCategoryRefMapper.selectByExampleByPage(example));
        return pageView;
    }
}