package com.els.base.categoryswitch.command;

import com.els.base.billswitch.entity.BillSwitch;
import com.els.base.billswitch.entity.BillSwitchExample;
import com.els.base.category.entity.CompanyCategory;
import com.els.base.categoryref.entity.CompanyCategoryRef;
import com.els.base.categoryswitch.entity.CategoryBillSwitch;
import com.els.base.categoryswitch.entity.CategoryBillSwitchExample;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import org.apache.commons.lang.time.DateUtils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class CreateCommand extends AbstractBillCommand<String> {

    private CategoryBillSwitch categoryBillSwitch;

    public CreateCommand(CategoryBillSwitch categoryBillSwitch) {
        this.categoryBillSwitch = categoryBillSwitch;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;

        this.check(categoryBillSwitch);

        this.process(categoryBillSwitch);

        return null;
    }

    private void process(CategoryBillSwitch categoryBillSwitch) {

        //插入限制组信息
        this.insertCategoryBillSwitch(categoryBillSwitch);

        //给分组下的供应商设置开票时间
        this.insertBillSwitch(categoryBillSwitch);

    }

    private void insertBillSwitch(CategoryBillSwitch categoryBillSwitch) {

        List<CompanyCategoryRef> companyCategoryRefList =this.billInvorker.getCompanyCategoryRefService().findByCompanyCategoryNo(categoryBillSwitch.getCategoryNo());
        Assert.isNotEmpty(companyCategoryRefList,"尚未给该供应商分组指定供应商，请指定！");

        //先删掉原来的信息
        this.deleteBillSwitch(categoryBillSwitch);

        //插入现在的信息
        this.insertBillSwitch(categoryBillSwitch, companyCategoryRefList);

    }

    /**
     * 插入新的时间限制
     * @param categoryBillSwitch
     * @param companyCategoryRefList
     */
    private void insertBillSwitch(CategoryBillSwitch categoryBillSwitch, List<CompanyCategoryRef> companyCategoryRefList) {

        List<BillSwitch> list = new ArrayList<>();
        for (CompanyCategoryRef companyCategoryRef : companyCategoryRefList) {
            BillSwitch billSwitch =new BillSwitch();

            //其他信息
            billSwitch.setId(UUIDGenerator.generateUUID());
            billSwitch.setIsEnable(Constant.YES_INT);
            billSwitch.setProjectId(categoryBillSwitch.getProjectId());
            billSwitch.setCreateTime(new Date());
            billSwitch.setUpdateTime(new Date());
            billSwitch.setSwitchFlag(categoryBillSwitch.getSwitchFlag());
            billSwitch.setStartTime(categoryBillSwitch.getStartTime());
            billSwitch.setEndTime(categoryBillSwitch.getEndTime());

            //采购商信息
            billSwitch.setPurCompanyId(categoryBillSwitch.getPurCompanyId());
            billSwitch.setPurCompanyFullName(categoryBillSwitch.getPurCompanyFullName());
            billSwitch.setPurCompanyName(categoryBillSwitch.getPurCompanyName());
            billSwitch.setPurCompanySapCode(categoryBillSwitch.getPurCompanySapCode());
            billSwitch.setPurCompanySrmCode(categoryBillSwitch.getPurCompanySrmCode());

            //采购员信息
            billSwitch.setPurUserId(categoryBillSwitch.getPurUserId());
            billSwitch.setPurUserName(categoryBillSwitch.getPurUserName());

            //供应商基本信息
            billSwitch.setSupCompanyId(companyCategoryRef.getSupCompanyId());
            billSwitch.setSupCompanyFullName(companyCategoryRef.getSupCompanyFullName());
            billSwitch.setSupCompanyName(companyCategoryRef.getSupCompanyName());
            billSwitch.setSupCompanySapCode(companyCategoryRef.getSupCompanySapCode());
            billSwitch.setSupCompanySrmCode(companyCategoryRef.getSupCompanySrmCode());

            //分组编号
            billSwitch.setCategoryNo(categoryBillSwitch.getCategoryNo());
            billSwitch.setCategoryName(categoryBillSwitch.getCategoryName());

            //凭证时间
            billSwitch.setVoucherStartTime(categoryBillSwitch.getVoucherStartTime());
            billSwitch.setVoucherEndTime(categoryBillSwitch.getVoucherEndTime());

            list.add(billSwitch);

        }
        this.billInvorker.getBillSwitchService().addAll(list);
    }

    private void deleteBillSwitch(CategoryBillSwitch categoryBillSwitch) {
        BillSwitchExample billSwitchExample =new BillSwitchExample();
        billSwitchExample.createCriteria()
                .andIsEnableEqualTo(Constant.YES_INT)
                .andCategoryNoEqualTo(categoryBillSwitch.getCategoryNo());
        this.billInvorker.getBillSwitchService().deleteByExample(billSwitchExample);
    }

    private void insertCategoryBillSwitch(CategoryBillSwitch categoryBillSwitch) {
        categoryBillSwitch.setId(UUIDGenerator.generateUUID());
        categoryBillSwitch.setProjectId(getProject().getId());
        categoryBillSwitch.setIsEnable(Constant.YES_INT);
        if(categoryBillSwitch.getSwitchFlag()==null){
            categoryBillSwitch.setSwitchFlag(Constant.YES_INT);
        }
        categoryBillSwitch.setCreateTime(new Date());

        //采购基本信息
        categoryBillSwitch.setPurCompanyId(getProject().getCompanyId());
        categoryBillSwitch.setPurCompanyName(getPurCompany().getCompanyName());
        categoryBillSwitch.setPurCompanyFullName(getPurCompany().getCompanyFullName());
        categoryBillSwitch.setPurCompanySapCode(getPurCompany().getCompanySapCode());
        categoryBillSwitch.setPurCompanySrmCode(getPurCompany().getCompanyCode());
        categoryBillSwitch.setPurUserId(getPurUser().getId());
        categoryBillSwitch.setPurUserName(getPurUser().getNickName());

        //分组信息
        CompanyCategory companyCategory = this.billInvorker.getCompanyCategoryService().queryCompanyCategoryByCategory(categoryBillSwitch.getCategoryNo());
        if(companyCategory!=null){
            categoryBillSwitch.setCategoryName(companyCategory.getCategoryName());
        }

        //格式化时间为2018-07-06 00:00:00
        this.initVoucher(categoryBillSwitch);

        //这个insert主要考虑到也要插入凭证日期有可能不维护的情况，主要是用户清空了这个日期
        this.billInvorker.getCategoryBillSwitchService().insert(categoryBillSwitch);

    }

    /**
     * 初始化一下这个时间到天数
     * @param categoryBillSwitch
     */
    private void initVoucher(CategoryBillSwitch categoryBillSwitch) {
        if(categoryBillSwitch.getVoucherStartTime()!=null){
            Date start = DateUtils.truncate(categoryBillSwitch.getVoucherStartTime(), Calendar.DATE);
            categoryBillSwitch.setVoucherStartTime(start);
        }
        if(categoryBillSwitch.getVoucherEndTime()!=null){
            Date end = DateUtils.truncate(categoryBillSwitch.getVoucherEndTime(), Calendar.DATE);
            categoryBillSwitch.setVoucherEndTime(end);
        }
    }

    private void check(CategoryBillSwitch categoryBillSwitch) {
        Assert.isNotNull(categoryBillSwitch,"对账时间限制不能为空");

        String categoryNo = categoryBillSwitch.getCategoryNo();
        Assert.isNotBlank(categoryNo,"供应商分组不能为空！");

        //对账限制开始时间不能为空
        Assert.isNotNull(categoryBillSwitch.getStartTime(),"对账开始时间限制不能为空");
        Assert.isNotNull(categoryBillSwitch.getEndTime(),"对账结束时间限制不能为空");

        //只能填写数据
        if(categoryBillSwitch.getStartTime()>=1&&categoryBillSwitch.getStartTime()<=31){
        }else{
            throw new CommonException("请输入1-31的整数!");
        }

        if(categoryBillSwitch.getEndTime()>=1&&categoryBillSwitch.getEndTime()<=31){
        }else{
            throw new CommonException("请输入1-31的整数!");
        }

        //注意凭证时间是允许为空，但是填了，必须得设置一对数字
        //凭证时间设置：如果填了一个，那么相对应也要填另外一个
        if(categoryBillSwitch.getVoucherStartTime()!=null){
            Assert.isNotNull(categoryBillSwitch.getVoucherEndTime(),"凭证结束时间不能为空！");
        }
        if(categoryBillSwitch.getVoucherEndTime()!=null){
            Assert.isNotNull(categoryBillSwitch.getVoucherStartTime(),"凭证开始时间不能为空！");
        }

        //同一个组的不能创建多次
        CategoryBillSwitchExample categoryBillSwitchExample = new CategoryBillSwitchExample();
        categoryBillSwitchExample.createCriteria()
                .andIsEnableEqualTo(Constant.YES_INT)
                .andCategoryNoEqualTo(categoryNo);

        int i = this.billInvorker.getCategoryBillSwitchService().countByExample(categoryBillSwitchExample);
        if (i >0 ) {
            throw  new CommonException("该分组已经创建过开票时间了，请检查，谢谢！");
        }
    }
}
