package com.els.base.categoryswitch.command;

import com.els.base.billswitch.entity.BillSwitchExample;
import com.els.base.categoryswitch.entity.CategoryBillSwitch;
import com.els.base.categoryswitch.entity.CategoryBillSwitchExample;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.utils.Assert;

import java.util.List;
import java.util.stream.Collectors;

public class DeleteCommand extends AbstractBillCommand<String> {

    List<String> ids;

    public DeleteCommand(List<String> ids) {
        this.ids = ids;
    }

    @Override
    public String execute(BillInvorker billInvorker) {

        this.check(ids);

        this.process(ids);

        return null;
    }

    private void process(List<String> ids) {
        CategoryBillSwitchExample categoryBillSwitchExample = new CategoryBillSwitchExample();
        categoryBillSwitchExample.createCriteria().andIdIn(ids);
        List<CategoryBillSwitch> categoryBillSwitches = this.billInvorker.getCategoryBillSwitchService().queryAllObjByExample(categoryBillSwitchExample);
        Assert.isNotEmpty(categoryBillSwitches, "没有对应的对账限制，请检查！");

        //删除对账组限制
        this.billInvorker.getCategoryBillSwitchService().deleteByExample(categoryBillSwitchExample);

        //删除对账具体的限制
        List<String> no = categoryBillSwitches.stream().map(CategoryBillSwitch::getCategoryNo).collect(Collectors.toList());
        BillSwitchExample billSwitchExample = new BillSwitchExample();
        billSwitchExample.createCriteria().andCategoryNoIn(no);
        this.billInvorker.getBillSwitchService().deleteByExample(billSwitchExample);
    }

    private void check(List<String> ids) {
        Assert.isNotEmpty(ids, "删除失败,id不能为空");
    }

}
