package com.els.base.categoryswitch.command;

import com.els.base.billswitch.entity.BillSwitch;
import com.els.base.billswitch.entity.BillSwitchExample;
import com.els.base.categoryref.entity.CompanyCategoryRef;
import com.els.base.categoryref.entity.CompanyCategoryRefExample;
import com.els.base.categoryswitch.entity.CategoryBillSwitch;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import org.apache.commons.lang.time.DateUtils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class UpdateCommand extends AbstractBillCommand<String> {

    private CategoryBillSwitch categoryBillSwitch;

    public UpdateCommand(CategoryBillSwitch categoryBillSwitch) {
        this.categoryBillSwitch = categoryBillSwitch;
    }

    @Override
    public String execute(BillInvorker billInvorker) {

        this.billInvorker = billInvorker;

        this.check(categoryBillSwitch);

        this.process(categoryBillSwitch);

        return null;
    }

    private void process(CategoryBillSwitch categoryBillSwitch) {

        //更新对账组限制信息
        CategoryBillSwitch categoryBillSwitch1 = this.updateCategoryBillSwitch(categoryBillSwitch);

        //更新对账限制具体信息
        this.updateBillSwitch(categoryBillSwitch1);

    }

    private void updateBillSwitch(CategoryBillSwitch categoryBillSwitch) {

        //删除原来的具体限制
        this.deleteBillSwitch(categoryBillSwitch);

        //查询对应的供应商列表
        this.addBillSwitch(categoryBillSwitch);
    }

    private void addBillSwitch(CategoryBillSwitch categoryBillSwitch) {

        CompanyCategoryRefExample companyCategoryRefExample = new CompanyCategoryRefExample();
        companyCategoryRefExample.createCriteria().andCategoryNoEqualTo(categoryBillSwitch.getCategoryNo());

        List<CompanyCategoryRef> companyCategoryRefList = this.billInvorker.getCompanyCategoryRefService().queryAllObjByExample(companyCategoryRefExample);
        Assert.isNotEmpty(companyCategoryRefList, "请为分组编码为：" + categoryBillSwitch.getCategoryNo() + ",分组名字为：" + categoryBillSwitch.getCategoryName() + ",分配对应的供应商！");

        List<BillSwitch> list = new ArrayList<>();
        for (CompanyCategoryRef companyCategoryRef : companyCategoryRefList) {

            //初始化具体的对账限制信息
            BillSwitch billSwitch = initBillSwitch(categoryBillSwitch, companyCategoryRef);

            list.add(billSwitch);

        }
        this.billInvorker.getBillSwitchService().addAll(list);

    }

    private BillSwitch initBillSwitch(CategoryBillSwitch categoryBillSwitch, CompanyCategoryRef companyCategoryRef) {
        BillSwitch billSwitch = new BillSwitch();

        //其他信息
        billSwitch.setId(UUIDGenerator.generateUUID());
        billSwitch.setIsEnable(Constant.YES_INT);
        billSwitch.setProjectId(categoryBillSwitch.getProjectId());
        billSwitch.setCreateTime(new Date());
        billSwitch.setUpdateTime(new Date());
        billSwitch.setSwitchFlag(categoryBillSwitch.getSwitchFlag());
        billSwitch.setStartTime(categoryBillSwitch.getStartTime());
        billSwitch.setEndTime(categoryBillSwitch.getEndTime());

        //采购商信息
        billSwitch.setPurCompanyId(categoryBillSwitch.getPurCompanyId());
        billSwitch.setPurCompanyFullName(categoryBillSwitch.getPurCompanyFullName());
        billSwitch.setPurCompanyName(categoryBillSwitch.getPurCompanyName());
        billSwitch.setPurCompanySapCode(categoryBillSwitch.getPurCompanySapCode());
        billSwitch.setPurCompanySrmCode(categoryBillSwitch.getPurCompanySrmCode());

        //采购员信息
        billSwitch.setPurUserId(categoryBillSwitch.getPurUserId());
        billSwitch.setPurUserName(categoryBillSwitch.getPurUserName());

        //供应商基本信息
        billSwitch.setSupCompanyId(companyCategoryRef.getSupCompanyId());
        billSwitch.setSupCompanyFullName(companyCategoryRef.getSupCompanyFullName());
        billSwitch.setSupCompanyName(companyCategoryRef.getSupCompanyName());
        billSwitch.setSupCompanySapCode(companyCategoryRef.getSupCompanySapCode());
        billSwitch.setSupCompanySrmCode(companyCategoryRef.getSupCompanySrmCode());

        //分组编号
        billSwitch.setCategoryNo(categoryBillSwitch.getCategoryNo());
        billSwitch.setCategoryName(categoryBillSwitch.getCategoryName());

        //凭证时间
        billSwitch.setVoucherStartTime(categoryBillSwitch.getVoucherStartTime());
        billSwitch.setVoucherEndTime(categoryBillSwitch.getVoucherEndTime());
        return billSwitch;
    }

    private void deleteBillSwitch(CategoryBillSwitch categoryBillSwitch) {
        BillSwitchExample billSwitchExample = new BillSwitchExample();
        billSwitchExample.createCriteria()
                .andCategoryNoEqualTo(categoryBillSwitch.getCategoryNo());
        this.billInvorker.getBillSwitchService().deleteByExample(billSwitchExample);
    }

    private CategoryBillSwitch updateCategoryBillSwitch(CategoryBillSwitch categoryBillSwitch) {
        CategoryBillSwitch oldCategoryBillSwitch = this.billInvorker.getCategoryBillSwitchService().queryObjById(categoryBillSwitch.getId());
        Assert.isNotNull(oldCategoryBillSwitch, "开票限制不存在");

        //是否启用标识
        oldCategoryBillSwitch.setSwitchFlag(categoryBillSwitch.getSwitchFlag());

        //格式化时间为2018-07-06 00:00:00
        this.initVoucher(categoryBillSwitch);//添加的时候也需要这样格式化

        //对账开始时间
        oldCategoryBillSwitch.setStartTime(categoryBillSwitch.getStartTime());
        oldCategoryBillSwitch.setEndTime(categoryBillSwitch.getEndTime());

        //凭证时间
        oldCategoryBillSwitch.setVoucherStartTime(categoryBillSwitch.getVoucherStartTime());
        oldCategoryBillSwitch.setVoucherEndTime(categoryBillSwitch.getVoucherEndTime());

        //设置更新时间
        oldCategoryBillSwitch.setUpdateTime(new Date());

        //主要考虑凭证时间有空的情况
        this.billInvorker.getCategoryBillSwitchService().updateByPrimaryKey(oldCategoryBillSwitch);

        return oldCategoryBillSwitch;
    }


    /**
     * 初始化一下这个时间到天数
     *
     * @param categoryBillSwitch
     */
    private void initVoucher(CategoryBillSwitch categoryBillSwitch) {
        if (categoryBillSwitch.getVoucherStartTime() != null) {
            Date start = DateUtils.truncate(categoryBillSwitch.getVoucherStartTime(), Calendar.DATE);
            categoryBillSwitch.setVoucherStartTime(start);
        }
        if (categoryBillSwitch.getVoucherEndTime() != null) {
            Date end = DateUtils.truncate(categoryBillSwitch.getVoucherEndTime(), Calendar.DATE);
            categoryBillSwitch.setVoucherEndTime(end);
        }
    }

    private void check(CategoryBillSwitch categoryBillSwitch) {
        Assert.isNotNull(categoryBillSwitch, "对账限制设置信息不能为空！");
        Assert.isNotBlank(categoryBillSwitch.getId(), "对账限制设置信息ID不能为空！");

        Assert.isNotNull(categoryBillSwitch.getStartTime(), "对账开始不能为空！");
        Assert.isNotNull(categoryBillSwitch.getEndTime(), "对账结束时间不能为空！");

        //注意凭证时间是允许为空，但是填了，必须得设置一对数字
        //凭证时间设置：如果填了一个，那么相对应也要填另外一个
        if (categoryBillSwitch.getVoucherStartTime() != null) {
            Assert.isNotNull(categoryBillSwitch.getVoucherEndTime(), "凭证结束时间不能为空！");
        }
        if (categoryBillSwitch.getVoucherEndTime() != null) {
            Assert.isNotNull(categoryBillSwitch.getVoucherStartTime(), "凭证开始时间不能为空！");
        }

    }
}
