package com.els.base.categoryswitch.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.categoryswitch.command.CreateCommand;
import com.els.base.categoryswitch.command.DeleteCommand;
import com.els.base.categoryswitch.command.UpdateCommand;
import com.els.base.categoryswitch.entity.CategoryBillSwitch;
import com.els.base.categoryswitch.entity.CategoryBillSwitchExample;
import com.els.base.categoryswitch.service.CategoryBillSwitchService;
import com.els.base.common.BillInvorker;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

@Api(value = "采购结算管理-开票开关")
@Controller
@RequestMapping("categoryBillSwitch")
public class CategoryBillSwitchController {
    @Resource
    protected CategoryBillSwitchService categoryBillSwitchService;
    @Resource
    private BillInvorker invoker;

    @ApiOperation(httpMethod = "POST", value = "创建采购结算管理-开票开关")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CategoryBillSwitch categoryBillSwitch) {
        CreateCommand cmd = new CreateCommand(categoryBillSwitch);
        cmd.setProject(ProjectUtils.getProject());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑采购结算管理-开票开关")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CategoryBillSwitch categoryBillSwitch) {
        UpdateCommand cmd = new UpdateCommand(categoryBillSwitch);
        cmd.setProject(ProjectUtils.getProject());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除采购结算管理-开票开关")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        DeleteCommand cmd = new DeleteCommand(Arrays.asList(id));
        cmd.setProject(ProjectUtils.getProject());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除采购结算管理-开票开关")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required = true) List<String> ids) {
        DeleteCommand cmd = new DeleteCommand(ids);
        cmd.setProject(ProjectUtils.getProject());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询采购结算管理-开票开关")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 CategoryBillSwitch", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<CategoryBillSwitch>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        CategoryBillSwitchExample example = new CategoryBillSwitchExample();
        example.setPageView(new PageView<CategoryBillSwitch>(pageNo, pageSize));

        CategoryBillSwitchExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        criteria.andIsEnableEqualTo(Constant.YES_INT).andPurCompanyIdEqualTo(ProjectUtils.getCompanyId());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<CategoryBillSwitch> pageData = this.categoryBillSwitchService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}