package com.els.base.categoryswitch.service.impl;

import com.els.base.billswitch.service.BillSwitchService;
import com.els.base.categoryswitch.dao.CategoryBillSwitchMapper;
import com.els.base.categoryswitch.entity.CategoryBillSwitch;
import com.els.base.categoryswitch.entity.CategoryBillSwitchExample;
import com.els.base.categoryswitch.service.CategoryBillSwitchService;
import com.els.base.core.entity.PageView;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

@Service("defaultCategoryBillSwitchService")
public class CategoryBillSwitchServiceImpl implements CategoryBillSwitchService {
    @Resource
    protected CategoryBillSwitchMapper categoryBillSwitchMapper;
    @Resource
    protected BillSwitchService billSwitchService;

    @CacheEvict(value = {"categoryBillSwitch"}, allEntries = true)
    @Transactional
    @Override
    public int updateByPrimaryKey(CategoryBillSwitch record) {
        return this.categoryBillSwitchMapper.updateByPrimaryKey(record);
    }

    @CacheEvict(value = {"categoryBillSwitch"}, allEntries = true)
    @Transactional
    @Override
    public int insert(CategoryBillSwitch record) {
        return this.categoryBillSwitchMapper.insert(record);
    }

    @Cacheable(value = "categoryBillSwitch", keyGenerator = "redisKeyGenerator")
    @Override
    public int countByExample(CategoryBillSwitchExample example) {
        return this.categoryBillSwitchMapper.countByExample(example);
    }

    @CacheEvict(value = {"categoryBillSwitch"}, allEntries = true)
    @Transactional
    @Override
    public int updateByExampleSelective(CategoryBillSwitch record, CategoryBillSwitchExample example) {
        return this.categoryBillSwitchMapper.updateByExampleSelective(record, example);
    }

    @CacheEvict(value = {"categoryBillSwitch"}, allEntries = true)
    @Transactional
    @Override
    public void deleteByExample(CategoryBillSwitchExample example) {
        int i = categoryBillSwitchMapper.countByExample(example);
        if (i > 0) {
            categoryBillSwitchMapper.deleteByExample(example);
        }
    }

    @CacheEvict(value = {"categoryBillSwitch"}, allEntries = true)
    @Override
    public void addObj(CategoryBillSwitch t) {
        this.categoryBillSwitchMapper.insertSelective(t);
    }

    @CacheEvict(value = {"categoryBillSwitch"}, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.categoryBillSwitchMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = {"categoryBillSwitch"}, allEntries = true)
    @Override
    public void modifyObj(CategoryBillSwitch t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.categoryBillSwitchMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "categoryBillSwitch", keyGenerator = "redisKeyGenerator")
    @Override
    public CategoryBillSwitch queryObjById(String id) {
        return this.categoryBillSwitchMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "categoryBillSwitch", keyGenerator = "redisKeyGenerator")
    @Override
    public List<CategoryBillSwitch> queryAllObjByExample(CategoryBillSwitchExample example) {
        return this.categoryBillSwitchMapper.selectByExample(example);
    }

    @Cacheable(value = "categoryBillSwitch", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<CategoryBillSwitch> queryObjByPage(CategoryBillSwitchExample example) {
        PageView<CategoryBillSwitch> pageView = example.getPageView();
        pageView.setQueryResult(this.categoryBillSwitchMapper.selectByExampleByPage(example));
        return pageView;
    }
}