package com.els.base.common;

import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;

/**
 * @author liuhf
 */
public abstract class AbstractBillCommand<Result> {

    private Company purCompany;
    private User purUser;

    private Company supCompany;
    private User supUser;

    private Project project;

    protected BillInvorker billInvorker;

    public abstract Result execute(BillInvorker billInvorker);

    public void cpoyFromCmd(AbstractBillCommand cmd) {
        this.setPurCompany(cmd.getPurCompany());
        this.setPurUser(cmd.getPurUser());
        this.setSupCompany(cmd.getSupCompany());
        this.setSupUser(cmd.getSupUser());
        this.setProject(cmd.getProject());
    }

    public Company getPurCompany() {
        return purCompany;
    }

    public void setPurCompany(Company purCompany) {
        this.purCompany = purCompany;
    }

    public User getPurUser() {
        return purUser;
    }

    public void setPurUser(User purUser) {
        this.purUser = purUser;
    }

    public Company getSupCompany() {
        return supCompany;
    }

    public void setSupCompany(Company supCompany) {
        this.supCompany = supCompany;
    }

    public User getSupUser() {
        return supUser;
    }

    public void setSupUser(User supUser) {
        this.supUser = supUser;
    }

    public Project getProject() {
        return project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public BillInvorker getBillInvorker() {
        return billInvorker;
    }

    public void setBillInvorker(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;
    }
}
