package com.els.base.common;

import com.els.base.bill.service.BillItemService;
import com.els.base.bill.service.BillService;
import com.els.base.billswitch.service.BillSwitchService;
import com.els.base.category.service.CompanyCategoryService;
import com.els.base.categoryref.service.CompanyCategoryRefService;
import com.els.base.categoryswitch.service.CategoryBillSwitchService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.invoice.service.BillInvoiceService;
import com.els.base.rebate.service.BillInvoiceRebateService;
import com.els.base.voucher.service.BillVoucherService;
import com.els.base.workflow.common.service.WorkFlowService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

@Component
public class BillInvorker {

    private static Logger logger = LoggerFactory.getLogger(BillInvorker.class);
    @Resource
    private GenerateCodeService generateCodeService;
    @Resource
    private WorkFlowService workFlowService;
    @Resource
    private CompanyService companyService;
    @Resource
    private BillVoucherService billVoucherService;
    @Resource
    private BillService billService;
    @Resource
    private BillItemService billItemService;
    @Resource
    private BillSwitchService billSwitchService;
    @Resource
    private BillInvoiceService billInvoiceService;
    @Resource
    private BillInvoiceRebateService billInvoiceRebateService;
    @Resource
    private CompanyCategoryService companyCategoryService;
    @Resource
    private CompanyCategoryRefService companyCategoryRefService;
    @Resource
    private CategoryBillSwitchService categoryBillSwitchService;
    @Resource
    private CompanyUserRefService companyUserRefService;

    @Transactional
    public <Result> Result invoke(AbstractBillCommand<Result> command) {
        logger.debug("执行命令[{}]", command.getClass().getName());

        // 此处可添加执行前的统一操作
        // 例如身份认证
        command.setBillInvorker(this);

        Result result = command.execute(this);

        // TODO 此处可添加执行后的操作
        // 例如消息发送

        return result;
    }

    public GenerateCodeService getGenerateCodeService() {
        return generateCodeService;
    }

    public void setGenerateCodeService(GenerateCodeService generateCodeService) {
        this.generateCodeService = generateCodeService;
    }

    public WorkFlowService getWorkFlowService() {
        return workFlowService;
    }

    public void setWorkFlowService(WorkFlowService workFlowService) {
        this.workFlowService = workFlowService;
    }

    public CompanyService getCompanyService() {
        return companyService;
    }

    public void setCompanyService(CompanyService companyService) {
        this.companyService = companyService;
    }

    public BillVoucherService getBillVoucherService() {
        return billVoucherService;
    }

    public void setBillVoucherService(BillVoucherService billVoucherService) {
        this.billVoucherService = billVoucherService;
    }

    public BillService getBillService() {
        return billService;
    }

    public void setBillService(BillService billService) {
        this.billService = billService;
    }

    public BillItemService getBillItemService() {
        return billItemService;
    }

    public void setBillItemService(BillItemService billItemService) {
        this.billItemService = billItemService;
    }

    public BillSwitchService getBillSwitchService() {
        return billSwitchService;
    }

    public void setBillSwitchService(BillSwitchService billSwitchService) {
        this.billSwitchService = billSwitchService;
    }

    public BillInvoiceService getBillInvoiceService() {
        return billInvoiceService;
    }

    public void setBillInvoiceService(BillInvoiceService billInvoiceService) {
        this.billInvoiceService = billInvoiceService;
    }

    public BillInvoiceRebateService getBillInvoiceRebateService() {
        return billInvoiceRebateService;
    }

    public void setBillInvoiceRebateService(BillInvoiceRebateService billInvoiceRebateService) {
        this.billInvoiceRebateService = billInvoiceRebateService;
    }

    public CompanyCategoryService getCompanyCategoryService() {
        return companyCategoryService;
    }

    public void setCompanyCategoryService(CompanyCategoryService companyCategoryService) {
        this.companyCategoryService = companyCategoryService;
    }

    public CompanyCategoryRefService getCompanyCategoryRefService() {
        return companyCategoryRefService;
    }

    public void setCompanyCategoryRefService(CompanyCategoryRefService companyCategoryRefService) {
        this.companyCategoryRefService = companyCategoryRefService;
    }

    public CategoryBillSwitchService getCategoryBillSwitchService() {
        return categoryBillSwitchService;
    }

    public void setCategoryBillSwitchService(CategoryBillSwitchService categoryBillSwitchService) {
        this.categoryBillSwitchService = categoryBillSwitchService;
    }

    public CompanyUserRefService getCompanyUserRefService() {
        return companyUserRefService;
    }

    public void setCompanyUserRefService(CompanyUserRefService companyUserRefService) {
        this.companyUserRefService = companyUserRefService;
    }
}
