package com.els.base.invoice.command;

import com.els.base.bill.entity.BillItem;
import com.els.base.bill.entity.BillItemExample;
import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.invoice.entity.BillInvoice;
import com.els.base.invoice.entity.BillInvoiceExample;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * 发票删除
 * @author liuhf
 */
public class DeleteCommand extends AbstractBillCommand<String> {

    Logger logger = LoggerFactory.getLogger(this.getClass());

    private List<String> ids;

    public DeleteCommand() {
    }

    public DeleteCommand(List<String> ids) {
        this.ids = ids;
    }

    @Override
    public String execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;

        //创建之前需要检查
        this.validate(ids);

        this.processor(ids);

        return null;
    }

    private void processor(List<String> ids) {
        BillInvoiceExample billInvoiceExample = new BillInvoiceExample();
        billInvoiceExample.createCriteria().andIdIn(ids);
        List<BillInvoice> billInvoices = this.billInvorker.getBillInvoiceService().queryAllObjByExample(billInvoiceExample);
        Assert.isNotEmpty(billInvoices, "发票信息不存在");

        for (BillInvoice billInvoice : billInvoices) {
            //删除之前需要释放资源
            this.updateBillItemForInvoiceDelete(billInvoice, Constant.NO_INT);
            //删除折让汇总
            this.billInvorker.getBillInvoiceRebateService().deleteInvoiceRebate(billInvoice);
        }
        //删除发票信息
        this.billInvorker.getBillInvoiceService().deleteByExample(billInvoiceExample);
    }


    /**
     * 校验数据
     */
    private void validate(List<String> ids) {
        Assert.isNotEmpty(ids,"请选择需要操作的数据！");
        for (String id : ids) {
            Assert.isNotBlank(id, "发票ID不能为空！");
        }
    }

    /**
     * 更新开票清单行状态
     */
    private void updateBillItemForInvoiceDelete(BillInvoice billInvoice, Integer flag) {
        Assert.isNotNull(billInvoice, "发票信息不能为空！");
        Assert.isNotBlank(billInvoice.getId(), "发票ID不能为空！");

        BillItemExample billItemExample = new BillItemExample();
        billItemExample.createCriteria()
                .andBillInvoiceIdEqualTo(billInvoice.getId())
                .andIsEnableEqualTo(Constant.YES_INT);
        List<BillItem> billItems = this.billInvorker.getBillItemService().queryAllObjByExample(billItemExample);
        if (CollectionUtils.isEmpty(billItems)) {
            return;
        }
        for (BillItem billItem : billItems) {
            billItem.setBillInvoiceId(billInvoice.getId());
            billItem.setBillInvoiceFlag(flag);
            this.billInvorker.getBillItemService().modifyObj(billItem);
        }
    }

}
