package com.els.base.invoice.command;

import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.invoice.entity.BillInvoice;
import com.els.base.invoice.entity.BillInvoiceExample;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 发票编辑
 * @author liuhf
 */
public class EditCommand extends AbstractBillCommand<BillInvoice> {

    Logger logger = LoggerFactory.getLogger(this.getClass());

    private BillInvoice billInvoice;

    public EditCommand() {
    }

    public EditCommand(BillInvoice billInvoice) {
        this.billInvoice = billInvoice;
    }

    @Override
    public BillInvoice execute(BillInvorker billInvorker) {
        this.billInvorker = billInvorker;

        //创建之前需要检查
        this.validate(billInvoice);

        this.processor(billInvoice);

        return null;
    }

    private void processor(BillInvoice billInvoice) {

        //编辑的时候不做修改
        BillInvoice old = this.billInvorker.getBillInvoiceService().queryObjById(billInvoice.getId());
        old.setId(old.getId());
        old.setInvoiceNo(billInvoice.getInvoiceNo());
        old.setInvoiceTime(billInvoice.getInvoiceTime());
        old.setInvoiceDistribution(billInvoice.getInvoiceDistribution());
        old.setInvoiceText(billInvoice.getInvoiceText());
        old.setInvoiceTitle(billInvoice.getInvoiceTitle());

        //编辑发票信息
        this.billInvorker.getBillInvoiceService().modifyObj(old);

    }


    /**
     * 校验数据
     *
     * @param billInvoice
     */
    private void validate(BillInvoice billInvoice) {

        Assert.isNotNull(billInvoice, "发票信息不能为空！");
        Assert.isNotBlank(billInvoice.getId(), "发票ID不能为空！");
        Assert.isNotNull(billInvoice.getBillId(), "开票清单ID不能为空！");
        Assert.isNotBlank(billInvoice.getInvoiceNo(), "发票编码不能为空！");
        Assert.isNotNull(billInvoice.getInvoiceTime(), "发票日期不能为空！");

        //校验发票编码
        int length = StringUtils.trim(billInvoice.getInvoiceNo()).length();
        if (length > 18) {
            throw new CommonException("发票编码不能超过18个字符，请检查！");
        }

        BillInvoiceExample billInvoiceExample = new BillInvoiceExample();
        billInvoiceExample.createCriteria()
                .andInvoiceNoEqualTo(billInvoice.getInvoiceNo())
                .andInvoiceFlagEqualTo(Constant.YES_INT)
                .andIdNotEqualTo(billInvoice.getId());

        int i = this.billInvorker.getBillInvoiceService().countByExample(billInvoiceExample);
        if (i > 0) {
            throw new CommonException("发票号已经存在了，请检查！");
        }
    }

}
