package com.els.base.invoice.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bill.service.BillItemService;
import com.els.base.common.BillInvorker;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.invoice.command.CreateCommand;
import com.els.base.invoice.command.DeleteCommand;
import com.els.base.invoice.command.EditCommand;
import com.els.base.invoice.entity.BillInvoice;
import com.els.base.invoice.entity.BillInvoiceExample;
import com.els.base.invoice.service.BillInvoiceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

@Api(value = "采购结算管理-预制发票")
@Controller
@RequestMapping("billInvoice")
public class BillInvoiceController {
    @Resource
    protected BillInvoiceService billInvoiceService;
    @Resource
    protected BillItemService billItemService;
    @Resource
    private BillInvorker invoker;

    @ApiOperation(httpMethod = "POST", value = "创建采购结算管理-预制发票")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BillInvoice billInvoice) {
        CreateCommand cmd = new CreateCommand(billInvoice);
        cmd.setSupCompany(CompanyUtils.currentCompany());
        cmd.setSupUser(SpringSecurityUtils.getLoginUser());
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑采购结算管理-预制发票")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BillInvoice billInvoice) {
        EditCommand cmd = new EditCommand(billInvoice);
        cmd.setSupCompany(CompanyUtils.currentCompany());
        cmd.setSupUser(SpringSecurityUtils.getLoginUser());
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除采购结算管理-预制发票")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        DeleteCommand cmd = new DeleteCommand(Arrays.asList(id));
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "删除采购结算管理-预制发票")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required = true) List<String> ids) {
        DeleteCommand cmd = new DeleteCommand(ids);
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "查询采购结算管理-预制发票")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 BillInvoice", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<BillInvoice>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        BillInvoiceExample example = new BillInvoiceExample();
        example.setPageView(new PageView<BillInvoice>(pageNo, pageSize));

        BillInvoiceExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView<BillInvoice> pageData = this.billInvoiceService.queryObjByPage(example);
        //pageData.setQueryResult(this.queryList(pageData.getQueryResult()));
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "查询采购结算管理-查询全部预制发票")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 BillInvoice", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findAll")
    @ResponseBody
    public ResponseResult<List<BillInvoice>> findAll(
            @RequestBody(required = false) QueryParamWapper wapper) {
        BillInvoiceExample example = new BillInvoiceExample();

        BillInvoiceExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        List<BillInvoice> billInvoices = this.billInvoiceService.queryAllObjByExample(example);
        //this.queryList(billInvoices)
        return ResponseResult.success(billInvoices);
    }

    /*private List<BillInvoice> queryList(List<BillInvoice> billInvoices) {
        List<BillInvoice> billInvoicesTemp = new ArrayList<>();
        if (CollectionUtils.isEmpty(billInvoices)) {
            return billInvoicesTemp;
        }
        for (BillInvoice billInvoice : billInvoices) {
            //查询入退库
            List<BillItem> billItems = this.billItemService.queryBillVoucherList(billInvoice.getId());
            billInvoice.setBillVoucherList(billItems);

            //查询折让单
            List<BillItem> billItems2 = this.billItemService.queryRebateVoucherList(billInvoice.getId());
            billInvoice.setRebateVoucherList(billItems2);

            billInvoicesTemp.add(billInvoice);
        }
        return billInvoicesTemp;
    }*/
}