package com.els.base.invoice.entity;

import com.els.base.bill.entity.BillItem;
import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.els.base.rebate.entity.BillInvoiceRebate;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ApiModel(value="采购结算管理-预制发票")
public class BillInvoice implements Serializable {

    //--------非自动生成，请勿覆盖 --------------

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

    @ApiModelProperty("预制发票对应的开票凭证行")
    List<BillItem> billVoucherList=new ArrayList<>();

    @ApiModelProperty("预制发票对应的开票折让单行")
    List<BillItem> rebateVoucherList=new ArrayList<>();

    @ApiModelProperty("预制发票对应的折让汇总行")
    List<BillInvoiceRebate> billInvoiceRebateList =new ArrayList<>();

    public List<BillInvoiceRebate> getBillInvoiceRebateList() {
        return billInvoiceRebateList;
    }

    public void setBillInvoiceRebateList(List<BillInvoiceRebate> billInvoiceRebateList) {
        this.billInvoiceRebateList = billInvoiceRebateList;
    }

    public List<BillItem> getBillVoucherList() {
        return billVoucherList;
    }

    public void setBillVoucherList(List<BillItem> billVoucherList) {
        this.billVoucherList = billVoucherList;
    }

    public List<BillItem> getRebateVoucherList() {
        return rebateVoucherList;
    }

    public void setRebateVoucherList(List<BillItem> rebateVoucherList) {
        this.rebateVoucherList = rebateVoucherList;
    }

    //----------------------------------------

    @ApiModelProperty("主键ID")
    private String id;

    @ApiModelProperty("对账清ID")
    private String billId;

    @ApiModelProperty("对账清单号")
    private String billNo;

    @ApiModelProperty("货币类型")
    private String currencyType;

    @ApiModelProperty("表创建时间")
    private Date createTime;

    @ApiModelProperty("表更新时间")
    private Date updateTime;

    @ApiModelProperty("分配")
    private String invoiceDistribution;

    @ApiModelProperty("发票号")
    private String invoiceNo;

    @ApiModelProperty("发票日期")
    private Date invoiceTime;

    @ApiModelProperty("抬头文本")
    private String invoiceTitle;

    @ApiModelProperty("文本")
    private String invoiceText;

    @ApiModelProperty("发票图片")
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    private String invoiceImg;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("开票含税税额")
    private BigDecimal includeTaxAmount;

    @ApiModelProperty("开票未税金额")
    private BigDecimal notIncludeTaxAmount;

    @ApiModelProperty("开票税额")
    private BigDecimal taxAmount;

    @ApiModelProperty("对账总金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("扣款总金额")
    private BigDecimal deductionAmount;

    @ApiModelProperty("过账日期")
    private Date postingTime;

    @ApiModelProperty("SAP系统传过来的发票流水号（用于开票有问题的时候方便对应查询）")
    private String sapInvoiceNo;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("发票标识符，是否可用")
    private Integer invoiceFlag;

    @ApiModelProperty("是否是折让单(0=不是折让单，1=折让单)")
    private Integer isRebate;

    @ApiModelProperty("折让不含税金额")
    private BigDecimal rebateNotIncludeTaxAmount;

    @ApiModelProperty("折让含税金额")
    private BigDecimal rebateIncludeTaxAmount;

    @ApiModelProperty("折让税额")
    private BigDecimal rebateTaxAmount;

    @ApiModelProperty("移动类型对应的符号")
    private String billTypeSign;

    @ApiModelProperty("是否回签")
    private Integer invoiceSignFlag;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getBillId() {
        return billId;
    }

    public void setBillId(String billId) {
        this.billId = billId == null ? null : billId.trim();
    }

    public String getBillNo() {
        return billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo == null ? null : billNo.trim();
    }

    public String getCurrencyType() {
        return currencyType;
    }

    public void setCurrencyType(String currencyType) {
        this.currencyType = currencyType == null ? null : currencyType.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getInvoiceDistribution() {
        return invoiceDistribution;
    }

    public void setInvoiceDistribution(String invoiceDistribution) {
        this.invoiceDistribution = invoiceDistribution == null ? null : invoiceDistribution.trim();
    }

    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo == null ? null : invoiceNo.trim();
    }

    public Date getInvoiceTime() {
        return invoiceTime;
    }

    public void setInvoiceTime(Date invoiceTime) {
        this.invoiceTime = invoiceTime;
    }

    public String getInvoiceTitle() {
        return invoiceTitle;
    }

    public void setInvoiceTitle(String invoiceTitle) {
        this.invoiceTitle = invoiceTitle == null ? null : invoiceTitle.trim();
    }

    public String getInvoiceText() {
        return invoiceText;
    }

    public void setInvoiceText(String invoiceText) {
        this.invoiceText = invoiceText == null ? null : invoiceText.trim();
    }

    public String getInvoiceImg() {
        return invoiceImg;
    }

    public void setInvoiceImg(String invoiceImg) {
        this.invoiceImg = invoiceImg == null ? null : invoiceImg.trim();
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getIncludeTaxAmount() {
        return includeTaxAmount;
    }

    public void setIncludeTaxAmount(BigDecimal includeTaxAmount) {
        this.includeTaxAmount = includeTaxAmount;
    }

    public BigDecimal getNotIncludeTaxAmount() {
        return notIncludeTaxAmount;
    }

    public void setNotIncludeTaxAmount(BigDecimal notIncludeTaxAmount) {
        this.notIncludeTaxAmount = notIncludeTaxAmount;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getDeductionAmount() {
        return deductionAmount;
    }

    public void setDeductionAmount(BigDecimal deductionAmount) {
        this.deductionAmount = deductionAmount;
    }

    public Date getPostingTime() {
        return postingTime;
    }

    public void setPostingTime(Date postingTime) {
        this.postingTime = postingTime;
    }

    public String getSapInvoiceNo() {
        return sapInvoiceNo;
    }

    public void setSapInvoiceNo(String sapInvoiceNo) {
        this.sapInvoiceNo = sapInvoiceNo == null ? null : sapInvoiceNo.trim();
    }

    public String getTaxCode() {
        return taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode == null ? null : taxCode.trim();
    }

    public Integer getInvoiceFlag() {
        return invoiceFlag;
    }

    public void setInvoiceFlag(Integer invoiceFlag) {
        this.invoiceFlag = invoiceFlag;
    }

    public Integer getIsRebate() {
        return isRebate;
    }

    public void setIsRebate(Integer isRebate) {
        this.isRebate = isRebate;
    }

    public BigDecimal getRebateNotIncludeTaxAmount() {
        return rebateNotIncludeTaxAmount;
    }

    public void setRebateNotIncludeTaxAmount(BigDecimal rebateNotIncludeTaxAmount) {
        this.rebateNotIncludeTaxAmount = rebateNotIncludeTaxAmount;
    }

    public BigDecimal getRebateIncludeTaxAmount() {
        return rebateIncludeTaxAmount;
    }

    public void setRebateIncludeTaxAmount(BigDecimal rebateIncludeTaxAmount) {
        this.rebateIncludeTaxAmount = rebateIncludeTaxAmount;
    }

    public BigDecimal getRebateTaxAmount() {
        return rebateTaxAmount;
    }

    public void setRebateTaxAmount(BigDecimal rebateTaxAmount) {
        this.rebateTaxAmount = rebateTaxAmount;
    }

    public String getBillTypeSign() {
        return billTypeSign;
    }

    public void setBillTypeSign(String billTypeSign) {
        this.billTypeSign = billTypeSign == null ? null : billTypeSign.trim();
    }

    public Integer getInvoiceSignFlag() {
        return invoiceSignFlag;
    }

    public void setInvoiceSignFlag(Integer invoiceSignFlag) {
        this.invoiceSignFlag = invoiceSignFlag;
    }
}