package com.els.base.invoice.entity;

import com.els.base.core.entity.AbstractExample;
import com.els.base.core.entity.PageView;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BillInvoiceExample extends AbstractExample<BillInvoice> implements Serializable {
    protected String orderByClause;

    protected boolean distinct;

    protected List<Criteria> oredCriteria;

    protected PageView<BillInvoice> pageView = new PageView<BillInvoice>(1, 10);

    private static final long serialVersionUID = 1L;

    public BillInvoiceExample() {
        oredCriteria = new ArrayList<Criteria>();
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getOrderByClause() {
        return orderByClause;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return distinct;
    }

    public List<Criteria> getOredCriteria() {
        return oredCriteria;
    }

    public void or(Criteria criteria) {
        oredCriteria.add(criteria);
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria();
        return criteria;
    }

    public void clear() {
        oredCriteria.clear();
        orderByClause = null;
        distinct = false;
    }

    @Override
    public PageView<BillInvoice> getPageView() {
        return pageView;
    }

    @Override
    public void setPageView(PageView<BillInvoice> pageView) {
        this.pageView = pageView;
    }

    protected abstract static class GeneratedCriteria implements Serializable {
        protected List<Criterion> criteria;

        private static final long serialVersionUID = 1L;

        protected GeneratedCriteria() {
            super();
            criteria = new ArrayList<Criterion>();
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public List<Criterion> getCriteria() {
            return criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        public Criteria andIdIsNull() {
            addCriterion("ID is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("ID is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(String value) {
            addCriterion("ID =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(String value) {
            addCriterion("ID <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(String value) {
            addCriterion("ID >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(String value) {
            addCriterion("ID >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(String value) {
            addCriterion("ID <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(String value) {
            addCriterion("ID <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLike(String value) {
            addCriterion("ID like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotLike(String value) {
            addCriterion("ID not like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<String> values) {
            addCriterion("ID in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<String> values) {
            addCriterion("ID not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(String value1, String value2) {
            addCriterion("ID between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(String value1, String value2) {
            addCriterion("ID not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andBillIdIsNull() {
            addCriterion("BILL_ID is null");
            return (Criteria) this;
        }

        public Criteria andBillIdIsNotNull() {
            addCriterion("BILL_ID is not null");
            return (Criteria) this;
        }

        public Criteria andBillIdEqualTo(String value) {
            addCriterion("BILL_ID =", value, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdNotEqualTo(String value) {
            addCriterion("BILL_ID <>", value, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdGreaterThan(String value) {
            addCriterion("BILL_ID >", value, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdGreaterThanOrEqualTo(String value) {
            addCriterion("BILL_ID >=", value, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdLessThan(String value) {
            addCriterion("BILL_ID <", value, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdLessThanOrEqualTo(String value) {
            addCriterion("BILL_ID <=", value, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdLike(String value) {
            addCriterion("BILL_ID like", value, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdNotLike(String value) {
            addCriterion("BILL_ID not like", value, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdIn(List<String> values) {
            addCriterion("BILL_ID in", values, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdNotIn(List<String> values) {
            addCriterion("BILL_ID not in", values, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdBetween(String value1, String value2) {
            addCriterion("BILL_ID between", value1, value2, "billId");
            return (Criteria) this;
        }

        public Criteria andBillIdNotBetween(String value1, String value2) {
            addCriterion("BILL_ID not between", value1, value2, "billId");
            return (Criteria) this;
        }

        public Criteria andBillNoIsNull() {
            addCriterion("BILL_NO is null");
            return (Criteria) this;
        }

        public Criteria andBillNoIsNotNull() {
            addCriterion("BILL_NO is not null");
            return (Criteria) this;
        }

        public Criteria andBillNoEqualTo(String value) {
            addCriterion("BILL_NO =", value, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoNotEqualTo(String value) {
            addCriterion("BILL_NO <>", value, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoGreaterThan(String value) {
            addCriterion("BILL_NO >", value, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoGreaterThanOrEqualTo(String value) {
            addCriterion("BILL_NO >=", value, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoLessThan(String value) {
            addCriterion("BILL_NO <", value, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoLessThanOrEqualTo(String value) {
            addCriterion("BILL_NO <=", value, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoLike(String value) {
            addCriterion("BILL_NO like", value, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoNotLike(String value) {
            addCriterion("BILL_NO not like", value, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoIn(List<String> values) {
            addCriterion("BILL_NO in", values, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoNotIn(List<String> values) {
            addCriterion("BILL_NO not in", values, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoBetween(String value1, String value2) {
            addCriterion("BILL_NO between", value1, value2, "billNo");
            return (Criteria) this;
        }

        public Criteria andBillNoNotBetween(String value1, String value2) {
            addCriterion("BILL_NO not between", value1, value2, "billNo");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeIsNull() {
            addCriterion("CURRENCY_TYPE is null");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeIsNotNull() {
            addCriterion("CURRENCY_TYPE is not null");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeEqualTo(String value) {
            addCriterion("CURRENCY_TYPE =", value, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeNotEqualTo(String value) {
            addCriterion("CURRENCY_TYPE <>", value, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeGreaterThan(String value) {
            addCriterion("CURRENCY_TYPE >", value, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeGreaterThanOrEqualTo(String value) {
            addCriterion("CURRENCY_TYPE >=", value, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeLessThan(String value) {
            addCriterion("CURRENCY_TYPE <", value, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeLessThanOrEqualTo(String value) {
            addCriterion("CURRENCY_TYPE <=", value, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeLike(String value) {
            addCriterion("CURRENCY_TYPE like", value, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeNotLike(String value) {
            addCriterion("CURRENCY_TYPE not like", value, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeIn(List<String> values) {
            addCriterion("CURRENCY_TYPE in", values, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeNotIn(List<String> values) {
            addCriterion("CURRENCY_TYPE not in", values, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeBetween(String value1, String value2) {
            addCriterion("CURRENCY_TYPE between", value1, value2, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCurrencyTypeNotBetween(String value1, String value2) {
            addCriterion("CURRENCY_TYPE not between", value1, value2, "currencyType");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("CREATE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("CREATE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("CREATE_TIME =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("CREATE_TIME <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("CREATE_TIME >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("CREATE_TIME <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("CREATE_TIME in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("CREATE_TIME not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIsNull() {
            addCriterion("UPDATE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIsNotNull() {
            addCriterion("UPDATE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeEqualTo(Date value) {
            addCriterion("UPDATE_TIME =", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotEqualTo(Date value) {
            addCriterion("UPDATE_TIME <>", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeGreaterThan(Date value) {
            addCriterion("UPDATE_TIME >", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("UPDATE_TIME >=", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeLessThan(Date value) {
            addCriterion("UPDATE_TIME <", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeLessThanOrEqualTo(Date value) {
            addCriterion("UPDATE_TIME <=", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIn(List<Date> values) {
            addCriterion("UPDATE_TIME in", values, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotIn(List<Date> values) {
            addCriterion("UPDATE_TIME not in", values, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeBetween(Date value1, Date value2) {
            addCriterion("UPDATE_TIME between", value1, value2, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotBetween(Date value1, Date value2) {
            addCriterion("UPDATE_TIME not between", value1, value2, "updateTime");
            return (Criteria) this;
        }

        public Criteria andInvoiceDistributionIsNull() {
            addCriterion("INVOICE_DISTRIBUTION is null");
            return (Criteria) this;
        }

        public Criteria andInvoiceDistributionIsNotNull() {
            addCriterion("INVOICE_DISTRIBUTION is not null");
            return (Criteria) this;
        }

        public Criteria andInvoiceDistributionEqualTo(String value) {
            addCriterion("INVOICE_DISTRIBUTION =", value, "invoiceDistribution");
            return (Criteria) this;
        }

        public Criteria andInvoiceDistributionNotEqualTo(String value) {
            addCriterion("INVOICE_DISTRIBUTION <>", value, "invoiceDistribution");
            return (Criteria) this;
        }

        public Criteria andInvoiceDistributionGreaterThan(String value) {
            addCriterion("INVOICE_DISTRIBUTION >", value, "invoiceDistribution");
            return (Criteria) this;
        }

        public Criteria andInvoiceDistributionGreaterThanOrEqualTo(String value) {
            addCriterion("INVOICE_DISTRIBUTION >=", value, "invoiceDistribution");
            return (Criteria) this;
        }

        public Criteria andInvoiceDistributionLessThan(String value) {
            addCriterion("INVOICE_DISTRIBUTION <", value, "invoiceDistribution");
            return (Criteria) this;
        }

        public Criteria andInvoiceDistributionLessThanOrEqualTo(String value) {
            addCriterion("INVOICE_DISTRIBUTION <=", value, "invoiceDistribution");
            return (Criteria) this;
        }

        public Criteria andInvoiceDistributionLike(String value) {
            addCriterion("INVOICE_DISTRIBUTION like", value, "invoiceDistribution");
            return (Criteria) this;
        }

        public Criteria andInvoiceDistributionNotLike(String value) {
            addCriterion("INVOICE_DISTRIBUTION not like", value, "invoiceDistribution");
            return (Criteria) this;
        }

        public Criteria andInvoiceDistributionIn(List<String> values) {
            addCriterion("INVOICE_DISTRIBUTION in", values, "invoiceDistribution");
            return (Criteria) this;
        }

        public Criteria andInvoiceDistributionNotIn(List<String> values) {
            addCriterion("INVOICE_DISTRIBUTION not in", values, "invoiceDistribution");
            return (Criteria) this;
        }

        public Criteria andInvoiceDistributionBetween(String value1, String value2) {
            addCriterion("INVOICE_DISTRIBUTION between", value1, value2, "invoiceDistribution");
            return (Criteria) this;
        }

        public Criteria andInvoiceDistributionNotBetween(String value1, String value2) {
            addCriterion("INVOICE_DISTRIBUTION not between", value1, value2, "invoiceDistribution");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoIsNull() {
            addCriterion("INVOICE_NO is null");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoIsNotNull() {
            addCriterion("INVOICE_NO is not null");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoEqualTo(String value) {
            addCriterion("INVOICE_NO =", value, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoNotEqualTo(String value) {
            addCriterion("INVOICE_NO <>", value, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoGreaterThan(String value) {
            addCriterion("INVOICE_NO >", value, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoGreaterThanOrEqualTo(String value) {
            addCriterion("INVOICE_NO >=", value, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoLessThan(String value) {
            addCriterion("INVOICE_NO <", value, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoLessThanOrEqualTo(String value) {
            addCriterion("INVOICE_NO <=", value, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoLike(String value) {
            addCriterion("INVOICE_NO like", value, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoNotLike(String value) {
            addCriterion("INVOICE_NO not like", value, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoIn(List<String> values) {
            addCriterion("INVOICE_NO in", values, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoNotIn(List<String> values) {
            addCriterion("INVOICE_NO not in", values, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoBetween(String value1, String value2) {
            addCriterion("INVOICE_NO between", value1, value2, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoNotBetween(String value1, String value2) {
            addCriterion("INVOICE_NO not between", value1, value2, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceTimeIsNull() {
            addCriterion("INVOICE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andInvoiceTimeIsNotNull() {
            addCriterion("INVOICE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andInvoiceTimeEqualTo(Date value) {
            addCriterion("INVOICE_TIME =", value, "invoiceTime");
            return (Criteria) this;
        }

        public Criteria andInvoiceTimeNotEqualTo(Date value) {
            addCriterion("INVOICE_TIME <>", value, "invoiceTime");
            return (Criteria) this;
        }

        public Criteria andInvoiceTimeGreaterThan(Date value) {
            addCriterion("INVOICE_TIME >", value, "invoiceTime");
            return (Criteria) this;
        }

        public Criteria andInvoiceTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("INVOICE_TIME >=", value, "invoiceTime");
            return (Criteria) this;
        }

        public Criteria andInvoiceTimeLessThan(Date value) {
            addCriterion("INVOICE_TIME <", value, "invoiceTime");
            return (Criteria) this;
        }

        public Criteria andInvoiceTimeLessThanOrEqualTo(Date value) {
            addCriterion("INVOICE_TIME <=", value, "invoiceTime");
            return (Criteria) this;
        }

        public Criteria andInvoiceTimeIn(List<Date> values) {
            addCriterion("INVOICE_TIME in", values, "invoiceTime");
            return (Criteria) this;
        }

        public Criteria andInvoiceTimeNotIn(List<Date> values) {
            addCriterion("INVOICE_TIME not in", values, "invoiceTime");
            return (Criteria) this;
        }

        public Criteria andInvoiceTimeBetween(Date value1, Date value2) {
            addCriterion("INVOICE_TIME between", value1, value2, "invoiceTime");
            return (Criteria) this;
        }

        public Criteria andInvoiceTimeNotBetween(Date value1, Date value2) {
            addCriterion("INVOICE_TIME not between", value1, value2, "invoiceTime");
            return (Criteria) this;
        }

        public Criteria andInvoiceTitleIsNull() {
            addCriterion("INVOICE_TITLE is null");
            return (Criteria) this;
        }

        public Criteria andInvoiceTitleIsNotNull() {
            addCriterion("INVOICE_TITLE is not null");
            return (Criteria) this;
        }

        public Criteria andInvoiceTitleEqualTo(String value) {
            addCriterion("INVOICE_TITLE =", value, "invoiceTitle");
            return (Criteria) this;
        }

        public Criteria andInvoiceTitleNotEqualTo(String value) {
            addCriterion("INVOICE_TITLE <>", value, "invoiceTitle");
            return (Criteria) this;
        }

        public Criteria andInvoiceTitleGreaterThan(String value) {
            addCriterion("INVOICE_TITLE >", value, "invoiceTitle");
            return (Criteria) this;
        }

        public Criteria andInvoiceTitleGreaterThanOrEqualTo(String value) {
            addCriterion("INVOICE_TITLE >=", value, "invoiceTitle");
            return (Criteria) this;
        }

        public Criteria andInvoiceTitleLessThan(String value) {
            addCriterion("INVOICE_TITLE <", value, "invoiceTitle");
            return (Criteria) this;
        }

        public Criteria andInvoiceTitleLessThanOrEqualTo(String value) {
            addCriterion("INVOICE_TITLE <=", value, "invoiceTitle");
            return (Criteria) this;
        }

        public Criteria andInvoiceTitleLike(String value) {
            addCriterion("INVOICE_TITLE like", value, "invoiceTitle");
            return (Criteria) this;
        }

        public Criteria andInvoiceTitleNotLike(String value) {
            addCriterion("INVOICE_TITLE not like", value, "invoiceTitle");
            return (Criteria) this;
        }

        public Criteria andInvoiceTitleIn(List<String> values) {
            addCriterion("INVOICE_TITLE in", values, "invoiceTitle");
            return (Criteria) this;
        }

        public Criteria andInvoiceTitleNotIn(List<String> values) {
            addCriterion("INVOICE_TITLE not in", values, "invoiceTitle");
            return (Criteria) this;
        }

        public Criteria andInvoiceTitleBetween(String value1, String value2) {
            addCriterion("INVOICE_TITLE between", value1, value2, "invoiceTitle");
            return (Criteria) this;
        }

        public Criteria andInvoiceTitleNotBetween(String value1, String value2) {
            addCriterion("INVOICE_TITLE not between", value1, value2, "invoiceTitle");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextIsNull() {
            addCriterion("INVOICE_TEXT is null");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextIsNotNull() {
            addCriterion("INVOICE_TEXT is not null");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextEqualTo(String value) {
            addCriterion("INVOICE_TEXT =", value, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextNotEqualTo(String value) {
            addCriterion("INVOICE_TEXT <>", value, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextGreaterThan(String value) {
            addCriterion("INVOICE_TEXT >", value, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextGreaterThanOrEqualTo(String value) {
            addCriterion("INVOICE_TEXT >=", value, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextLessThan(String value) {
            addCriterion("INVOICE_TEXT <", value, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextLessThanOrEqualTo(String value) {
            addCriterion("INVOICE_TEXT <=", value, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextLike(String value) {
            addCriterion("INVOICE_TEXT like", value, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextNotLike(String value) {
            addCriterion("INVOICE_TEXT not like", value, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextIn(List<String> values) {
            addCriterion("INVOICE_TEXT in", values, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextNotIn(List<String> values) {
            addCriterion("INVOICE_TEXT not in", values, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextBetween(String value1, String value2) {
            addCriterion("INVOICE_TEXT between", value1, value2, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextNotBetween(String value1, String value2) {
            addCriterion("INVOICE_TEXT not between", value1, value2, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceImgIsNull() {
            addCriterion("INVOICE_IMG is null");
            return (Criteria) this;
        }

        public Criteria andInvoiceImgIsNotNull() {
            addCriterion("INVOICE_IMG is not null");
            return (Criteria) this;
        }

        public Criteria andInvoiceImgEqualTo(String value) {
            addCriterion("INVOICE_IMG =", value, "invoiceImg");
            return (Criteria) this;
        }

        public Criteria andInvoiceImgNotEqualTo(String value) {
            addCriterion("INVOICE_IMG <>", value, "invoiceImg");
            return (Criteria) this;
        }

        public Criteria andInvoiceImgGreaterThan(String value) {
            addCriterion("INVOICE_IMG >", value, "invoiceImg");
            return (Criteria) this;
        }

        public Criteria andInvoiceImgGreaterThanOrEqualTo(String value) {
            addCriterion("INVOICE_IMG >=", value, "invoiceImg");
            return (Criteria) this;
        }

        public Criteria andInvoiceImgLessThan(String value) {
            addCriterion("INVOICE_IMG <", value, "invoiceImg");
            return (Criteria) this;
        }

        public Criteria andInvoiceImgLessThanOrEqualTo(String value) {
            addCriterion("INVOICE_IMG <=", value, "invoiceImg");
            return (Criteria) this;
        }

        public Criteria andInvoiceImgLike(String value) {
            addCriterion("INVOICE_IMG like", value, "invoiceImg");
            return (Criteria) this;
        }

        public Criteria andInvoiceImgNotLike(String value) {
            addCriterion("INVOICE_IMG not like", value, "invoiceImg");
            return (Criteria) this;
        }

        public Criteria andInvoiceImgIn(List<String> values) {
            addCriterion("INVOICE_IMG in", values, "invoiceImg");
            return (Criteria) this;
        }

        public Criteria andInvoiceImgNotIn(List<String> values) {
            addCriterion("INVOICE_IMG not in", values, "invoiceImg");
            return (Criteria) this;
        }

        public Criteria andInvoiceImgBetween(String value1, String value2) {
            addCriterion("INVOICE_IMG between", value1, value2, "invoiceImg");
            return (Criteria) this;
        }

        public Criteria andInvoiceImgNotBetween(String value1, String value2) {
            addCriterion("INVOICE_IMG not between", value1, value2, "invoiceImg");
            return (Criteria) this;
        }

        public Criteria andTaxRateIsNull() {
            addCriterion("TAX_RATE is null");
            return (Criteria) this;
        }

        public Criteria andTaxRateIsNotNull() {
            addCriterion("TAX_RATE is not null");
            return (Criteria) this;
        }

        public Criteria andTaxRateEqualTo(BigDecimal value) {
            addCriterion("TAX_RATE =", value, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateNotEqualTo(BigDecimal value) {
            addCriterion("TAX_RATE <>", value, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateGreaterThan(BigDecimal value) {
            addCriterion("TAX_RATE >", value, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("TAX_RATE >=", value, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateLessThan(BigDecimal value) {
            addCriterion("TAX_RATE <", value, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateLessThanOrEqualTo(BigDecimal value) {
            addCriterion("TAX_RATE <=", value, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateIn(List<BigDecimal> values) {
            addCriterion("TAX_RATE in", values, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateNotIn(List<BigDecimal> values) {
            addCriterion("TAX_RATE not in", values, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TAX_RATE between", value1, value2, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TAX_RATE not between", value1, value2, "taxRate");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountIsNull() {
            addCriterion("INCLUDE_TAX_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountIsNotNull() {
            addCriterion("INCLUDE_TAX_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountEqualTo(BigDecimal value) {
            addCriterion("INCLUDE_TAX_AMOUNT =", value, "includeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountNotEqualTo(BigDecimal value) {
            addCriterion("INCLUDE_TAX_AMOUNT <>", value, "includeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountGreaterThan(BigDecimal value) {
            addCriterion("INCLUDE_TAX_AMOUNT >", value, "includeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("INCLUDE_TAX_AMOUNT >=", value, "includeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountLessThan(BigDecimal value) {
            addCriterion("INCLUDE_TAX_AMOUNT <", value, "includeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("INCLUDE_TAX_AMOUNT <=", value, "includeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountIn(List<BigDecimal> values) {
            addCriterion("INCLUDE_TAX_AMOUNT in", values, "includeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountNotIn(List<BigDecimal> values) {
            addCriterion("INCLUDE_TAX_AMOUNT not in", values, "includeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("INCLUDE_TAX_AMOUNT between", value1, value2, "includeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andIncludeTaxAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("INCLUDE_TAX_AMOUNT not between", value1, value2, "includeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountIsNull() {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountIsNotNull() {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountEqualTo(BigDecimal value) {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT =", value, "notIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountNotEqualTo(BigDecimal value) {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT <>", value, "notIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountGreaterThan(BigDecimal value) {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT >", value, "notIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT >=", value, "notIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountLessThan(BigDecimal value) {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT <", value, "notIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT <=", value, "notIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountIn(List<BigDecimal> values) {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT in", values, "notIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountNotIn(List<BigDecimal> values) {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT not in", values, "notIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT between", value1, value2, "notIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andNotIncludeTaxAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("NOT_INCLUDE_TAX_AMOUNT not between", value1, value2, "notIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountIsNull() {
            addCriterion("TAX_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andTaxAmountIsNotNull() {
            addCriterion("TAX_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andTaxAmountEqualTo(BigDecimal value) {
            addCriterion("TAX_AMOUNT =", value, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountNotEqualTo(BigDecimal value) {
            addCriterion("TAX_AMOUNT <>", value, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountGreaterThan(BigDecimal value) {
            addCriterion("TAX_AMOUNT >", value, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("TAX_AMOUNT >=", value, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountLessThan(BigDecimal value) {
            addCriterion("TAX_AMOUNT <", value, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("TAX_AMOUNT <=", value, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountIn(List<BigDecimal> values) {
            addCriterion("TAX_AMOUNT in", values, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountNotIn(List<BigDecimal> values) {
            addCriterion("TAX_AMOUNT not in", values, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TAX_AMOUNT between", value1, value2, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTaxAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TAX_AMOUNT not between", value1, value2, "taxAmount");
            return (Criteria) this;
        }

        public Criteria andTotalAmountIsNull() {
            addCriterion("TOTAL_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andTotalAmountIsNotNull() {
            addCriterion("TOTAL_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andTotalAmountEqualTo(BigDecimal value) {
            addCriterion("TOTAL_AMOUNT =", value, "totalAmount");
            return (Criteria) this;
        }

        public Criteria andTotalAmountNotEqualTo(BigDecimal value) {
            addCriterion("TOTAL_AMOUNT <>", value, "totalAmount");
            return (Criteria) this;
        }

        public Criteria andTotalAmountGreaterThan(BigDecimal value) {
            addCriterion("TOTAL_AMOUNT >", value, "totalAmount");
            return (Criteria) this;
        }

        public Criteria andTotalAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("TOTAL_AMOUNT >=", value, "totalAmount");
            return (Criteria) this;
        }

        public Criteria andTotalAmountLessThan(BigDecimal value) {
            addCriterion("TOTAL_AMOUNT <", value, "totalAmount");
            return (Criteria) this;
        }

        public Criteria andTotalAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("TOTAL_AMOUNT <=", value, "totalAmount");
            return (Criteria) this;
        }

        public Criteria andTotalAmountIn(List<BigDecimal> values) {
            addCriterion("TOTAL_AMOUNT in", values, "totalAmount");
            return (Criteria) this;
        }

        public Criteria andTotalAmountNotIn(List<BigDecimal> values) {
            addCriterion("TOTAL_AMOUNT not in", values, "totalAmount");
            return (Criteria) this;
        }

        public Criteria andTotalAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TOTAL_AMOUNT between", value1, value2, "totalAmount");
            return (Criteria) this;
        }

        public Criteria andTotalAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TOTAL_AMOUNT not between", value1, value2, "totalAmount");
            return (Criteria) this;
        }

        public Criteria andDeductionAmountIsNull() {
            addCriterion("DEDUCTION_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andDeductionAmountIsNotNull() {
            addCriterion("DEDUCTION_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andDeductionAmountEqualTo(BigDecimal value) {
            addCriterion("DEDUCTION_AMOUNT =", value, "deductionAmount");
            return (Criteria) this;
        }

        public Criteria andDeductionAmountNotEqualTo(BigDecimal value) {
            addCriterion("DEDUCTION_AMOUNT <>", value, "deductionAmount");
            return (Criteria) this;
        }

        public Criteria andDeductionAmountGreaterThan(BigDecimal value) {
            addCriterion("DEDUCTION_AMOUNT >", value, "deductionAmount");
            return (Criteria) this;
        }

        public Criteria andDeductionAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("DEDUCTION_AMOUNT >=", value, "deductionAmount");
            return (Criteria) this;
        }

        public Criteria andDeductionAmountLessThan(BigDecimal value) {
            addCriterion("DEDUCTION_AMOUNT <", value, "deductionAmount");
            return (Criteria) this;
        }

        public Criteria andDeductionAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("DEDUCTION_AMOUNT <=", value, "deductionAmount");
            return (Criteria) this;
        }

        public Criteria andDeductionAmountIn(List<BigDecimal> values) {
            addCriterion("DEDUCTION_AMOUNT in", values, "deductionAmount");
            return (Criteria) this;
        }

        public Criteria andDeductionAmountNotIn(List<BigDecimal> values) {
            addCriterion("DEDUCTION_AMOUNT not in", values, "deductionAmount");
            return (Criteria) this;
        }

        public Criteria andDeductionAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("DEDUCTION_AMOUNT between", value1, value2, "deductionAmount");
            return (Criteria) this;
        }

        public Criteria andDeductionAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("DEDUCTION_AMOUNT not between", value1, value2, "deductionAmount");
            return (Criteria) this;
        }

        public Criteria andPostingTimeIsNull() {
            addCriterion("POSTING_TIME is null");
            return (Criteria) this;
        }

        public Criteria andPostingTimeIsNotNull() {
            addCriterion("POSTING_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andPostingTimeEqualTo(Date value) {
            addCriterion("POSTING_TIME =", value, "postingTime");
            return (Criteria) this;
        }

        public Criteria andPostingTimeNotEqualTo(Date value) {
            addCriterion("POSTING_TIME <>", value, "postingTime");
            return (Criteria) this;
        }

        public Criteria andPostingTimeGreaterThan(Date value) {
            addCriterion("POSTING_TIME >", value, "postingTime");
            return (Criteria) this;
        }

        public Criteria andPostingTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("POSTING_TIME >=", value, "postingTime");
            return (Criteria) this;
        }

        public Criteria andPostingTimeLessThan(Date value) {
            addCriterion("POSTING_TIME <", value, "postingTime");
            return (Criteria) this;
        }

        public Criteria andPostingTimeLessThanOrEqualTo(Date value) {
            addCriterion("POSTING_TIME <=", value, "postingTime");
            return (Criteria) this;
        }

        public Criteria andPostingTimeIn(List<Date> values) {
            addCriterion("POSTING_TIME in", values, "postingTime");
            return (Criteria) this;
        }

        public Criteria andPostingTimeNotIn(List<Date> values) {
            addCriterion("POSTING_TIME not in", values, "postingTime");
            return (Criteria) this;
        }

        public Criteria andPostingTimeBetween(Date value1, Date value2) {
            addCriterion("POSTING_TIME between", value1, value2, "postingTime");
            return (Criteria) this;
        }

        public Criteria andPostingTimeNotBetween(Date value1, Date value2) {
            addCriterion("POSTING_TIME not between", value1, value2, "postingTime");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoIsNull() {
            addCriterion("SAP_INVOICE_NO is null");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoIsNotNull() {
            addCriterion("SAP_INVOICE_NO is not null");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoEqualTo(String value) {
            addCriterion("SAP_INVOICE_NO =", value, "sapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoNotEqualTo(String value) {
            addCriterion("SAP_INVOICE_NO <>", value, "sapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoGreaterThan(String value) {
            addCriterion("SAP_INVOICE_NO >", value, "sapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoGreaterThanOrEqualTo(String value) {
            addCriterion("SAP_INVOICE_NO >=", value, "sapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoLessThan(String value) {
            addCriterion("SAP_INVOICE_NO <", value, "sapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoLessThanOrEqualTo(String value) {
            addCriterion("SAP_INVOICE_NO <=", value, "sapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoLike(String value) {
            addCriterion("SAP_INVOICE_NO like", value, "sapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoNotLike(String value) {
            addCriterion("SAP_INVOICE_NO not like", value, "sapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoIn(List<String> values) {
            addCriterion("SAP_INVOICE_NO in", values, "sapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoNotIn(List<String> values) {
            addCriterion("SAP_INVOICE_NO not in", values, "sapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoBetween(String value1, String value2) {
            addCriterion("SAP_INVOICE_NO between", value1, value2, "sapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andSapInvoiceNoNotBetween(String value1, String value2) {
            addCriterion("SAP_INVOICE_NO not between", value1, value2, "sapInvoiceNo");
            return (Criteria) this;
        }

        public Criteria andTaxCodeIsNull() {
            addCriterion("TAX_CODE is null");
            return (Criteria) this;
        }

        public Criteria andTaxCodeIsNotNull() {
            addCriterion("TAX_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andTaxCodeEqualTo(String value) {
            addCriterion("TAX_CODE =", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeNotEqualTo(String value) {
            addCriterion("TAX_CODE <>", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeGreaterThan(String value) {
            addCriterion("TAX_CODE >", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeGreaterThanOrEqualTo(String value) {
            addCriterion("TAX_CODE >=", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeLessThan(String value) {
            addCriterion("TAX_CODE <", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeLessThanOrEqualTo(String value) {
            addCriterion("TAX_CODE <=", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeLike(String value) {
            addCriterion("TAX_CODE like", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeNotLike(String value) {
            addCriterion("TAX_CODE not like", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeIn(List<String> values) {
            addCriterion("TAX_CODE in", values, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeNotIn(List<String> values) {
            addCriterion("TAX_CODE not in", values, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeBetween(String value1, String value2) {
            addCriterion("TAX_CODE between", value1, value2, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeNotBetween(String value1, String value2) {
            addCriterion("TAX_CODE not between", value1, value2, "taxCode");
            return (Criteria) this;
        }

        public Criteria andInvoiceFlagIsNull() {
            addCriterion("INVOICE_FLAG is null");
            return (Criteria) this;
        }

        public Criteria andInvoiceFlagIsNotNull() {
            addCriterion("INVOICE_FLAG is not null");
            return (Criteria) this;
        }

        public Criteria andInvoiceFlagEqualTo(Integer value) {
            addCriterion("INVOICE_FLAG =", value, "invoiceFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceFlagNotEqualTo(Integer value) {
            addCriterion("INVOICE_FLAG <>", value, "invoiceFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceFlagGreaterThan(Integer value) {
            addCriterion("INVOICE_FLAG >", value, "invoiceFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceFlagGreaterThanOrEqualTo(Integer value) {
            addCriterion("INVOICE_FLAG >=", value, "invoiceFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceFlagLessThan(Integer value) {
            addCriterion("INVOICE_FLAG <", value, "invoiceFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceFlagLessThanOrEqualTo(Integer value) {
            addCriterion("INVOICE_FLAG <=", value, "invoiceFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceFlagIn(List<Integer> values) {
            addCriterion("INVOICE_FLAG in", values, "invoiceFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceFlagNotIn(List<Integer> values) {
            addCriterion("INVOICE_FLAG not in", values, "invoiceFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceFlagBetween(Integer value1, Integer value2) {
            addCriterion("INVOICE_FLAG between", value1, value2, "invoiceFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceFlagNotBetween(Integer value1, Integer value2) {
            addCriterion("INVOICE_FLAG not between", value1, value2, "invoiceFlag");
            return (Criteria) this;
        }

        public Criteria andIsRebateIsNull() {
            addCriterion("IS_REBATE is null");
            return (Criteria) this;
        }

        public Criteria andIsRebateIsNotNull() {
            addCriterion("IS_REBATE is not null");
            return (Criteria) this;
        }

        public Criteria andIsRebateEqualTo(Integer value) {
            addCriterion("IS_REBATE =", value, "isRebate");
            return (Criteria) this;
        }

        public Criteria andIsRebateNotEqualTo(Integer value) {
            addCriterion("IS_REBATE <>", value, "isRebate");
            return (Criteria) this;
        }

        public Criteria andIsRebateGreaterThan(Integer value) {
            addCriterion("IS_REBATE >", value, "isRebate");
            return (Criteria) this;
        }

        public Criteria andIsRebateGreaterThanOrEqualTo(Integer value) {
            addCriterion("IS_REBATE >=", value, "isRebate");
            return (Criteria) this;
        }

        public Criteria andIsRebateLessThan(Integer value) {
            addCriterion("IS_REBATE <", value, "isRebate");
            return (Criteria) this;
        }

        public Criteria andIsRebateLessThanOrEqualTo(Integer value) {
            addCriterion("IS_REBATE <=", value, "isRebate");
            return (Criteria) this;
        }

        public Criteria andIsRebateIn(List<Integer> values) {
            addCriterion("IS_REBATE in", values, "isRebate");
            return (Criteria) this;
        }

        public Criteria andIsRebateNotIn(List<Integer> values) {
            addCriterion("IS_REBATE not in", values, "isRebate");
            return (Criteria) this;
        }

        public Criteria andIsRebateBetween(Integer value1, Integer value2) {
            addCriterion("IS_REBATE between", value1, value2, "isRebate");
            return (Criteria) this;
        }

        public Criteria andIsRebateNotBetween(Integer value1, Integer value2) {
            addCriterion("IS_REBATE not between", value1, value2, "isRebate");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountIsNull() {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountIsNotNull() {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountEqualTo(BigDecimal value) {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT =", value, "rebateNotIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountNotEqualTo(BigDecimal value) {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT <>", value, "rebateNotIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountGreaterThan(BigDecimal value) {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT >", value, "rebateNotIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT >=", value, "rebateNotIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountLessThan(BigDecimal value) {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT <", value, "rebateNotIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT <=", value, "rebateNotIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountIn(List<BigDecimal> values) {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT in", values, "rebateNotIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountNotIn(List<BigDecimal> values) {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT not in", values, "rebateNotIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT between", value1, value2, "rebateNotIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateNotIncludeTaxAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("REBATE_NOT_INCLUDE_TAX_AMOUNT not between", value1, value2, "rebateNotIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountIsNull() {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountIsNotNull() {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountEqualTo(BigDecimal value) {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT =", value, "rebateIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountNotEqualTo(BigDecimal value) {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT <>", value, "rebateIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountGreaterThan(BigDecimal value) {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT >", value, "rebateIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT >=", value, "rebateIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountLessThan(BigDecimal value) {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT <", value, "rebateIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT <=", value, "rebateIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountIn(List<BigDecimal> values) {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT in", values, "rebateIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountNotIn(List<BigDecimal> values) {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT not in", values, "rebateIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT between", value1, value2, "rebateIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateIncludeTaxAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("REBATE_INCLUDE_TAX_AMOUNT not between", value1, value2, "rebateIncludeTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountIsNull() {
            addCriterion("REBATE_TAX_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountIsNotNull() {
            addCriterion("REBATE_TAX_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountEqualTo(BigDecimal value) {
            addCriterion("REBATE_TAX_AMOUNT =", value, "rebateTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountNotEqualTo(BigDecimal value) {
            addCriterion("REBATE_TAX_AMOUNT <>", value, "rebateTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountGreaterThan(BigDecimal value) {
            addCriterion("REBATE_TAX_AMOUNT >", value, "rebateTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("REBATE_TAX_AMOUNT >=", value, "rebateTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountLessThan(BigDecimal value) {
            addCriterion("REBATE_TAX_AMOUNT <", value, "rebateTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("REBATE_TAX_AMOUNT <=", value, "rebateTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountIn(List<BigDecimal> values) {
            addCriterion("REBATE_TAX_AMOUNT in", values, "rebateTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountNotIn(List<BigDecimal> values) {
            addCriterion("REBATE_TAX_AMOUNT not in", values, "rebateTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("REBATE_TAX_AMOUNT between", value1, value2, "rebateTaxAmount");
            return (Criteria) this;
        }

        public Criteria andRebateTaxAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("REBATE_TAX_AMOUNT not between", value1, value2, "rebateTaxAmount");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignIsNull() {
            addCriterion("BILL_TYPE_SIGN is null");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignIsNotNull() {
            addCriterion("BILL_TYPE_SIGN is not null");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignEqualTo(String value) {
            addCriterion("BILL_TYPE_SIGN =", value, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignNotEqualTo(String value) {
            addCriterion("BILL_TYPE_SIGN <>", value, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignGreaterThan(String value) {
            addCriterion("BILL_TYPE_SIGN >", value, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignGreaterThanOrEqualTo(String value) {
            addCriterion("BILL_TYPE_SIGN >=", value, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignLessThan(String value) {
            addCriterion("BILL_TYPE_SIGN <", value, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignLessThanOrEqualTo(String value) {
            addCriterion("BILL_TYPE_SIGN <=", value, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignLike(String value) {
            addCriterion("BILL_TYPE_SIGN like", value, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignNotLike(String value) {
            addCriterion("BILL_TYPE_SIGN not like", value, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignIn(List<String> values) {
            addCriterion("BILL_TYPE_SIGN in", values, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignNotIn(List<String> values) {
            addCriterion("BILL_TYPE_SIGN not in", values, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignBetween(String value1, String value2) {
            addCriterion("BILL_TYPE_SIGN between", value1, value2, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andBillTypeSignNotBetween(String value1, String value2) {
            addCriterion("BILL_TYPE_SIGN not between", value1, value2, "billTypeSign");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagIsNull() {
            addCriterion("INVOICE_SIGN_FLAG is null");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagIsNotNull() {
            addCriterion("INVOICE_SIGN_FLAG is not null");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagEqualTo(Integer value) {
            addCriterion("INVOICE_SIGN_FLAG =", value, "invoiceSignFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagNotEqualTo(Integer value) {
            addCriterion("INVOICE_SIGN_FLAG <>", value, "invoiceSignFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagGreaterThan(Integer value) {
            addCriterion("INVOICE_SIGN_FLAG >", value, "invoiceSignFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagGreaterThanOrEqualTo(Integer value) {
            addCriterion("INVOICE_SIGN_FLAG >=", value, "invoiceSignFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagLessThan(Integer value) {
            addCriterion("INVOICE_SIGN_FLAG <", value, "invoiceSignFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagLessThanOrEqualTo(Integer value) {
            addCriterion("INVOICE_SIGN_FLAG <=", value, "invoiceSignFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagIn(List<Integer> values) {
            addCriterion("INVOICE_SIGN_FLAG in", values, "invoiceSignFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagNotIn(List<Integer> values) {
            addCriterion("INVOICE_SIGN_FLAG not in", values, "invoiceSignFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagBetween(Integer value1, Integer value2) {
            addCriterion("INVOICE_SIGN_FLAG between", value1, value2, "invoiceSignFlag");
            return (Criteria) this;
        }

        public Criteria andInvoiceSignFlagNotBetween(Integer value1, Integer value2) {
            addCriterion("INVOICE_SIGN_FLAG not between", value1, value2, "invoiceSignFlag");
            return (Criteria) this;
        }
    }

    public static class Criteria extends GeneratedCriteria implements Serializable {
        private static final long serialVersionUID = 1L;

        protected Criteria() {
            super();
        }
    }

    public static class Criterion implements Serializable {
        private String condition;

        private Object value;

        private Object secondValue;

        private boolean noValue;

        private boolean singleValue;

        private boolean betweenValue;

        private boolean listValue;

        private String typeHandler;

        private static final long serialVersionUID = 1L;

        public String getCondition() {
            return condition;
        }

        public Object getValue() {
            return value;
        }

        public Object getSecondValue() {
            return secondValue;
        }

        public boolean isNoValue() {
            return noValue;
        }

        public boolean isSingleValue() {
            return singleValue;
        }

        public boolean isBetweenValue() {
            return betweenValue;
        }

        public boolean isListValue() {
            return listValue;
        }

        public String getTypeHandler() {
            return typeHandler;
        }

        protected Criterion(String condition) {
            super();
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
        }

        protected Criterion(String condition, Object value, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            if (value instanceof List<?>) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
        }

        protected Criterion(String condition, Object value) {
            this(condition, value, null);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
        }

        protected Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null);
        }
    }
}