package com.els.base.invoice.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.invoice.dao.BillInvoiceMapper;
import com.els.base.invoice.entity.BillInvoice;
import com.els.base.invoice.entity.BillInvoiceExample;
import com.els.base.invoice.service.BillInvoiceService;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

@Service("defaultBillInvoiceService")
public class BillInvoiceServiceImpl implements BillInvoiceService {

    @Resource
    protected BillInvoiceMapper billInvoiceMapper;

    @CacheEvict(value = {"billInvoice"}, allEntries = true)
    @Transactional
    @Override
    public void deleteByExample(BillInvoiceExample example) {
        Assert.isNotEmpty(example.getOredCriteria(),"不能进行全表删除，请检查！");
        this.billInvoiceMapper.deleteByExample(example);
    }

    @CacheEvict(value = {"billInvoice"}, allEntries = true)
    @Transactional
    @Override
    public int updateByExampleSelective(BillInvoice record, BillInvoiceExample example) {
        return this.billInvoiceMapper.updateByExampleSelective(record, example);
    }

    @Cacheable(value = "billInvoice", keyGenerator = "redisKeyGenerator")
    @Override
    public int countByExample(BillInvoiceExample example) {
        return this.billInvoiceMapper.countByExample(example);
    }

    @CacheEvict(value = {"billInvoice"}, allEntries = true)
    @Transactional
    @Override
    public void updateBillInvoiceFlag(List<String> billIds, Integer flag) {
        Assert.isNotNull(flag);
        Assert.isNotNull(billIds);
        BillInvoiceExample billInvoiceExample = new BillInvoiceExample();
        billInvoiceExample.createCriteria()
                .andBillIdIn(billIds);
        BillInvoice billInvoice = new BillInvoice();
        billInvoice.setInvoiceFlag(flag);
        int i = this.billInvoiceMapper.countByExample(billInvoiceExample);
        if (i > 0) {
            this.billInvoiceMapper.updateByExampleSelective(billInvoice, billInvoiceExample);
        }
    }

    @Cacheable(value = "billInvoice", keyGenerator = "redisKeyGenerator")
    @Override
    public List<BillInvoice> queryByBillId(String billId) {
        Assert.isNotBlank(billId, "发票ID不能为空！");
        BillInvoiceExample billInvoiceExample = new BillInvoiceExample();
        billInvoiceExample.createCriteria()
                .andBillIdEqualTo(billId);
        return this.billInvoiceMapper.selectByExample(billInvoiceExample);
    }

    @CacheEvict(value = {"billInvoice"}, allEntries = true)
    @Override
    public void addObj(BillInvoice t) {
        this.billInvoiceMapper.insertSelective(t);
    }

    @CacheEvict(value = {"billInvoice"}, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.billInvoiceMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = {"billInvoice"}, allEntries = true)
    @Override
    public void modifyObj(BillInvoice t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.billInvoiceMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "billInvoice", keyGenerator = "redisKeyGenerator")
    @Override
    public BillInvoice queryObjById(String id) {
        return this.billInvoiceMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "billInvoice", keyGenerator = "redisKeyGenerator")
    @Override
    public List<BillInvoice> queryAllObjByExample(BillInvoiceExample example) {
        return this.billInvoiceMapper.selectByExample(example);
    }

    @Cacheable(value = "billInvoice", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<BillInvoice> queryObjByPage(BillInvoiceExample example) {
        PageView<BillInvoice> pageView = example.getPageView();
        pageView.setQueryResult(this.billInvoiceMapper.selectByExampleByPage(example));
        return pageView;
    }
}