package com.els.base.payment.command;

import com.els.base.common.AbstractBillCommand;
import com.els.base.common.BillInvorker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.payment.service.BillPaymentImportFromSapService;
import com.els.base.payment.vo.BillPaymentVo;
import com.els.base.utils.SpringContextHolder;
import org.apache.commons.lang.StringUtils;

import java.util.Date;

/**
 * 从SAP导入付款明细
 *
 * @author liuhf
 */
public class ImportCommand extends AbstractBillCommand<String> {

    BillPaymentVo billPaymentVo;

    public ImportCommand() {
    }

    public ImportCommand(BillPaymentVo billPaymentVo) {
        this.billPaymentVo = billPaymentVo;
    }

    @Override
    public String execute(BillInvorker billInvorker) {

        this.billInvorker = billInvorker;

        this.validate(billPaymentVo);

        this.processor(billPaymentVo);

        return null;
    }

    private void processor(BillPaymentVo billPaymentVo) {

        //导入付款明细和未付款明细
        BillPaymentImportFromSapService billPaymentImportFromSapService=SpringContextHolder.getOneBean(BillPaymentImportFromSapService.class);
        billPaymentImportFromSapService.importBillPaymentFromSap(billPaymentVo.getType(),billPaymentVo.getStartYear(),
                billPaymentVo.getEndYear(),billPaymentVo.getPaymentStartTime(),billPaymentVo.getPaymentEndTime(),billPaymentVo.getCompanySapCode());

    }

    private void validate(BillPaymentVo billPaymentVo) {

        Assert.isNotNull(billPaymentVo, "参数不能为空！");
        Assert.isNotBlank(billPaymentVo.getType(), "付款类型不能为空！");
        Assert.isNotBlank(billPaymentVo.getCompanySapCode(), "供应商SAP编码不能为空！");
        Assert.isNotNull(billPaymentVo.getStartYear(), "会计开始年度不能为空！");
        Assert.isNotNull(billPaymentVo.getEndYear(), "会计结束年度不能为空！");

        if (!StringUtils.isNumeric(billPaymentVo.getType())) {
            throw new CommonException("类型的值不对，请检查！");
        }

        if (billPaymentVo.getStartYear() > billPaymentVo.getEndYear()) {
            throw new CommonException("会计年限开始时间不能大于结束时间，请检查！");
        }
        Date paymentStartTime = billPaymentVo.getPaymentStartTime();
        Date paymentEndTime = billPaymentVo.getPaymentEndTime();

        if (paymentStartTime != null && paymentEndTime != null) {
            if (paymentStartTime.getTime() > paymentEndTime.getTime()) {
                throw new CommonException("凭证时间开始时间不能大于结束时间，请检查！");
            }
        }
    }


}
