package com.els.base.payment.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value="采购结算管理-付款明细")
public class BillPayment implements Serializable {

    //---- 非自动生成,请勿覆盖----------

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this,ToStringStyle.MULTI_LINE_STYLE);
    }

    //---- 非自动生成,请勿覆盖----------

    @ApiModelProperty("主键ID")
    private String id;

    @ApiModelProperty("采购商公司ID")
    private String purCompanyId;

    @ApiModelProperty("采购商公司SRM编码")
    private String purCompanySrmCode;

    @ApiModelProperty("采购商公司SAP编码")
    private String purCompanySapCode;

    @ApiModelProperty("采购商公司名称")
    private String purCompanyName;

    @ApiModelProperty("采购商公司全称")
    private String purCompanyFullName;

    @ApiModelProperty("供应商公司ID")
    private String supCompanyId;

    @ApiModelProperty("供应商公司名称")
    private String supCompanyName;

    @ApiModelProperty("供应商公司全称")
    private String supCompanyFullName;

    @ApiModelProperty("供应商公司SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商公司SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商公司银行名称")
    private String bankName;

    @ApiModelProperty("供应商公司银行地址")
    private String bankAddress;

    @ApiModelProperty("供应商公司银行账号")
    private String bankAccount;

    @ApiModelProperty("支付申请号")
    private String paymentNo;

    @ApiModelProperty("SAP状态")
    private String sapStatus;

    @ApiModelProperty("支付状态")
    private Integer paymentStatus;

    @ApiModelProperty("支付形式")
    private String paymentType;

    @ApiModelProperty("已支付金额")
    private BigDecimal paymentAmount;

    @ApiModelProperty("支付时间-支付日期")
    private Date paymentTime;

    @ApiModelProperty("申请金额")
    private BigDecimal appliedAmount;

    @ApiModelProperty("支付描述（总账标志描述）")
    private String paymentDesc;

    @ApiModelProperty("分配号")
    private String assignedNo;

    @ApiModelProperty("系统发票-供应商发票号")
    private String invoiceNo;

    @ApiModelProperty("系统发票文本")
    private String invoiceText;

    @ApiModelProperty("发票凭证金额")
    private BigDecimal invoiceAmount;

    @ApiModelProperty("凭证日期")
    private Date voucherTime;

    @ApiModelProperty("创建时间--支付申请单创建日期")
    private Date createTime;

    @ApiModelProperty("会计年度")
    private Integer fiscalYear;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanySapCode() {
        return purCompanySapCode;
    }

    public void setPurCompanySapCode(String purCompanySapCode) {
        this.purCompanySapCode = purCompanySapCode == null ? null : purCompanySapCode.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurCompanyFullName() {
        return purCompanyFullName;
    }

    public void setPurCompanyFullName(String purCompanyFullName) {
        this.purCompanyFullName = purCompanyFullName == null ? null : purCompanyFullName.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupCompanyFullName() {
        return supCompanyFullName;
    }

    public void setSupCompanyFullName(String supCompanyFullName) {
        this.supCompanyFullName = supCompanyFullName == null ? null : supCompanyFullName.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName == null ? null : bankName.trim();
    }

    public String getBankAddress() {
        return bankAddress;
    }

    public void setBankAddress(String bankAddress) {
        this.bankAddress = bankAddress == null ? null : bankAddress.trim();
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount == null ? null : bankAccount.trim();
    }

    public String getPaymentNo() {
        return paymentNo;
    }

    public void setPaymentNo(String paymentNo) {
        this.paymentNo = paymentNo == null ? null : paymentNo.trim();
    }

    public String getSapStatus() {
        return sapStatus;
    }

    public void setSapStatus(String sapStatus) {
        this.sapStatus = sapStatus == null ? null : sapStatus.trim();
    }

    public Integer getPaymentStatus() {
        return paymentStatus;
    }

    public void setPaymentStatus(Integer paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public String getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType == null ? null : paymentType.trim();
    }

    public BigDecimal getPaymentAmount() {
        return paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public Date getPaymentTime() {
        return paymentTime;
    }

    public void setPaymentTime(Date paymentTime) {
        this.paymentTime = paymentTime;
    }

    public BigDecimal getAppliedAmount() {
        return appliedAmount;
    }

    public void setAppliedAmount(BigDecimal appliedAmount) {
        this.appliedAmount = appliedAmount;
    }

    public String getPaymentDesc() {
        return paymentDesc;
    }

    public void setPaymentDesc(String paymentDesc) {
        this.paymentDesc = paymentDesc == null ? null : paymentDesc.trim();
    }

    public String getAssignedNo() {
        return assignedNo;
    }

    public void setAssignedNo(String assignedNo) {
        this.assignedNo = assignedNo == null ? null : assignedNo.trim();
    }

    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo == null ? null : invoiceNo.trim();
    }

    public String getInvoiceText() {
        return invoiceText;
    }

    public void setInvoiceText(String invoiceText) {
        this.invoiceText = invoiceText == null ? null : invoiceText.trim();
    }

    public BigDecimal getInvoiceAmount() {
        return invoiceAmount;
    }

    public void setInvoiceAmount(BigDecimal invoiceAmount) {
        this.invoiceAmount = invoiceAmount;
    }

    public Date getVoucherTime() {
        return voucherTime;
    }

    public void setVoucherTime(Date voucherTime) {
        this.voucherTime = voucherTime;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getFiscalYear() {
        return fiscalYear;
    }

    public void setFiscalYear(Integer fiscalYear) {
        this.fiscalYear = fiscalYear;
    }
}