package com.els.base.payment.entity;

import com.els.base.core.entity.AbstractExample;
import com.els.base.core.entity.PageView;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BillPaymentExample extends AbstractExample<BillPayment> implements Serializable {
    protected String orderByClause;

    protected boolean distinct;

    protected List<Criteria> oredCriteria;

    protected PageView<BillPayment> pageView = new PageView<BillPayment>(1, 10);

    private static final long serialVersionUID = 1L;

    public BillPaymentExample() {
        oredCriteria = new ArrayList<Criteria>();
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getOrderByClause() {
        return orderByClause;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return distinct;
    }

    public List<Criteria> getOredCriteria() {
        return oredCriteria;
    }

    public void or(Criteria criteria) {
        oredCriteria.add(criteria);
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria();
        return criteria;
    }

    public void clear() {
        oredCriteria.clear();
        orderByClause = null;
        distinct = false;
    }

    @Override
    public PageView<BillPayment> getPageView() {
        return pageView;
    }

    @Override
    public void setPageView(PageView<BillPayment> pageView) {
        this.pageView = pageView;
    }

    protected abstract static class GeneratedCriteria implements Serializable {
        protected List<Criterion> criteria;

        private static final long serialVersionUID = 1L;

        protected GeneratedCriteria() {
            super();
            criteria = new ArrayList<Criterion>();
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public List<Criterion> getCriteria() {
            return criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        public Criteria andIdIsNull() {
            addCriterion("ID is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("ID is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(String value) {
            addCriterion("ID =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(String value) {
            addCriterion("ID <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(String value) {
            addCriterion("ID >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(String value) {
            addCriterion("ID >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(String value) {
            addCriterion("ID <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(String value) {
            addCriterion("ID <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLike(String value) {
            addCriterion("ID like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotLike(String value) {
            addCriterion("ID not like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<String> values) {
            addCriterion("ID in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<String> values) {
            addCriterion("ID not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(String value1, String value2) {
            addCriterion("ID between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(String value1, String value2) {
            addCriterion("ID not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdIsNull() {
            addCriterion("PUR_COMPANY_ID is null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdIsNotNull() {
            addCriterion("PUR_COMPANY_ID is not null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdEqualTo(String value) {
            addCriterion("PUR_COMPANY_ID =", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdNotEqualTo(String value) {
            addCriterion("PUR_COMPANY_ID <>", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdGreaterThan(String value) {
            addCriterion("PUR_COMPANY_ID >", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_ID >=", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdLessThan(String value) {
            addCriterion("PUR_COMPANY_ID <", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdLessThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_ID <=", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdLike(String value) {
            addCriterion("PUR_COMPANY_ID like", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdNotLike(String value) {
            addCriterion("PUR_COMPANY_ID not like", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdIn(List<String> values) {
            addCriterion("PUR_COMPANY_ID in", values, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdNotIn(List<String> values) {
            addCriterion("PUR_COMPANY_ID not in", values, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_ID between", value1, value2, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdNotBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_ID not between", value1, value2, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeIsNull() {
            addCriterion("PUR_COMPANY_SRM_CODE is null");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeIsNotNull() {
            addCriterion("PUR_COMPANY_SRM_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeEqualTo(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE =", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeNotEqualTo(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE <>", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeGreaterThan(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE >", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE >=", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeLessThan(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE <", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeLessThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE <=", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeLike(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE like", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeNotLike(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE not like", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeIn(List<String> values) {
            addCriterion("PUR_COMPANY_SRM_CODE in", values, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeNotIn(List<String> values) {
            addCriterion("PUR_COMPANY_SRM_CODE not in", values, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_SRM_CODE between", value1, value2, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeNotBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_SRM_CODE not between", value1, value2, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeIsNull() {
            addCriterion("PUR_COMPANY_SAP_CODE is null");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeIsNotNull() {
            addCriterion("PUR_COMPANY_SAP_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeEqualTo(String value) {
            addCriterion("PUR_COMPANY_SAP_CODE =", value, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeNotEqualTo(String value) {
            addCriterion("PUR_COMPANY_SAP_CODE <>", value, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeGreaterThan(String value) {
            addCriterion("PUR_COMPANY_SAP_CODE >", value, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_SAP_CODE >=", value, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeLessThan(String value) {
            addCriterion("PUR_COMPANY_SAP_CODE <", value, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeLessThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_SAP_CODE <=", value, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeLike(String value) {
            addCriterion("PUR_COMPANY_SAP_CODE like", value, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeNotLike(String value) {
            addCriterion("PUR_COMPANY_SAP_CODE not like", value, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeIn(List<String> values) {
            addCriterion("PUR_COMPANY_SAP_CODE in", values, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeNotIn(List<String> values) {
            addCriterion("PUR_COMPANY_SAP_CODE not in", values, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_SAP_CODE between", value1, value2, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySapCodeNotBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_SAP_CODE not between", value1, value2, "purCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameIsNull() {
            addCriterion("PUR_COMPANY_NAME is null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameIsNotNull() {
            addCriterion("PUR_COMPANY_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameEqualTo(String value) {
            addCriterion("PUR_COMPANY_NAME =", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameNotEqualTo(String value) {
            addCriterion("PUR_COMPANY_NAME <>", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameGreaterThan(String value) {
            addCriterion("PUR_COMPANY_NAME >", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_NAME >=", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameLessThan(String value) {
            addCriterion("PUR_COMPANY_NAME <", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameLessThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_NAME <=", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameLike(String value) {
            addCriterion("PUR_COMPANY_NAME like", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameNotLike(String value) {
            addCriterion("PUR_COMPANY_NAME not like", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameIn(List<String> values) {
            addCriterion("PUR_COMPANY_NAME in", values, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameNotIn(List<String> values) {
            addCriterion("PUR_COMPANY_NAME not in", values, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_NAME between", value1, value2, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameNotBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_NAME not between", value1, value2, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameIsNull() {
            addCriterion("PUR_COMPANY_FULL_NAME is null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameIsNotNull() {
            addCriterion("PUR_COMPANY_FULL_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameEqualTo(String value) {
            addCriterion("PUR_COMPANY_FULL_NAME =", value, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameNotEqualTo(String value) {
            addCriterion("PUR_COMPANY_FULL_NAME <>", value, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameGreaterThan(String value) {
            addCriterion("PUR_COMPANY_FULL_NAME >", value, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_FULL_NAME >=", value, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameLessThan(String value) {
            addCriterion("PUR_COMPANY_FULL_NAME <", value, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameLessThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_FULL_NAME <=", value, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameLike(String value) {
            addCriterion("PUR_COMPANY_FULL_NAME like", value, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameNotLike(String value) {
            addCriterion("PUR_COMPANY_FULL_NAME not like", value, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameIn(List<String> values) {
            addCriterion("PUR_COMPANY_FULL_NAME in", values, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameNotIn(List<String> values) {
            addCriterion("PUR_COMPANY_FULL_NAME not in", values, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_FULL_NAME between", value1, value2, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyFullNameNotBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_FULL_NAME not between", value1, value2, "purCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdIsNull() {
            addCriterion("SUP_COMPANY_ID is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdIsNotNull() {
            addCriterion("SUP_COMPANY_ID is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID =", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID <>", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdGreaterThan(String value) {
            addCriterion("SUP_COMPANY_ID >", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID >=", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdLessThan(String value) {
            addCriterion("SUP_COMPANY_ID <", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID <=", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdLike(String value) {
            addCriterion("SUP_COMPANY_ID like", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotLike(String value) {
            addCriterion("SUP_COMPANY_ID not like", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdIn(List<String> values) {
            addCriterion("SUP_COMPANY_ID in", values, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_ID not in", values, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_ID between", value1, value2, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_ID not between", value1, value2, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameIsNull() {
            addCriterion("SUP_COMPANY_NAME is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameIsNotNull() {
            addCriterion("SUP_COMPANY_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameEqualTo(String value) {
            addCriterion("SUP_COMPANY_NAME =", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_NAME <>", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameGreaterThan(String value) {
            addCriterion("SUP_COMPANY_NAME >", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_NAME >=", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameLessThan(String value) {
            addCriterion("SUP_COMPANY_NAME <", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_NAME <=", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameLike(String value) {
            addCriterion("SUP_COMPANY_NAME like", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameNotLike(String value) {
            addCriterion("SUP_COMPANY_NAME not like", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameIn(List<String> values) {
            addCriterion("SUP_COMPANY_NAME in", values, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_NAME not in", values, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_NAME between", value1, value2, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_NAME not between", value1, value2, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameIsNull() {
            addCriterion("SUP_COMPANY_FULL_NAME is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameIsNotNull() {
            addCriterion("SUP_COMPANY_FULL_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameEqualTo(String value) {
            addCriterion("SUP_COMPANY_FULL_NAME =", value, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_FULL_NAME <>", value, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameGreaterThan(String value) {
            addCriterion("SUP_COMPANY_FULL_NAME >", value, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_FULL_NAME >=", value, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameLessThan(String value) {
            addCriterion("SUP_COMPANY_FULL_NAME <", value, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_FULL_NAME <=", value, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameLike(String value) {
            addCriterion("SUP_COMPANY_FULL_NAME like", value, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameNotLike(String value) {
            addCriterion("SUP_COMPANY_FULL_NAME not like", value, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameIn(List<String> values) {
            addCriterion("SUP_COMPANY_FULL_NAME in", values, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_FULL_NAME not in", values, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_FULL_NAME between", value1, value2, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyFullNameNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_FULL_NAME not between", value1, value2, "supCompanyFullName");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeIsNull() {
            addCriterion("SUP_COMPANY_SRM_CODE is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeIsNotNull() {
            addCriterion("SUP_COMPANY_SRM_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeEqualTo(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE =", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE <>", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeGreaterThan(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE >", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE >=", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeLessThan(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE <", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE <=", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeLike(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE like", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeNotLike(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE not like", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeIn(List<String> values) {
            addCriterion("SUP_COMPANY_SRM_CODE in", values, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_SRM_CODE not in", values, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_SRM_CODE between", value1, value2, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_SRM_CODE not between", value1, value2, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeIsNull() {
            addCriterion("SUP_COMPANY_SAP_CODE is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeIsNotNull() {
            addCriterion("SUP_COMPANY_SAP_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeEqualTo(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE =", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE <>", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeGreaterThan(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE >", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE >=", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeLessThan(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE <", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE <=", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeLike(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE like", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeNotLike(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE not like", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeIn(List<String> values) {
            addCriterion("SUP_COMPANY_SAP_CODE in", values, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_SAP_CODE not in", values, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_SAP_CODE between", value1, value2, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_SAP_CODE not between", value1, value2, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andBankNameIsNull() {
            addCriterion("BANK_NAME is null");
            return (Criteria) this;
        }

        public Criteria andBankNameIsNotNull() {
            addCriterion("BANK_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andBankNameEqualTo(String value) {
            addCriterion("BANK_NAME =", value, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameNotEqualTo(String value) {
            addCriterion("BANK_NAME <>", value, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameGreaterThan(String value) {
            addCriterion("BANK_NAME >", value, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameGreaterThanOrEqualTo(String value) {
            addCriterion("BANK_NAME >=", value, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameLessThan(String value) {
            addCriterion("BANK_NAME <", value, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameLessThanOrEqualTo(String value) {
            addCriterion("BANK_NAME <=", value, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameLike(String value) {
            addCriterion("BANK_NAME like", value, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameNotLike(String value) {
            addCriterion("BANK_NAME not like", value, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameIn(List<String> values) {
            addCriterion("BANK_NAME in", values, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameNotIn(List<String> values) {
            addCriterion("BANK_NAME not in", values, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameBetween(String value1, String value2) {
            addCriterion("BANK_NAME between", value1, value2, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameNotBetween(String value1, String value2) {
            addCriterion("BANK_NAME not between", value1, value2, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankAddressIsNull() {
            addCriterion("BANK_ADDRESS is null");
            return (Criteria) this;
        }

        public Criteria andBankAddressIsNotNull() {
            addCriterion("BANK_ADDRESS is not null");
            return (Criteria) this;
        }

        public Criteria andBankAddressEqualTo(String value) {
            addCriterion("BANK_ADDRESS =", value, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressNotEqualTo(String value) {
            addCriterion("BANK_ADDRESS <>", value, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressGreaterThan(String value) {
            addCriterion("BANK_ADDRESS >", value, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressGreaterThanOrEqualTo(String value) {
            addCriterion("BANK_ADDRESS >=", value, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressLessThan(String value) {
            addCriterion("BANK_ADDRESS <", value, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressLessThanOrEqualTo(String value) {
            addCriterion("BANK_ADDRESS <=", value, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressLike(String value) {
            addCriterion("BANK_ADDRESS like", value, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressNotLike(String value) {
            addCriterion("BANK_ADDRESS not like", value, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressIn(List<String> values) {
            addCriterion("BANK_ADDRESS in", values, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressNotIn(List<String> values) {
            addCriterion("BANK_ADDRESS not in", values, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressBetween(String value1, String value2) {
            addCriterion("BANK_ADDRESS between", value1, value2, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressNotBetween(String value1, String value2) {
            addCriterion("BANK_ADDRESS not between", value1, value2, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAccountIsNull() {
            addCriterion("BANK_ACCOUNT is null");
            return (Criteria) this;
        }

        public Criteria andBankAccountIsNotNull() {
            addCriterion("BANK_ACCOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andBankAccountEqualTo(String value) {
            addCriterion("BANK_ACCOUNT =", value, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountNotEqualTo(String value) {
            addCriterion("BANK_ACCOUNT <>", value, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountGreaterThan(String value) {
            addCriterion("BANK_ACCOUNT >", value, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountGreaterThanOrEqualTo(String value) {
            addCriterion("BANK_ACCOUNT >=", value, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountLessThan(String value) {
            addCriterion("BANK_ACCOUNT <", value, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountLessThanOrEqualTo(String value) {
            addCriterion("BANK_ACCOUNT <=", value, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountLike(String value) {
            addCriterion("BANK_ACCOUNT like", value, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountNotLike(String value) {
            addCriterion("BANK_ACCOUNT not like", value, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountIn(List<String> values) {
            addCriterion("BANK_ACCOUNT in", values, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountNotIn(List<String> values) {
            addCriterion("BANK_ACCOUNT not in", values, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountBetween(String value1, String value2) {
            addCriterion("BANK_ACCOUNT between", value1, value2, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountNotBetween(String value1, String value2) {
            addCriterion("BANK_ACCOUNT not between", value1, value2, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andPaymentNoIsNull() {
            addCriterion("PAYMENT_NO is null");
            return (Criteria) this;
        }

        public Criteria andPaymentNoIsNotNull() {
            addCriterion("PAYMENT_NO is not null");
            return (Criteria) this;
        }

        public Criteria andPaymentNoEqualTo(String value) {
            addCriterion("PAYMENT_NO =", value, "paymentNo");
            return (Criteria) this;
        }

        public Criteria andPaymentNoNotEqualTo(String value) {
            addCriterion("PAYMENT_NO <>", value, "paymentNo");
            return (Criteria) this;
        }

        public Criteria andPaymentNoGreaterThan(String value) {
            addCriterion("PAYMENT_NO >", value, "paymentNo");
            return (Criteria) this;
        }

        public Criteria andPaymentNoGreaterThanOrEqualTo(String value) {
            addCriterion("PAYMENT_NO >=", value, "paymentNo");
            return (Criteria) this;
        }

        public Criteria andPaymentNoLessThan(String value) {
            addCriterion("PAYMENT_NO <", value, "paymentNo");
            return (Criteria) this;
        }

        public Criteria andPaymentNoLessThanOrEqualTo(String value) {
            addCriterion("PAYMENT_NO <=", value, "paymentNo");
            return (Criteria) this;
        }

        public Criteria andPaymentNoLike(String value) {
            addCriterion("PAYMENT_NO like", value, "paymentNo");
            return (Criteria) this;
        }

        public Criteria andPaymentNoNotLike(String value) {
            addCriterion("PAYMENT_NO not like", value, "paymentNo");
            return (Criteria) this;
        }

        public Criteria andPaymentNoIn(List<String> values) {
            addCriterion("PAYMENT_NO in", values, "paymentNo");
            return (Criteria) this;
        }

        public Criteria andPaymentNoNotIn(List<String> values) {
            addCriterion("PAYMENT_NO not in", values, "paymentNo");
            return (Criteria) this;
        }

        public Criteria andPaymentNoBetween(String value1, String value2) {
            addCriterion("PAYMENT_NO between", value1, value2, "paymentNo");
            return (Criteria) this;
        }

        public Criteria andPaymentNoNotBetween(String value1, String value2) {
            addCriterion("PAYMENT_NO not between", value1, value2, "paymentNo");
            return (Criteria) this;
        }

        public Criteria andSapStatusIsNull() {
            addCriterion("SAP_STATUS is null");
            return (Criteria) this;
        }

        public Criteria andSapStatusIsNotNull() {
            addCriterion("SAP_STATUS is not null");
            return (Criteria) this;
        }

        public Criteria andSapStatusEqualTo(String value) {
            addCriterion("SAP_STATUS =", value, "sapStatus");
            return (Criteria) this;
        }

        public Criteria andSapStatusNotEqualTo(String value) {
            addCriterion("SAP_STATUS <>", value, "sapStatus");
            return (Criteria) this;
        }

        public Criteria andSapStatusGreaterThan(String value) {
            addCriterion("SAP_STATUS >", value, "sapStatus");
            return (Criteria) this;
        }

        public Criteria andSapStatusGreaterThanOrEqualTo(String value) {
            addCriterion("SAP_STATUS >=", value, "sapStatus");
            return (Criteria) this;
        }

        public Criteria andSapStatusLessThan(String value) {
            addCriterion("SAP_STATUS <", value, "sapStatus");
            return (Criteria) this;
        }

        public Criteria andSapStatusLessThanOrEqualTo(String value) {
            addCriterion("SAP_STATUS <=", value, "sapStatus");
            return (Criteria) this;
        }

        public Criteria andSapStatusLike(String value) {
            addCriterion("SAP_STATUS like", value, "sapStatus");
            return (Criteria) this;
        }

        public Criteria andSapStatusNotLike(String value) {
            addCriterion("SAP_STATUS not like", value, "sapStatus");
            return (Criteria) this;
        }

        public Criteria andSapStatusIn(List<String> values) {
            addCriterion("SAP_STATUS in", values, "sapStatus");
            return (Criteria) this;
        }

        public Criteria andSapStatusNotIn(List<String> values) {
            addCriterion("SAP_STATUS not in", values, "sapStatus");
            return (Criteria) this;
        }

        public Criteria andSapStatusBetween(String value1, String value2) {
            addCriterion("SAP_STATUS between", value1, value2, "sapStatus");
            return (Criteria) this;
        }

        public Criteria andSapStatusNotBetween(String value1, String value2) {
            addCriterion("SAP_STATUS not between", value1, value2, "sapStatus");
            return (Criteria) this;
        }

        public Criteria andPaymentStatusIsNull() {
            addCriterion("PAYMENT_STATUS is null");
            return (Criteria) this;
        }

        public Criteria andPaymentStatusIsNotNull() {
            addCriterion("PAYMENT_STATUS is not null");
            return (Criteria) this;
        }

        public Criteria andPaymentStatusEqualTo(Integer value) {
            addCriterion("PAYMENT_STATUS =", value, "paymentStatus");
            return (Criteria) this;
        }

        public Criteria andPaymentStatusNotEqualTo(Integer value) {
            addCriterion("PAYMENT_STATUS <>", value, "paymentStatus");
            return (Criteria) this;
        }

        public Criteria andPaymentStatusGreaterThan(Integer value) {
            addCriterion("PAYMENT_STATUS >", value, "paymentStatus");
            return (Criteria) this;
        }

        public Criteria andPaymentStatusGreaterThanOrEqualTo(Integer value) {
            addCriterion("PAYMENT_STATUS >=", value, "paymentStatus");
            return (Criteria) this;
        }

        public Criteria andPaymentStatusLessThan(Integer value) {
            addCriterion("PAYMENT_STATUS <", value, "paymentStatus");
            return (Criteria) this;
        }

        public Criteria andPaymentStatusLessThanOrEqualTo(Integer value) {
            addCriterion("PAYMENT_STATUS <=", value, "paymentStatus");
            return (Criteria) this;
        }

        public Criteria andPaymentStatusIn(List<Integer> values) {
            addCriterion("PAYMENT_STATUS in", values, "paymentStatus");
            return (Criteria) this;
        }

        public Criteria andPaymentStatusNotIn(List<Integer> values) {
            addCriterion("PAYMENT_STATUS not in", values, "paymentStatus");
            return (Criteria) this;
        }

        public Criteria andPaymentStatusBetween(Integer value1, Integer value2) {
            addCriterion("PAYMENT_STATUS between", value1, value2, "paymentStatus");
            return (Criteria) this;
        }

        public Criteria andPaymentStatusNotBetween(Integer value1, Integer value2) {
            addCriterion("PAYMENT_STATUS not between", value1, value2, "paymentStatus");
            return (Criteria) this;
        }

        public Criteria andPaymentTypeIsNull() {
            addCriterion("PAYMENT_TYPE is null");
            return (Criteria) this;
        }

        public Criteria andPaymentTypeIsNotNull() {
            addCriterion("PAYMENT_TYPE is not null");
            return (Criteria) this;
        }

        public Criteria andPaymentTypeEqualTo(String value) {
            addCriterion("PAYMENT_TYPE =", value, "paymentType");
            return (Criteria) this;
        }

        public Criteria andPaymentTypeNotEqualTo(String value) {
            addCriterion("PAYMENT_TYPE <>", value, "paymentType");
            return (Criteria) this;
        }

        public Criteria andPaymentTypeGreaterThan(String value) {
            addCriterion("PAYMENT_TYPE >", value, "paymentType");
            return (Criteria) this;
        }

        public Criteria andPaymentTypeGreaterThanOrEqualTo(String value) {
            addCriterion("PAYMENT_TYPE >=", value, "paymentType");
            return (Criteria) this;
        }

        public Criteria andPaymentTypeLessThan(String value) {
            addCriterion("PAYMENT_TYPE <", value, "paymentType");
            return (Criteria) this;
        }

        public Criteria andPaymentTypeLessThanOrEqualTo(String value) {
            addCriterion("PAYMENT_TYPE <=", value, "paymentType");
            return (Criteria) this;
        }

        public Criteria andPaymentTypeLike(String value) {
            addCriterion("PAYMENT_TYPE like", value, "paymentType");
            return (Criteria) this;
        }

        public Criteria andPaymentTypeNotLike(String value) {
            addCriterion("PAYMENT_TYPE not like", value, "paymentType");
            return (Criteria) this;
        }

        public Criteria andPaymentTypeIn(List<String> values) {
            addCriterion("PAYMENT_TYPE in", values, "paymentType");
            return (Criteria) this;
        }

        public Criteria andPaymentTypeNotIn(List<String> values) {
            addCriterion("PAYMENT_TYPE not in", values, "paymentType");
            return (Criteria) this;
        }

        public Criteria andPaymentTypeBetween(String value1, String value2) {
            addCriterion("PAYMENT_TYPE between", value1, value2, "paymentType");
            return (Criteria) this;
        }

        public Criteria andPaymentTypeNotBetween(String value1, String value2) {
            addCriterion("PAYMENT_TYPE not between", value1, value2, "paymentType");
            return (Criteria) this;
        }

        public Criteria andPaymentAmountIsNull() {
            addCriterion("PAYMENT_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andPaymentAmountIsNotNull() {
            addCriterion("PAYMENT_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andPaymentAmountEqualTo(BigDecimal value) {
            addCriterion("PAYMENT_AMOUNT =", value, "paymentAmount");
            return (Criteria) this;
        }

        public Criteria andPaymentAmountNotEqualTo(BigDecimal value) {
            addCriterion("PAYMENT_AMOUNT <>", value, "paymentAmount");
            return (Criteria) this;
        }

        public Criteria andPaymentAmountGreaterThan(BigDecimal value) {
            addCriterion("PAYMENT_AMOUNT >", value, "paymentAmount");
            return (Criteria) this;
        }

        public Criteria andPaymentAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("PAYMENT_AMOUNT >=", value, "paymentAmount");
            return (Criteria) this;
        }

        public Criteria andPaymentAmountLessThan(BigDecimal value) {
            addCriterion("PAYMENT_AMOUNT <", value, "paymentAmount");
            return (Criteria) this;
        }

        public Criteria andPaymentAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("PAYMENT_AMOUNT <=", value, "paymentAmount");
            return (Criteria) this;
        }

        public Criteria andPaymentAmountIn(List<BigDecimal> values) {
            addCriterion("PAYMENT_AMOUNT in", values, "paymentAmount");
            return (Criteria) this;
        }

        public Criteria andPaymentAmountNotIn(List<BigDecimal> values) {
            addCriterion("PAYMENT_AMOUNT not in", values, "paymentAmount");
            return (Criteria) this;
        }

        public Criteria andPaymentAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("PAYMENT_AMOUNT between", value1, value2, "paymentAmount");
            return (Criteria) this;
        }

        public Criteria andPaymentAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("PAYMENT_AMOUNT not between", value1, value2, "paymentAmount");
            return (Criteria) this;
        }

        public Criteria andPaymentTimeIsNull() {
            addCriterion("PAYMENT_TIME is null");
            return (Criteria) this;
        }

        public Criteria andPaymentTimeIsNotNull() {
            addCriterion("PAYMENT_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andPaymentTimeEqualTo(Date value) {
            addCriterion("PAYMENT_TIME =", value, "paymentTime");
            return (Criteria) this;
        }

        public Criteria andPaymentTimeNotEqualTo(Date value) {
            addCriterion("PAYMENT_TIME <>", value, "paymentTime");
            return (Criteria) this;
        }

        public Criteria andPaymentTimeGreaterThan(Date value) {
            addCriterion("PAYMENT_TIME >", value, "paymentTime");
            return (Criteria) this;
        }

        public Criteria andPaymentTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("PAYMENT_TIME >=", value, "paymentTime");
            return (Criteria) this;
        }

        public Criteria andPaymentTimeLessThan(Date value) {
            addCriterion("PAYMENT_TIME <", value, "paymentTime");
            return (Criteria) this;
        }

        public Criteria andPaymentTimeLessThanOrEqualTo(Date value) {
            addCriterion("PAYMENT_TIME <=", value, "paymentTime");
            return (Criteria) this;
        }

        public Criteria andPaymentTimeIn(List<Date> values) {
            addCriterion("PAYMENT_TIME in", values, "paymentTime");
            return (Criteria) this;
        }

        public Criteria andPaymentTimeNotIn(List<Date> values) {
            addCriterion("PAYMENT_TIME not in", values, "paymentTime");
            return (Criteria) this;
        }

        public Criteria andPaymentTimeBetween(Date value1, Date value2) {
            addCriterion("PAYMENT_TIME between", value1, value2, "paymentTime");
            return (Criteria) this;
        }

        public Criteria andPaymentTimeNotBetween(Date value1, Date value2) {
            addCriterion("PAYMENT_TIME not between", value1, value2, "paymentTime");
            return (Criteria) this;
        }

        public Criteria andAppliedAmountIsNull() {
            addCriterion("APPLIED_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andAppliedAmountIsNotNull() {
            addCriterion("APPLIED_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andAppliedAmountEqualTo(BigDecimal value) {
            addCriterion("APPLIED_AMOUNT =", value, "appliedAmount");
            return (Criteria) this;
        }

        public Criteria andAppliedAmountNotEqualTo(BigDecimal value) {
            addCriterion("APPLIED_AMOUNT <>", value, "appliedAmount");
            return (Criteria) this;
        }

        public Criteria andAppliedAmountGreaterThan(BigDecimal value) {
            addCriterion("APPLIED_AMOUNT >", value, "appliedAmount");
            return (Criteria) this;
        }

        public Criteria andAppliedAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("APPLIED_AMOUNT >=", value, "appliedAmount");
            return (Criteria) this;
        }

        public Criteria andAppliedAmountLessThan(BigDecimal value) {
            addCriterion("APPLIED_AMOUNT <", value, "appliedAmount");
            return (Criteria) this;
        }

        public Criteria andAppliedAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("APPLIED_AMOUNT <=", value, "appliedAmount");
            return (Criteria) this;
        }

        public Criteria andAppliedAmountIn(List<BigDecimal> values) {
            addCriterion("APPLIED_AMOUNT in", values, "appliedAmount");
            return (Criteria) this;
        }

        public Criteria andAppliedAmountNotIn(List<BigDecimal> values) {
            addCriterion("APPLIED_AMOUNT not in", values, "appliedAmount");
            return (Criteria) this;
        }

        public Criteria andAppliedAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("APPLIED_AMOUNT between", value1, value2, "appliedAmount");
            return (Criteria) this;
        }

        public Criteria andAppliedAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("APPLIED_AMOUNT not between", value1, value2, "appliedAmount");
            return (Criteria) this;
        }

        public Criteria andPaymentDescIsNull() {
            addCriterion("PAYMENT_DESC is null");
            return (Criteria) this;
        }

        public Criteria andPaymentDescIsNotNull() {
            addCriterion("PAYMENT_DESC is not null");
            return (Criteria) this;
        }

        public Criteria andPaymentDescEqualTo(String value) {
            addCriterion("PAYMENT_DESC =", value, "paymentDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentDescNotEqualTo(String value) {
            addCriterion("PAYMENT_DESC <>", value, "paymentDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentDescGreaterThan(String value) {
            addCriterion("PAYMENT_DESC >", value, "paymentDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentDescGreaterThanOrEqualTo(String value) {
            addCriterion("PAYMENT_DESC >=", value, "paymentDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentDescLessThan(String value) {
            addCriterion("PAYMENT_DESC <", value, "paymentDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentDescLessThanOrEqualTo(String value) {
            addCriterion("PAYMENT_DESC <=", value, "paymentDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentDescLike(String value) {
            addCriterion("PAYMENT_DESC like", value, "paymentDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentDescNotLike(String value) {
            addCriterion("PAYMENT_DESC not like", value, "paymentDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentDescIn(List<String> values) {
            addCriterion("PAYMENT_DESC in", values, "paymentDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentDescNotIn(List<String> values) {
            addCriterion("PAYMENT_DESC not in", values, "paymentDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentDescBetween(String value1, String value2) {
            addCriterion("PAYMENT_DESC between", value1, value2, "paymentDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentDescNotBetween(String value1, String value2) {
            addCriterion("PAYMENT_DESC not between", value1, value2, "paymentDesc");
            return (Criteria) this;
        }

        public Criteria andAssignedNoIsNull() {
            addCriterion("ASSIGNED_NO is null");
            return (Criteria) this;
        }

        public Criteria andAssignedNoIsNotNull() {
            addCriterion("ASSIGNED_NO is not null");
            return (Criteria) this;
        }

        public Criteria andAssignedNoEqualTo(String value) {
            addCriterion("ASSIGNED_NO =", value, "assignedNo");
            return (Criteria) this;
        }

        public Criteria andAssignedNoNotEqualTo(String value) {
            addCriterion("ASSIGNED_NO <>", value, "assignedNo");
            return (Criteria) this;
        }

        public Criteria andAssignedNoGreaterThan(String value) {
            addCriterion("ASSIGNED_NO >", value, "assignedNo");
            return (Criteria) this;
        }

        public Criteria andAssignedNoGreaterThanOrEqualTo(String value) {
            addCriterion("ASSIGNED_NO >=", value, "assignedNo");
            return (Criteria) this;
        }

        public Criteria andAssignedNoLessThan(String value) {
            addCriterion("ASSIGNED_NO <", value, "assignedNo");
            return (Criteria) this;
        }

        public Criteria andAssignedNoLessThanOrEqualTo(String value) {
            addCriterion("ASSIGNED_NO <=", value, "assignedNo");
            return (Criteria) this;
        }

        public Criteria andAssignedNoLike(String value) {
            addCriterion("ASSIGNED_NO like", value, "assignedNo");
            return (Criteria) this;
        }

        public Criteria andAssignedNoNotLike(String value) {
            addCriterion("ASSIGNED_NO not like", value, "assignedNo");
            return (Criteria) this;
        }

        public Criteria andAssignedNoIn(List<String> values) {
            addCriterion("ASSIGNED_NO in", values, "assignedNo");
            return (Criteria) this;
        }

        public Criteria andAssignedNoNotIn(List<String> values) {
            addCriterion("ASSIGNED_NO not in", values, "assignedNo");
            return (Criteria) this;
        }

        public Criteria andAssignedNoBetween(String value1, String value2) {
            addCriterion("ASSIGNED_NO between", value1, value2, "assignedNo");
            return (Criteria) this;
        }

        public Criteria andAssignedNoNotBetween(String value1, String value2) {
            addCriterion("ASSIGNED_NO not between", value1, value2, "assignedNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoIsNull() {
            addCriterion("INVOICE_NO is null");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoIsNotNull() {
            addCriterion("INVOICE_NO is not null");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoEqualTo(String value) {
            addCriterion("INVOICE_NO =", value, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoNotEqualTo(String value) {
            addCriterion("INVOICE_NO <>", value, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoGreaterThan(String value) {
            addCriterion("INVOICE_NO >", value, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoGreaterThanOrEqualTo(String value) {
            addCriterion("INVOICE_NO >=", value, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoLessThan(String value) {
            addCriterion("INVOICE_NO <", value, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoLessThanOrEqualTo(String value) {
            addCriterion("INVOICE_NO <=", value, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoLike(String value) {
            addCriterion("INVOICE_NO like", value, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoNotLike(String value) {
            addCriterion("INVOICE_NO not like", value, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoIn(List<String> values) {
            addCriterion("INVOICE_NO in", values, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoNotIn(List<String> values) {
            addCriterion("INVOICE_NO not in", values, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoBetween(String value1, String value2) {
            addCriterion("INVOICE_NO between", value1, value2, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceNoNotBetween(String value1, String value2) {
            addCriterion("INVOICE_NO not between", value1, value2, "invoiceNo");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextIsNull() {
            addCriterion("INVOICE_TEXT is null");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextIsNotNull() {
            addCriterion("INVOICE_TEXT is not null");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextEqualTo(String value) {
            addCriterion("INVOICE_TEXT =", value, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextNotEqualTo(String value) {
            addCriterion("INVOICE_TEXT <>", value, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextGreaterThan(String value) {
            addCriterion("INVOICE_TEXT >", value, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextGreaterThanOrEqualTo(String value) {
            addCriterion("INVOICE_TEXT >=", value, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextLessThan(String value) {
            addCriterion("INVOICE_TEXT <", value, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextLessThanOrEqualTo(String value) {
            addCriterion("INVOICE_TEXT <=", value, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextLike(String value) {
            addCriterion("INVOICE_TEXT like", value, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextNotLike(String value) {
            addCriterion("INVOICE_TEXT not like", value, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextIn(List<String> values) {
            addCriterion("INVOICE_TEXT in", values, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextNotIn(List<String> values) {
            addCriterion("INVOICE_TEXT not in", values, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextBetween(String value1, String value2) {
            addCriterion("INVOICE_TEXT between", value1, value2, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceTextNotBetween(String value1, String value2) {
            addCriterion("INVOICE_TEXT not between", value1, value2, "invoiceText");
            return (Criteria) this;
        }

        public Criteria andInvoiceAmountIsNull() {
            addCriterion("INVOICE_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andInvoiceAmountIsNotNull() {
            addCriterion("INVOICE_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andInvoiceAmountEqualTo(BigDecimal value) {
            addCriterion("INVOICE_AMOUNT =", value, "invoiceAmount");
            return (Criteria) this;
        }

        public Criteria andInvoiceAmountNotEqualTo(BigDecimal value) {
            addCriterion("INVOICE_AMOUNT <>", value, "invoiceAmount");
            return (Criteria) this;
        }

        public Criteria andInvoiceAmountGreaterThan(BigDecimal value) {
            addCriterion("INVOICE_AMOUNT >", value, "invoiceAmount");
            return (Criteria) this;
        }

        public Criteria andInvoiceAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("INVOICE_AMOUNT >=", value, "invoiceAmount");
            return (Criteria) this;
        }

        public Criteria andInvoiceAmountLessThan(BigDecimal value) {
            addCriterion("INVOICE_AMOUNT <", value, "invoiceAmount");
            return (Criteria) this;
        }

        public Criteria andInvoiceAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("INVOICE_AMOUNT <=", value, "invoiceAmount");
            return (Criteria) this;
        }

        public Criteria andInvoiceAmountIn(List<BigDecimal> values) {
            addCriterion("INVOICE_AMOUNT in", values, "invoiceAmount");
            return (Criteria) this;
        }

        public Criteria andInvoiceAmountNotIn(List<BigDecimal> values) {
            addCriterion("INVOICE_AMOUNT not in", values, "invoiceAmount");
            return (Criteria) this;
        }

        public Criteria andInvoiceAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("INVOICE_AMOUNT between", value1, value2, "invoiceAmount");
            return (Criteria) this;
        }

        public Criteria andInvoiceAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("INVOICE_AMOUNT not between", value1, value2, "invoiceAmount");
            return (Criteria) this;
        }

        public Criteria andVoucherTimeIsNull() {
            addCriterion("VOUCHER_TIME is null");
            return (Criteria) this;
        }

        public Criteria andVoucherTimeIsNotNull() {
            addCriterion("VOUCHER_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andVoucherTimeEqualTo(Date value) {
            addCriterion("VOUCHER_TIME =", value, "voucherTime");
            return (Criteria) this;
        }

        public Criteria andVoucherTimeNotEqualTo(Date value) {
            addCriterion("VOUCHER_TIME <>", value, "voucherTime");
            return (Criteria) this;
        }

        public Criteria andVoucherTimeGreaterThan(Date value) {
            addCriterion("VOUCHER_TIME >", value, "voucherTime");
            return (Criteria) this;
        }

        public Criteria andVoucherTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("VOUCHER_TIME >=", value, "voucherTime");
            return (Criteria) this;
        }

        public Criteria andVoucherTimeLessThan(Date value) {
            addCriterion("VOUCHER_TIME <", value, "voucherTime");
            return (Criteria) this;
        }

        public Criteria andVoucherTimeLessThanOrEqualTo(Date value) {
            addCriterion("VOUCHER_TIME <=", value, "voucherTime");
            return (Criteria) this;
        }

        public Criteria andVoucherTimeIn(List<Date> values) {
            addCriterion("VOUCHER_TIME in", values, "voucherTime");
            return (Criteria) this;
        }

        public Criteria andVoucherTimeNotIn(List<Date> values) {
            addCriterion("VOUCHER_TIME not in", values, "voucherTime");
            return (Criteria) this;
        }

        public Criteria andVoucherTimeBetween(Date value1, Date value2) {
            addCriterion("VOUCHER_TIME between", value1, value2, "voucherTime");
            return (Criteria) this;
        }

        public Criteria andVoucherTimeNotBetween(Date value1, Date value2) {
            addCriterion("VOUCHER_TIME not between", value1, value2, "voucherTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("CREATE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("CREATE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("CREATE_TIME =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("CREATE_TIME <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("CREATE_TIME >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("CREATE_TIME <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("CREATE_TIME in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("CREATE_TIME not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andFiscalYearIsNull() {
            addCriterion("FISCAL_YEAR is null");
            return (Criteria) this;
        }

        public Criteria andFiscalYearIsNotNull() {
            addCriterion("FISCAL_YEAR is not null");
            return (Criteria) this;
        }

        public Criteria andFiscalYearEqualTo(Integer value) {
            addCriterion("FISCAL_YEAR =", value, "fiscalYear");
            return (Criteria) this;
        }

        public Criteria andFiscalYearNotEqualTo(Integer value) {
            addCriterion("FISCAL_YEAR <>", value, "fiscalYear");
            return (Criteria) this;
        }

        public Criteria andFiscalYearGreaterThan(Integer value) {
            addCriterion("FISCAL_YEAR >", value, "fiscalYear");
            return (Criteria) this;
        }

        public Criteria andFiscalYearGreaterThanOrEqualTo(Integer value) {
            addCriterion("FISCAL_YEAR >=", value, "fiscalYear");
            return (Criteria) this;
        }

        public Criteria andFiscalYearLessThan(Integer value) {
            addCriterion("FISCAL_YEAR <", value, "fiscalYear");
            return (Criteria) this;
        }

        public Criteria andFiscalYearLessThanOrEqualTo(Integer value) {
            addCriterion("FISCAL_YEAR <=", value, "fiscalYear");
            return (Criteria) this;
        }

        public Criteria andFiscalYearIn(List<Integer> values) {
            addCriterion("FISCAL_YEAR in", values, "fiscalYear");
            return (Criteria) this;
        }

        public Criteria andFiscalYearNotIn(List<Integer> values) {
            addCriterion("FISCAL_YEAR not in", values, "fiscalYear");
            return (Criteria) this;
        }

        public Criteria andFiscalYearBetween(Integer value1, Integer value2) {
            addCriterion("FISCAL_YEAR between", value1, value2, "fiscalYear");
            return (Criteria) this;
        }

        public Criteria andFiscalYearNotBetween(Integer value1, Integer value2) {
            addCriterion("FISCAL_YEAR not between", value1, value2, "fiscalYear");
            return (Criteria) this;
        }
    }

    public static class Criteria extends GeneratedCriteria implements Serializable {
        private static final long serialVersionUID = 1L;

        protected Criteria() {
            super();
        }
    }

    public static class Criterion implements Serializable {
        private String condition;

        private Object value;

        private Object secondValue;

        private boolean noValue;

        private boolean singleValue;

        private boolean betweenValue;

        private boolean listValue;

        private String typeHandler;

        private static final long serialVersionUID = 1L;

        public String getCondition() {
            return condition;
        }

        public Object getValue() {
            return value;
        }

        public Object getSecondValue() {
            return secondValue;
        }

        public boolean isNoValue() {
            return noValue;
        }

        public boolean isSingleValue() {
            return singleValue;
        }

        public boolean isBetweenValue() {
            return betweenValue;
        }

        public boolean isListValue() {
            return listValue;
        }

        public String getTypeHandler() {
            return typeHandler;
        }

        protected Criterion(String condition) {
            super();
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
        }

        protected Criterion(String condition, Object value, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            if (value instanceof List<?>) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
        }

        protected Criterion(String condition, Object value) {
            this(condition, value, null);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
        }

        protected Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null);
        }
    }
}